/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#define _MACRO_ONLY

#include "jsp_kernel.h"
#include "offset.h"		/* INT_TABLE_intmask̂߂ɕKv */

	.set noreorder
	.align 2

/*
 *  ^[Qbgn[hEFAˑ鏉
 */
#ifndef GDB_STUB

	.section .reset
	.global	hardware_init_hook

hardware_init_hook:

	/*
	 * LbV̏
	 */
	mtc0	zero, TagLo
	mtc0	zero, TagHi

	li	t0, 0x80003fe0
	li	t1, 0x80000000
loop_I_cache_clear:
	cache	Index_Store_Tag_I, +0(t0)
	cache	Index_Store_Tag_I, +1(t0)
	bne	t0, t1, loop_I_cache_clear
	addiu	t0, t0, -I_CACHE_LINE_SIZE

	li	t0, 0x80003fe0
	li	t1, 0x80000000
loop_D_cache_clear:
	cache	Index_Store_Tag_D, +0(t0)
	cache	Index_Store_Tag_D, +1(t0)
	bne	t0, t1, loop_D_cache_clear
	addiu	t0, t0, -D_CACHE_LINE_SIZE

	/*
	 * TLB̏
	 */
	mtc0	zero, PageMask
	mtc0	zero, EntryLo0
	mtc0	zero, EntryLo1

	li	t0, TMAX_TLB
	li	t1, 0xA8000000		/* kseg1 ̒DRAM̏gp */
loop_TLB_clear:
	mtc0	t0, Index
	mtc0	t1, EntryHi
	addiu	t0, t0, -1
	addiu	t1, t1, TLB_VPN2	/* 1y[W4koCgŁA2y[W
					   }bsO邽 */
	tlbwi
	bgez	t0, loop_TLB_clear
	nop

	/*
	 * {[h̏
	 */

	/* SDRAM Rg[̏ */
	li	t0, 0x00
	sb	t0, 0xb8006000		/* SRAMC_SWAIT */

	li	t0, 0x02
	sb	t0, 0xb8005000		/* DRAMC_RCD */
	li	t0, 0x02
	sb	t0, 0xb8005010		/* DRAMC_RP */
	li	t0, 0x05
	sb	t0, 0xb8005020		/* DRAMC_RC */
	li	t0, 0x06
	sb	t0, 0xb8005030		/* DRAMC_RRC */
	li	t0, 0x04
	sb	t0, 0xb8005040		/* DRAMC_RAS */
	li	t0, 0x02
	sb	t0, 0xb8005050		/* DRAMC_LAT */
	li	t0, 0x02
	sb	t0, 0xb8005060		/* DRAMC_RSC */
	li	t0, 0x01
	sb	t0, 0xb8005070		/* DRAMC_AP */

	li	t0, 0x00
	sb	t0, 0xb8004000		/* DRAM_INIT */

	/* DRAMtbVp^C}̏ */
	li	t0, 0xb4
	sb	t0, 0xb9005030		/* PCNTL */
	li	t0, 0x1f
	sb	t0, 0xb9005020		/* PCNT2 */
	li	t0, 0x00
	sb	t0, 0xb9005020		/* PCNT2 */

	/* SRAM̏ */

	/* SRAM̑S̈ɑ΂āAx݂sKv */
	la	t0, 0xa0000000
	li	t1, 0x00100000-4
loop_sram_clear:
	add	t2, t1, t0
	sw	zero, (t2)
	bgez	t1, loop_sram_clear
	addiu	t1, t1, -4

	/* 荞݃Rg[̐ݒ */
	sb	zero, 0xb9000000	/* PIC_INT0MGS݂̃}XN */
	sb	zero, 0xb9000010	/* PIC_INT1MGS݂̃}XN */
	sb	zero, 0xb9000020	/* PIC_INTR GݗṽNA */
	li	t0, 0x01		/* ݐ͕Е̂ݎg */
	sb	t0, 0xb9000030		/* PIC_INTEN */

	/*----------*/

	j	ra		/*  Ăяoփ^[  */
	nop

#endif /* GDB_STUB */

/*============================================================================*/

/* ݏɊւAݗv̔f򏈗̃VXeˑ */

	.align 2
	.section .text
	.global proc_interrupt_sys
	.global int_table	/* ݃nh̋[xN^e[u
				   cpu_config.h, cpu_config.cŒ` */

	/*  ĂяoꂽƂA       */
	/*    a1ɃXe[^XWX^ */
	/*    a2ɌWX^       */
	/*  ̒lĂ         */

proc_interrupt_sys:
	and     t2, a2, a1          /*  ݗvrbgɃ}XN  */
	andi    t3, t2, Cause_IP0   /*  IP0rbgo  */
	bne     t3, zero, proc_IP0
	andi    t4, t2, Cause_IP1   /*  IP1rbgo  */
	bne     t4, zero, proc_IP1
	andi    t5, t2, Cause_IP2   /*  IP2rbgo  */
	bne     t5, zero, proc_IP2
	andi    t6, t2, Cause_IP3   /*  IP3rbgo  */
	bne     t6, zero, proc_IP3
	andi    t7, t2, Cause_IP4   /*  IP4rbgo  */
	bne     t7, zero, proc_IP4
	andi    t8, t2, Cause_IP5   /*  IP5rbgo  */
	bne     t8, zero, proc_IP5
	andi    t9, t2, Cause_IP6   /*  IP6rbgo  */
	bne     t9, zero, proc_IP6
	nop

	/* Ȃ炩̌ŕłȂꍇ */
	j       join_interrupt_and_exception
	nop

/*  MIPS3RAxŕ򂵂xł̏	*/
/*    ݗvԍt0ɓ		*/
/*    ݗvNÂ߂̒萔t1ɓ	*/
/*    set_ICU_IPM֔				*/
proc_IP7:   /*  ݗvIP7i^C}j̏ꍇ  */
	xori    t1, zero, Cause_IP7
	j       set_ICU_IPM
	ori     t0, zero, INTNO_IP7

proc_IP0:   /*  ݗvIP0i\tgEFA0j̏ꍇ  */
	xori    t1, zero, Cause_IP0
	j       set_ICU_IPM
	ori     t0, zero, INTNO_IP0

proc_IP1:   /*  ݗvIP1i\tgEFA1j̏ꍇ  */
	xori    t1, zero, Cause_IP1
	j       set_ICU_IPM
	ori     t0, zero, INTNO_IP1

proc_IP2:   /*  ݗvIP2̏ꍇ  */ 
            /*    ݃Rg[ˑ̒`΁As  */
#ifdef PROC_INT0
	PROC_INT0		/* VXeˑŒ`}N */
	xori    t1, zero, Cause_IP2
	j       set_ICU_IPM
	nop
#else /* PROC_INT0 */
	xori    t1, zero, Cause_IP2
	j       set_ICU_IPM
	ori     t0, zero, INTNO_IP2
#endif /* PROC_INT0 */

proc_IP3:   /*  ݗvIP3̏ꍇ  */ 
            /*    ݃Rg[ˑ̒`΁As  */
#ifdef PROC_INT1
	PROC_INT1		/* VXeˑŒ`}N */
	xori    t1, zero, Cause_IP3
	j       set_ICU_IPM
	nop
#else /* PROC_INT1 */
	xori    t1, zero, Cause_IP3
	j       set_ICU_IPM
	ori     t0, zero, INTNO_IP3
#endif /* PROC_INT1 */

proc_IP4:   /*  ݗvIP4̏ꍇ  */ 
            /*    ݃Rg[ˑ̒`΁As  */
#ifdef PROC_INT2
	PROC_INT2		/* VXeˑŒ`}N */
	xori    t1, zero, Cause_IP4
	j       set_ICU_IPM
	nop
#else /* PROC_INT2 */
	xori    t1, zero, Cause_IP4
	j       set_ICU_IPM
	ori     t0, zero, INTNO_IP4
#endif /* PROC_INT2 */

proc_IP5:   /*  ݗvIP5̏ꍇ  */ 
            /*    ݃Rg[ˑ̒`΁As  */
#ifdef PROC_INT3
	PROC_INT3		/* VXeˑŒ`}N */
	xori    t1, zero, Cause_IP5
	j       set_ICU_IPM
	nop
#else /* PROC_INT3 */
	xori    t1, zero, Cause_IP5
	j       set_ICU_IPM
	ori     t0, zero, INTNO_IP5
#endif /* PROC_INT3 */

proc_IP6:   /*  ݗvIP6̏ꍇ  */ 
            /*    ݃Rg[ˑ̒`΁As  */
#ifdef PROC_INT4
	PROC_INT4		/* VXeˑŒ`}N */
	xori    t1, zero, Cause_IP6
#else /* PROC_INT4 */
	xori    t1, zero, Cause_IP6
	ori     t0, zero, INTNO_IP6
#endif /* PROC_INT4 */

/*  ݃Rg[ˑ̃}XNݒ  */
set_ICU_IPM:

#ifdef SET_ICU_IPM
	SET_ICU_IPM	/* ݃}XNݒ肷}N			    */
			/*   sƂɂ́ALɂt0At1͗p */
			/*   Ŕj󂵂Ȃ悤ɁAӂȂ΂ȂȂB   */
#endif /* SET_ICU_IPM */

/*
 *  WX^IPrbgɕێĂe튄݂̊ݗvNAB
 *  t1ɂ́Aݗvrbg𔽓]̂ĂB
 */
	mfc0    t8, Cause
	and     t8, t8, t1
	mtc0    t8, Cause

/*  Xe[^XWX^̃}XNݒCꃋ[`Ăяo  */
/*    t0Ɋݗvԍݒ肳ꂽԂłɗ  */
	la      t3, int_table   /*  [xN^AhX  */
	sll     t4, t0, 3       /*  ݗvԍ8{
				      TNT_TABLE^́A
					nh̃AhX(4oCg)
					{MIPS3RÅ݃}XN(4oCg)
				      ́Av8oCgB */
	add     t5, t3, t4      /*  xN^AhXZo  */
	lw      t6, INT_TABLE_intmask(t5)
           		    	/*  IPM(݋rbg)ǂݏoB
				    ݃}XNȊO̒ĺA
					IErbg̓Zbg
					EXLrbg̓Zbg
				    ԂɂȂĂB*/
	lw      t7, (t5)        /*  Cꃋ[`擪AhXǂݏo  */

	jalr    ra, t7          /*  Cꃋ[`Ăяo  */
	mtc0    t6, Status      /*  ݋GXe[^XWX^̃}XNݒ*/

	mfc0    t0, Status
	ori     t0, t0, SR_EXL  /*  ݋֎~GIErbg̒l͕ێȂ΂Ȃ
						Ȃ̂EXLrbgpB*/
	mtc0    t0, Status

	/*  CP0nU[ĥ߂̎ԉ҂  */
#ifdef NOP_FOR_CP0_HAZARD
	NOP_FOR_CP0_HAZARD
#endif /* NOP_FOR_CP0_HAZARD */

	j	join_interrupt_and_exception
	nop

