/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN  
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_defs.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

/*
 *  vZbTɈˑ`iNios2pj
 *
 *  ̃CN[ht@ĆCkernel.h  sil.h ŃCN[hD
 *  ̃t@C璼ڃCN[h邱Ƃ͂ȂD̃t@CC
 *  N[hOɁCt_stddef.h  itron.h CN[ĥŁC
 *  ɈˑĂ悢D
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

#define OMIT_SIL_ACCESS

/*
 *  GfBA̔]
 *  sil.hł`Ă邪COMIT_SIL_ACCESSɂ肱̃t@C
 *  ANZX֐`Ă邽߁CŒ` 
 */
#ifndef SIL_REV_ENDIAN_H
#define	SIL_REV_ENDIAN_H(data) \
	((VH)((((UH)(data) & 0xff) << 8) | (((UH)(data) >> 8) & 0xff)))
#endif /* SIL_REV_ENDIAN_H */

#ifndef SIL_REV_ENDIAN_W
#define	SIL_REV_ENDIAN_W(data) \
	((VW)((((UW)(data) & 0xff) << 24) | (((UW)(data) & 0xff00) << 8) \
		| (((UW)(data)>> 8) & 0xff00) | (((UW)(data) >> 24) & 0xff)))
#endif /* SIL_REV_ENDIAN_H */


#ifndef NIOS2
#define NIOS2   /* vZbT */
#endif 
/*
 *  vZbTɈˑ`
 */
#ifndef _MACRO_ONLY

typedef	UINT		INHNO;		/* ݃nhԍ */
typedef	UINT		IPM;		/* ݃}XN */
typedef	UINT		EXCNO;		/* CPUOnhԍ */


/*
 *  INTNO^Ɗ݂̋֎~/
 */

typedef	UINT		INTNO;		/* ݔԍ */

extern ER	dis_int(INTNO intno) throw(); 
extern ER	ena_int(INTNO intno) throw();


/*
 *  ^[QbgVXeˑ̃T[rXR[
 */
typedef	UD  SYSUTIM;	/* \]pVXe */
extern  ER  vxget_tim(SYSUTIM *pk_sysutim) throw();


/*
 *  ݋rbg
 */
#define STATUS_PIE 0x01

/*
 *  ׂĂ݂̊֎~
 */
Inline void
_disint_()
{
    UW status;
    
    Asm("rdctl %0, status" : "=r" (status));
    status &= ~STATUS_PIE;
    Asm("wrctl status, %0" :: "r" (status));
}


/*
 *  ݂
 */
Inline void
_enaint_()
{
    UW status;

    Asm("rdctl %0, status" : "=r" (status));
    status |= STATUS_PIE;
    Asm("wrctl status, %0" :: "r" (status));
}


/*
 *  ݃bNԂ̐
 */
#define SIL_PRE_LOC 
#define SIL_LOC_INT()   _disint_()
#define SIL_UNL_INT()   _enaint_()

/*
 * VXe̒f
 */
Inline void
kernel_abort()
{

}


#endif /* _MACRO_ONLY */

/*
 *  vZbT̃GfBA
 */
#define SIL_ENDIAN  SIL_ENDIAN_LITTLE 

#ifndef _MACRO_ONLY

/*
 * ANZX֐
 */

/*
 *  8rbgPʂ̓Ǐo^
 */
Inline VB
sil_reb_mem(VP mem)
{
  return(__builtin_ldbuio(mem));
}

Inline void
sil_wrb_mem(VP mem, VB data)
{
    __builtin_stbio(mem, data);
}


/*
 *  16rbgPʂ̓Ǐo^
 */
Inline VH
sil_reh_mem(VP mem)
{
	return(__builtin_ldhuio(mem));
}

Inline void
sil_wrh_mem(VP mem, VH data)
{
    __builtin_sthio(mem, data);
}


#define	sil_reh_lem(mem)	sil_reh_mem(mem)
#define	sil_wrh_lem(mem, data)	sil_wrh_mem(mem, data)

Inline VH
sil_reh_bem(VP mem)
{
	VH	data;

	data = __builtin_ldhuio(mem);
	return(SIL_REV_ENDIAN_H(data));
}

Inline void
sil_wrh_bem(VP mem, VH data)
{
    __builtin_sthio(mem, SIL_REV_ENDIAN_H(data));
}


/*
 *  32rbgPʂ̓Ǐo^
 */
Inline VW
sil_rew_mem(VP mem)
{
    return(__builtin_ldwio(mem));
}

Inline void
sil_wrw_mem(VP mem, VW data)
{
    __builtin_stwio(mem, data);
}


#define	sil_rew_lem(mem)	sil_rew_mem(mem)
#define	sil_wrw_lem(mem, data)	sil_wrw_mem(mem, data)

Inline VW
sil_rew_bem(VP mem)
{
	VW	data;

	data = __builtin_ldwio(mem);
	return(SIL_REV_ENDIAN_W(data));
}

Inline void
sil_wrw_bem(VP mem, VW data)
{
    __builtin_stwio(mem, SIL_REV_ENDIAN_W(data));
}

/*
 *  ԑ҂
 */
Inline void
sil_dly_nse(UINT dlytim)
{
    
}

#endif /* _MACRO_ONLY */


#endif /* _CPU_DEFS_H_ */
