/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2005 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN    
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: start.S,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

#define _MACRO_ONLY
#include <t_config.h>
#include <sys_defs.h>


     .section .entry, "xa"
     .align 2
     .global __reset
__reset:
#if NIOS2_ICACHE_SIZE > 0
    /* 
     * The assumption here is that the instruction cache size is always
     * a power of two.
     */

#if NIOS2_ICACHE_SIZE > 0x8000
    movhi r2, %hi(NIOS2_ICACHE_SIZE)
#else 
    movui r2, NIOS2_ICACHE_SIZE
#endif
0:
    initi r2
    addi r2, r2, -NIOS2_ICACHE_LINE_SIZE
    bgt r2, zero, 0b
1:

    .pushsection .debug_alt_sim_info
    .int 1, 1, 0b, 1b
    .popsection
#endif /* NIOS2_ICACHE_SIZE > 0 */

#ifndef BOOT_ROM
    movhi r3, %hiadj(_start)
    addi r3, r3, %lo(_start)
    jmp r3    
#else
    br _boot_rom
#endif  /* BOOT_ROM */


#ifdef BOOT_ROM
    .section .text
    .align 2
    .globl _
    .type _boot_rom, @function
_boot_rom:
#if NIOS2_DCACHE_SIZE > 0
#if NIOS2_DCACHE_SIZE > 0x8000
    movhi r2, %hi(NIOS2_DCACHE_SIZE)
#else
    movui r2, NIOS2_DCACHE_SIZE
#endif
0:
    initd 0(r2)
    addi r2, r2, -NIOS2_DCACHE_LINE_SIZE
    bgt r2, zero, 0b
1:
    .pushsection .debug_alt_sim_info
    .int 2, 1, 0b, 1b
    .popsection
#endif /* NIOS2_DCACHE_SIZE > 0 */

_boot_rom_1:
    movhi   r3, %hiadj(ROM_BASE)  /* r3 source */
    addi    r3, r3, %lo(ROM_BASE)
    movhi   r4, %hiadj(RAM_BASE)  /* r4 destination */
    addi    r4, r4, %lo(RAM_BASE)
    movhi   r2, %hiadj(_edata)
    addi    r2, r2, %lo(_edata)

_flash_copy:    
    ldw     r5, 0(r3)
    addi    r3, r3, 1
    stw     r5, 0(r4)
    addi    r4, r4, 1
    bgeu    r2, r4, _flash_copy

    movhi r2, %hiadj(_start)
    addi  r2, r2, %lo(_start)
    jmp   r2    
     nop
    
#endif /* BOOT_ROM */


    .section .text
    .align 2
    .globl _start
    .type _start, @function
_start:
#if NIOS2_DCACHE_SIZE > 0
#if NIOS2_DCACHE_SIZE > 0x8000
    movhi r2, %hi(NIOS2_DCACHE_SIZE)
#else
    movui r2, NIOS2_DCACHE_SIZE
#endif
0:
    initd 0(r2)
    addi r2, r2, -NIOS2_DCACHE_LINE_SIZE
    bgt r2, zero, 0b
1:
    .pushsection .debug_alt_sim_info
    .int 2, 1, 0b, 1b
    .popsection
#endif /* NIOS2_DCACHE_SIZE > 0 */

    /*
     *  X^bN̐ݒ
     */
    movhi sp, %hiadj(STACKTOP)
    addi  sp, sp, %lo(STACKTOP)
    
    /* 
     * set up the global pointer. 
     */
    movhi gp, %hiadj(_gp)
    addi  gp, gp, %lo(_gp)

start_0:
    movhi r2, %hiadj(_hardware_init_hook)
    addi  r2, r2, %lo(_hardware_init_hook)
    beq   zero, r2, start_1
    callr r2
    
    /*
     * Clear bss.
     */
start_1:
    movhi r3, %hiadj(__bss_start)
    addi  r3, r3, %lo(__bss_start)

    movhi r2, %hiadj(__bss_end)
    addi  r2, r2, %lo(__bss_end)

    beq   r3, r2, start_3
start_2:
    stw  zero, (r3)
    addi r3, r3, 4
    bltu r3, r2, start_2

start_3:
    movhi r2, %hiadj(_software_init_hook)
    addi  r2, r2, %lo(_software_init_hook)
    beq   zero, r2, start_4
    callr r2

start_4:
    
    call kernel_start

crt0_end:
    br crt0_end    
