/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_config.h,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

/*
 *	vZbTˑW[iPowerPCpj
 *@@@@@J[lŎgp`
 *@@@@@@f[^^A}NA֐̃vg^Cv錾
 *
 *  ̃CN[ht@ĆCt_config.h ݂̂CN[hD
 *  ̃t@C璼ڃCN[hĂ͂ȂȂD
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  J[l̓ʖ̃l[
 */
#include <cpu_rename.h>

/*
 *  PowerPCvZbT̓WX^̒`
 */
#include <powerpc.h>


/*
 *  vZbT̓ꖽ߂̃CC֐`
 */
#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif /* _MACRO_ONLY */


/*
 *  TCB ̃tB[h̃rbg̒`
 *
 *  cpu_context.h ɓGKgCQƂ̈ˑ̊֌WŁC
 *  cpu_context.h ɂ͓ȂD
 */
#define	TBIT_TCB_TSTAT		8	/* tstat tB[h̃rbg */
#define	TBIT_TCB_PRIORITY	8	/* priority tB[h̃rbg */

/*
 *  X^bNɕKvȃ}[W
 *  
 *  PowerPC EABIŋK肳ĂR[OERxVł͊֐Ă
 *  õt[X^bN|C^wĂ8oCg(sp+4)`
 *  (sp+7)ԒnɌĂ΂ꂽ̏񂪑ҔB̂߁AAZu[
 *  `Cꃋ[`ĂяoӏiɊ݃Rg[ˑ
 *  jł͒ӂKvłB
 *  ̓Iɂ͈ȉ̉ӏYB
 *   @(1) X^[gAbv[`
 *   @(2) ^XNN
 *   @  (2-1) ^XNO[`N
 *   @(3) ݃nhN
 *   @(4) CPUO[`N
 *  
 *  @@@@@@@@@@@@@X^bNLт
 *  @@@@@@@@@@@@@@@@@
 *  @ ֐ĂяoOsp  ---------------------- 
 *  @ @@@@@           |                      |
 *  @@@@@@         +4  ----------------------@
 *  @@@@@@            |                      |Cꃋ[`̌Ăяo
 *  @@@@@@         +8  ----------------------   ɂ菑܂
 *  @
 *  @l
 *  @@64rbg̍ۂɂ͒ӂKvłB
 *  @
 */
#define STACK_MARGIN	8


#ifndef _MACRO_ONLY
/*
 *  ^XNReLXgubN̒`
 *@@sp4oCgEł邱Ƃ𖾎邽߁A
 *@@UW*^Ő錾ĂB
 */

typedef struct task_context_block {
        UW	*sp;            /* X^bN|C^ */
        FP	pc;             /* vOJE^ */
} CTXB;

/*
 *  VXeԎQ
 */

/*
 *  ReLXgQ
 *  
 *    ߂l
 *    @TRUE F^XNReLXg
 *    @FALSEF^XNReLXg
 *
 *@SPRG0݃lXgJE^ɗpĂ
 *  ݃lXgJE^ǂݏoɊ݂ĂA
 *  ߂Ƃɂ̓ReLXgɖ߂Ă
 *
 */
Inline BOOL
sense_context()
{
    UW intnest;
    
    intnest = current_sprg0();    	/*  intnest  SPRG0  */
    return(intnest > 0);
}

/*
 *  CPUbNԎQ
 *  
 *    ߂l
 *    @TRUE FCPUbN
 *    @FALSEFCPUbN
 *
 *  MSRǂݏoɊ݂ĂA߂Ƃɂ
 *  MSRɖ߂Ă
 *
 */
Inline BOOL
sense_lock()
{
    return(!(current_msr() & MSR_EE));
}

#define t_sense_lock    sense_lock
#define i_sense_lock    sense_lock



/*
 *  CPUbNƂ̉
 *
 *  @MSREErbgCPUbNĂB
 *  @݃}XN͊݃Rg[ɂB
 *  @ݑS֎~Ɗ݃}XNƗĂ邽߁A
 *  @PɎłB
 */

/*  ^XNReLXgp  */
#define t_lock_cpu      disint      /*  cpu_insn.h  */
#define t_unlock_cpu    enaint      /*  cpu_insn.h  */

/*  ^XNReLXgp  */
#define i_lock_cpu      disint      /*  cpu_insn.h  */
#define i_unlock_cpu    enaint      /*  cpu_insn.h  */


/*
 *  ^XNfBXpb`
 */

/*
 *  ōD揇ʃ^XNւ̃fBXpb`icpu_support.Sj
 *
 *  dispatch ́C^XNReLXgĂяoꂽT[rXR[
 *  ŁCCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	dispatch(void);

/*
 *  ݂̃ReLXĝĂăfBXpb`icpu_support.Sj
 *
 *  exit_and_dispatch ́CCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	exit_and_dispatch(void);

/*
 *  ݃nh^CPUOnh̐ݒ
 */

/*
 *  ݃nh̋[e[u
 */
extern FP int_table[];

/*
 *  OxN^̋[e[u
 */
extern FP exc_table[];


Inline void
define_inh(INHNO intno, FP inthdr)
{
    int_table[intno] = inthdr;

#ifdef GDB_STUB     /*  ۗ  */

#endif
}

/*
 *   CPUOnh̐ݒ
 */

Inline void
define_exc(EXCNO excno, FP exchdr)
{
    exc_table[excno] = exchdr;

#ifdef GDB_STUB     /*  ۗ  */

#endif
}


/*
 *  ݃nh̏o̐}N
 */

#define INTHDR_ENTRY(inthdr)  extern void inthdr(void)

#define INT_ENTRY(inthdr) inthdr

/*
 *  CPUOnh̏o̐}N
 *
 */
#define EXCHDR_ENTRY(exchdr)  extern void exchdr(VP sp)

#define EXC_ENTRY(exchdr)     exchdr

/*
 *  CPUO̔̃VXeԂ̎Q
 */

/*
 *  CPUO̔̃ReLXg
 *  
 *    ߂l
 *    @TRUE FCPUOɔ^XNReLXg
 *    @FALSEFCPUOɃ^XNReLXg
 *
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
    UW  intnest;
    
    intnest = current_sprg0();    	/*  intnest  SPRG0  */

    /*
     * PƔr̂́AݎsCPUO̕
     * ݃lXgJE^CNgĂ邽
     */
    return(intnest > 1);
}


/*
 * Onḧp_excinfwԒn
 * @@@@@@@@@@@@SSR1WX^܂ł̃ItZbg
 * 
 * @@MSR̃Rs[SSR1WX^́AX^bN(OFFSET_SSR1+1)Ԗڂ
 * @@ς܂ĂB
 * @@support.SSAVE_GPR0_12_SPRGQ 
 */
#define OFFSET_SSR1	12

/*
 *  CPUO̔CPUbNԂ̎Q
 *  
 *    ߂l
 *    @TRUE FCPUOCPUbN
 *    @FALSEFCPUOCPUbN
 *  
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
    UW  ssr1;

    ssr1 = *((volatile UW *)p_excinf + OFFSET_SSR1);
    return( !(ssr1 & MSR_EE) );
}

/*
 *  vZbTˑ̏
 */
extern void cpu_initialize(void);

/*
 *  vZbTˑ̏I
 */
extern void cpu_terminate(void);

/*
 *  L̃Oõ͎X^bN\̒`
 */
typedef struct exc_stack {
	UW	r0;
	UW	r3;
	UW	r4;
	UW	r5;
	UW	r6;
	UW	r7;
	UW	r8;
	UW	r9;
	UW	r10;
	UW	r11;
	UW	r12;
	UW	srr0;	/*   Ҕ^AWX^0@*/
	UW	srr1;	/*   Ҕ^AWX^1@*/
	UW	lr;	/*   NEWX^ 	*/
	UW	ctr;	/*   JEgEWX^	*/
	UW	cr;	/*   RfBVEWX^ 	*/
	UW	xer;	/*   Iy[V̏ʃWX^@*/
			/*  @iL[I[ot[Ȃǁj  */
	UW	exc_no;	/*   Oԍ 	*/
} EXCSTACK;

/*  X^bÑf[^̕\  */
void syslog_data_on_stack(EXCSTACK *sp);

/*
 * o^ĂȂÕOo (cpu_config.c)
 */
extern void no_reg_exception(EXCSTACK *);



#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */

/*  end of file  */
