/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: mpc860_smc.c,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

/*
 *   MPC860VAE}l[WgRg[SMC1p ȈՃhCo
 *@@@@
 *@@@@SMC1݂̂T|[gĂ
 *
 *@@@@smc.{c,h}hw_serial.h̊̕
 *@@@@@@Esmc.{c,h}FVAfoCXɈˑ镔̂݋Lq
 *@@@@@@Ehw_serial.hF݃Rg[ˑ
 *@@@@@@
 *@@@@@@ENbNgˑɂ
 *@@@@@@@@EfoCXˑ̃p[^mpc860_smc.cŗpӂB
 *@@@@@@@@E匳̃NbNg̓RpCIvVƂė^
 */

#include <s_services.h>
#include <mpc860_smc.h>

/*
 *  Rg[WX^̒`
 */

/*  SMC[hWX^  */
#define SMCMR1          (VH *)(IMMR_BASE + 0xa82)
#define SMCMR_SM_UART   BIT10_16    /*  SMC[hFUART  */
#define SMCMR_TEN       BIT14_16    /*  SMCMCl[u  */
#define SMCMR_REN       BIT15_16    /*  SMCMCl[u  */


/*
 *  30.2.3 p[^RAM
 */
/*  obt@EfBXNv^BD̐擪AhX  */
#define BD1_BASE    (IMMR_BASE + 0x3e80)
#define RBASE1      (VH *)BD1_BASE          /*  RxBDx[XAhX  */
#define TBASE1      (VH *)(BD1_BASE+2)      /*  TxBDx[XAhX  */
#define RFCR1       (VB *)(BD1_BASE+4)      /*  Mt@NVR[h  */
					    /*  oCgiMj  */
#if SIL_ENDIAN == SIL_ENDIAN_BIG	    /* rbOGfBA */
#define RFCR_BO     0x10
#else /* SIL_ENDIAN == SIL_ENDIAN_BIG */    /* gGfBA */
#define RFCR_BO	    0x08
#endif /* SIL_ENDIAN == SIL_ENDIAN_BIG */

#define TFCR1       (VB *)(BD1_BASE+5)      /*  Mt@NVR[h  */
					    /*  oCgiMj  */
#if SIL_ENDIAN == SIL_ENDIAN_BIG	    /* rbOGfBA */
#define TFCR_BO     0x10
#else /* SIL_ENDIAN == SIL_ENDIAN_BIG */    /* gGfBA */
#define TFCR_BO	    0x08
#endif /* SIL_ENDIAN == SIL_ENDIAN_BIG */

/*
 *  30.3.2 UART̏ꍇ̃p[^RAM
 */
#define MRBLR1      (VH *)(BD1_BASE+6)      /*  őMobt@  */
#define RBPTR1      (VH *)(BD1_BASE+0x10)   /*  RxBD|C^  */
#define TBPTR1      (VH *)(BD1_BASE+0x20)   /*  TxBD|C^  */
                                            /*  őAChLN^  */
#define MAX_IDL1    (VH *)(BD1_BASE+0x28)
#define IDLC1       (VH *)(BD1_BASE+0x2a)   /*  ꎞAChEJE^  */
#define BRKLN1      (VH *)(BD1_BASE+0x2c)   /*  ŏIMu[N  */
                                            /*  Mu[NJE^  */
#define BRKEC1      (VH *)(BD1_BASE+0x2e)
                                    /*  u[NJEgWX^iMj  */
#define BRKCR1      (VH *)(BD1_BASE+0x30)
#define R_MASK1     (VH *)(BD1_BASE+0x32)   /*  ꎞrbgE}XN  */


/*
 *  fA|[gEɊmۂ̈
 */

/*
 *  obt@EfBXNv^BD̃x[XAhX
 */
#define RxBD_BASE_ADDRESS   0x0     /*  RxBDx[XAhX  */
#define TxBD_BASE_ADDRESS   0x8     /*  TxBDx[XAhX  */

/*  30.3.10 Mpobt@fBXNv^RxBD  */
#define RxBD        (DUAL_PORT_RAM + RxBD_BASE_ADDRESS)
#define RxBD_STATUS (VH *)RxBD     	/*  Xe[^XƐ  */
#define RxBD_LENGTH (VH *)(RxBD+2) 	/*  f[^  */
#define RxBD_BUFFP  (VW *)(RxBD+4) 	/*  Mobt@|C^  */

/*  30.3.11 Mpobt@fBXNv^TxBD  */
#define TxBD        (DUAL_PORT_RAM + TxBD_BASE_ADDRESS)
#define TxBD_STATUS (VH *)TxBD     	/*  Xe[^XƐ  */
#define TxBD_LENGTH (VH *)(TxBD+2) 	/*  f[^  */
#define TxBD_BUFFP  (VW *)(TxBD+4) 	/*  Mobt@|C^  */

/*  Mpobt@fBXNv^RxBD  */
/*  @uXe[^XƐvtB[h̒萔  */
#define RxBD_STATUS_E       BIT0_16     /*    */
#define RxBD_STATUS_W       BIT2_16     /*  bv  */
#define RxBD_STATUS_I       BIT3_16     /*    */
#define RxBD_STATUS_CM      BIT6_16     /*  p[h  */
#define RxBD_STATUS_ID      BIT7_16     /*  AChM  */
#define RxBD_STATUS_BR      BIT10_16    /*  u[NM  */
#define RxBD_STATUS_FR      BIT11_16    /*  t[~OEG[  */
#define RxBD_STATUS_PR      BIT12_16    /*  peBEG[  */
#define RxBD_STATUS_OV      BIT14_16    /*  I[o[  */

/* Mpobt@fBXNv^TxBD  */
/*  @uXe[^XƐvtB[h̒萔  */
#define TxBD_STATUS_R       BIT0_16     /*  fB  */
#define TxBD_STATUS_W       BIT2_16     /*  bv  */
#define TxBD_STATUS_I       BIT3_16     /*    */
#define TxBD_STATUS_CM      BIT6_16     /*  p[h  */
#define TxBD_STATUS_P       BIT7_16     /*  vAu  */

/*  30.3.12 SMC UARTCxgWX^  */
#define SMCE1           (VB *)(IMMR_BASE + 0xa86)
#define SMCE_BRKE       BIT1_8      /*  u[NŏI  */
#define SMCE_BRK        BIT3_8      /*  u[NLN^M  */
#define SMCE_BSY        BIT5_8      /*  rW[  */
#define SMCE_TX         BIT6_8      /*  Mobt@  */
#define SMCE_RX         BIT7_8      /*  Mobt@  */

/*  SMC UART}XNWX^  */
#define SMCM1           (VB *)(IMMR_BASE + 0xa8a)
#define SMCM_BRKE       BIT1_8      /*  u[NŏI  */
#define SMCM_BRK        BIT3_8      /*  u[NLN^M  */
#define SMCM_BSY        BIT5_8      /*  rW[  */
#define SMCM_TX         BIT6_8      /*  Mobt@  */
#define SMCM_RX         BIT7_8      /*  Mobt@  */

#define PIC_BUFFER_SIZE     1      		/*  obt@TCY  */

volatile static UB Rx_buffer[PIC_BUFFER_SIZE];	/*  Mobt@  */
volatile static UB Tx_buffer[PIC_BUFFER_SIZE];	/*  Mobt@  */


/*
 *  {[[gݒp萔
 *  
 *  @񓯊̏ꍇ́~16NbNp̂16ŊĂ
 *  i[U[̐ݒ16Ă킯ł͂Ȃj
 *  
 */
#define MHZ		1000000

#define BRGC1_CD_VAL		\
	(((SYSTEM_CLOCK * MHZ * 10 + 10) / (16 * BAUD_RATE * 10)) - 1) 

/*  BRGC1WX^CDtB[h20rbgɐĂ  */
#if (BRGC1_CD_VAL & ~0xfffff) != 0
@ŃRpCG[
#endif


/*
 *  ƃrbg[g̐ݒ
 *
 */


/*
 *  {[[gݒANbN肷܂ł̑҂
 *  @iŏ1rbgj@
 *  BPS=9600bps̏ꍇ
 *  @t = 1 / BPS = 104,167 = 105,000[nsec]
 */
#define SMC_1BIT_TIME 	105000


/*
 *  VAI/O|[gǗubN̒`
 *  @2chT|[gɊgꍇ͏lp̃f[^܂߂
 */
struct sio_port_control_block {
	VP_INT		exinf;		/* g */
	BOOL		openflag;	/* I[vς݃tO */
};

/*
 *  VAI/O|[gǗubÑGA
 *  @@ID = 1 SMC1ɑΉĂD
 */
static SIOPCB	siopcb_table[TNUM_SIOP];

/*
 *  VAI/O|[gIDǗubNo߂̃}N
 */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))


#define	CODE_LF		0x0a		/*  sR[h  */

/*  LN^M̑҂  */
#ifdef DOWNLOAD_TO_RAM      /*  fobOp  */

#define	DELAY_CH	      0		/*  ʏ̃LN^  */
#define	DELAY_LF	5000000		/*  sR[h  */

#else /* DOWNLOAD_TO_RAM */ /*  ROM  */

#define	DELAY_CH	4000000		/*  ʏ̃LN^  */
#define	DELAY_LF	1000000		/*  sR[h  */

#endif /* DOWNLOAD_TO_RAM */



/*
 *  Mł邩H
 */
Inline BOOL
smc_getready(SIOPCB *siopcb)
{
	VH status;
	
	status = mpc860_reh_mem(RxBD_STATUS);
	return(!(status & RxBD_STATUS_E));
}

/*
 *  𑗐Mł邩H
 */
Inline BOOL
smc_putready(SIOPCB *siopcb)
{
	VH status;

	status = mpc860_reh_mem(TxBD_STATUS);
	return(!(status & TxBD_STATUS_R));
}

/*
 *  M̎o
 */
Inline char
smc_getchar(SIOPCB *siopcb)
{
	char c;
	SIL_PRE_LOC;
	
	SIL_LOC_INT();		/*  ݋֎~  */
    	c = Rx_buffer[0];
    	
    	/*  ӁFMobt@TCYP̏ꍇ̂ݗL  */
    	mpc860_orh_mem(RxBD_STATUS, RxBD_STATUS_E);
    	SIL_UNL_INT();		/*  ݋  */
    	return(c);
}

/*
 *  M镶̏
 */
Inline void
smc_putchar(SIOPCB *siopcb, char c)
{
	SIL_PRE_LOC;

	SIL_LOC_INT();		/*  ݋֎~  */
    	Tx_buffer[0] = c;
    	
    	/*  ӁFMobt@TCYP̏ꍇ̂ݗL  */
    	mpc860_orh_mem(TxBD_STATUS, TxBD_STATUS_R);
    	
    	SIL_UNL_INT();		/*  ݋  */

	/*
	 *  h߁A҂Ԃ
	 */
	sil_dly_nse(DELAY_CH);

    	/*  sR[h̏ꍇ  */
    	if (c == CODE_LF) {
		sil_dly_nse(DELAY_LF);
	}
}

/*
 *  SIOhCȍ[`
 */
void
smc_initialize()
{
	SIOPCB	*siopcb;
	UINT	i;

	/*
	 *  VAI/O|[gǗubN̏
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
		siopcb->openflag = FALSE;
	}
}


/*
 *  I[vĂ|[g邩H
 */
BOOL
smc_openflag(void)
{
	return(siopcb_table[0].openflag);
}

/*
 *  VAI/O|[g̃I[v
 */
SIOPCB *
smc_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB *siopcb;

	siopcb = get_siopcb(siopid);
	     					/*  M~  */
	mpc860_andh_mem(SMCMR1, ~(SMCMR_TEN | SMCMR_REN));

	/*
	 *  sEATC
	 *  @@|[gB̐ݒ
	 *@@@@@BP25sFSMTXD1
	 *@@@@@BP24sFSMRXD1
	 */
         				/*  pytF@\I  */
     	mpc860_orw_mem(PBPAR, (PBPAR_DD24 | PBPAR_DD25));
        				/*  ytF@\0I  */
     	mpc860_andw_mem(PBDIR, ~(PBDIR_DR24 | PBDIR_DR25));
        				/*  ANeBuɃhCu  */
     	mpc860_andw_mem(PBODR, ~(PBODR_OD24 | PBODR_OD25));

    	/*
    	 *  VCOUTBRGCLKւ̕Wݒ
    	 *      SCCR.DFBRG=00FP
    	 */
    	unlock_sccr();          		/*  SCCRAbN  */
    	mpc860_andw_mem(SCCR, ~SCCR_DFBRG);    	/*  ݒ  */
    	lock_sccr();            		/*  SCCRbN  */

    	/*
    	 *  {[[gݒiBRG1j
    	 *  @@EN=1FBRGJEgCl[u
    	 *  @@EXTC=00FNbN\[XBRGCLKI
    	 *  @@ATB=0FI[g{[@\fBZ[u
    	 *  @@CDF
    	 *  @@DIV16F16邩ۂ
    	 */
    	mpc860_wrw_mem(BRGC1, BRGC1_EN | (BRGC1_CD_VAL<<1));
    
    	/*
    	 *  BRG1SMC1̐ڑ
    	 *  @@SMC1=0FNMSI[hidȂj
    	 *  @@SMC1CS=000FNbN\[XBRG1
    	 */
    	mpc860_andw_mem(SIMODE, ~(SIMODE_SMC1 | SIMODE_SMC1CS));
    
    	/*@NbN肷܂ő҂ */
    	sil_dly_nse(SMC_1BIT_TIME);

    	/*
    	 *  obt@EfBXNv^BD̐ݒ
    	 */
    					/*  RxBDx[XAhX  */
    	mpc860_wrh_mem(RBASE1, RxBD_BASE_ADDRESS);
         				/*  TxBDx[XAhX  */
    	mpc860_wrh_mem(TBASE1, TxBD_BASE_ADDRESS);

    	/*
    	 *  ʐMvZbTCPINIT RX AND TX PARAMETERSR}h𔭍s
    	 */
    	mpc860_CP_command(CPCR_INIT_RX_TX_PARAMETERS, CPCR_CH_NUM_SMC1);
    
    	/*  SDMAUoXDxݒ  */
    	mpc860_wrw_mem(SDCR, SDCR_RAID_RB5);   /*  Dx5Fʏ폈  */

    	/*  obt@EfBXNv^BD̃GfBAݒ  */
    	mpc860_wrb_mem(RFCR1, RFCR_BO);		/*  M  */
    	mpc860_wrb_mem(TFCR1, TFCR_BO);		/*  M  */
    	    			/*  őMobt@  */
    	mpc860_wrh_mem(MRBLR1, PIC_BUFFER_SIZE);
       		/*  AChLN^o@\fBZ[u  */
    	mpc860_wrh_mem(MAX_IDL1, 0);
    
    	/*  Mu[NɊւݒ͕KvȂ̂ŃNA  */
    	mpc860_wrh_mem(BRKLN1, 0);
    	mpc860_wrh_mem(BRKEC1, 0);
    
    	/*  STOP TRANSMITR}hőMu[NLN^̐ݒ  */
    	mpc860_wrh_mem(BRKCR1, 1);

    	/*  Mobt@EfBXNv^RxBD̏  */
    	mpc860_wrh_mem(RxBD_STATUS,
                 RxBD_STATUS_E | RxBD_STATUS_W | RxBD_STATUS_I);
                /*  EtOZbg  */
                /*  W=1Fe[u̍ŏIBD  */
                /*  I=1FMݔ  */

    	mpc860_wrh_mem(RxBD_LENGTH, PIC_BUFFER_SIZE);  /*  f[^  */
       					/*  Mobt@|C^  */
    	mpc860_wrw_mem(RxBD_BUFFP, (VW)Rx_buffer);

    	/*  Mobt@EfBXNv^TxBD̏  */
    	mpc860_wrh_mem(TxBD_STATUS,
    		TxBD_STATUS_R | TxBD_STATUS_W | TxBD_STATUS_I);
                /*  RtOZbg  */
                /*  W=1Fe[u̍ŏIBD  */
                /*  I=1FMݔ  */

    	mpc860_wrh_mem(TxBD_LENGTH, PIC_BUFFER_SIZE);  /*  f[^  */
    					/*  Mobt@|C^  */
    	mpc860_wrw_mem(TxBD_BUFFP, (VW)Tx_buffer);
    
    	/*  ȑÕCxgNA  */
    	mpc860_wrb_mem(SMCE1,
    		SMCE_BRKE | SMCE_BRK | SMCE_BSY | SMCE_TX | SMCE_RX);

    	/*  ׂĂUART݂  */
    	mpc860_wrb_mem(SMCM1,
     		SMCM_BRKE | SMCM_BRK | SMCM_BSY | SMCM_TX | SMCM_RX);
    
    	/*  SMC[hݒ  */
    	mpc860_wrh_mem(SMCMR1, (VH)((0x9<<11) | SMCMR_SM_UART));
        	/*  
        	 *  CLEN=9FLN^
        	 *  SL=0F1Xgbvrbg
        	 *  PEN=0FpeBȂ
        	 *  SM=10FSMC[h UART
        	 *  DM=00Fff[h ʏ퓮
        	 *  TEN=0FSMCMfBZ[u
        	 *  REN=0FSMCMfBZ[u
        	 *   ̎_ł͂܂AMMCl[uł͂Ȃ
        	 */
    
    	mpc860_orh_mem(SMCMR1, (SMCMR_TEN | SMCMR_REN));
        	/*  
        	 *  Lɉ
        	 *  @TEN=1FSMCMCl[u
        	 *  @REN=1FSMCMCl[u
        	 */

	siopcb->exinf = exinf;
	siopcb->openflag = TRUE;
	return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void
smc_cls_por(SIOPCB *siopcb)
{
         					/*  M~  */
	mpc860_andh_mem(SMCMR1, ~(SMCMR_TEN | SMCMR_REN));
	siopcb->openflag = FALSE;
}

/*
 *  VAI/O|[gւ̕M
 */
BOOL
smc_snd_chr(SIOPCB *siopcb, char c)
{
	if (smc_putready(siopcb)) {
		smc_putchar(siopcb, c);
		return(TRUE);
	}
	return(FALSE);
}

/*
 *  VAI/O|[g̕M
 */
INT
smc_rcv_chr(SIOPCB *siopcb)
{
	if (smc_getready(siopcb)) {
		return((INT)(UB) smc_getchar(siopcb));
	}
	return(-1);
}

/*
 *  VAI/O|[g̃R[obN̋
 */
void
smc_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	SIL_PRE_LOC;
	
	switch (cbrtn) {
	case SIO_ERDY_SND:	/* M荞ݗv */
		SIL_LOC_INT();
		mpc860_orh_mem(SMCMR1, SMCMR_TEN);
		SIL_UNL_INT();
		break;
	case SIO_ERDY_RCV:	/* M荞ݗv */
		SIL_LOC_INT();
		mpc860_orh_mem(SMCMR1, SMCMR_REN);
		SIL_UNL_INT();
		break;
	}
}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
smc_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	SIL_PRE_LOC;

	switch (cbrtn) {
	case SIO_ERDY_SND:	/* M荞ݗv֎~ */
		SIL_LOC_INT();
		mpc860_andh_mem(SMCMR1, ~SMCMR_TEN);
		SIL_UNL_INT();
		break;
	case SIO_ERDY_RCV:	/* M荞ݗv֎~ */
		SIL_LOC_INT();
		mpc860_andh_mem(SMCMR1, ~SMCMR_REN);
		SIL_UNL_INT();
		break;
	}
}

/*
 *  VAI/O|[gɑ΂鑗Mݏ
 */
Inline void
smc_isr_siop_out(SIOPCB *siopcb)
{
	/*  SMCE1ł̊ݗṽ`FbN͍ςł  */
	
	if (smc_putready(siopcb)) {
		/*
		 *  MʒmR[obN[`ĂяoD
		 */
		smc_ierdy_snd(siopcb->exinf);
	}
}

/*
 *  VAI/O|[gɑ΂Mݏ
 */
Inline void
smc_isr_siop_in(SIOPCB *siopcb)
{
	/*  SMCE1ł̊ݗṽ`FbN͍ςł  */

	if (smc_getready(siopcb)) {
		/*
		 *  MʒmR[obN[`ĂяoD
		 */
		smc_ierdy_rcv(siopcb->exinf);
	}
}

/*
 *  SILgpƂ̃O@\
 */
#ifdef SIL_DEBUG
#define ENTER_SMC_ISR						\
	if (sil_debug_on) {					\
		syslog(LOG_EMERG, "Enter selial interrupt.");	\
	}

#else /* SIL_DEBUG */

#define ENTER_SMC_ISR

#endif /* SIL_DEBUG */


/*
 *  SIOM݃T[rX[`
 *  
 *  @M
 *  
 */
void
smc_isr()
{
    	UB smce1, smcm1, event;
    	SIL_PRE_LOC;

	ENTER_SMC_ISR
	
    	if (!siopcb_table[0].openflag) goto exit_label;
    
    	smce1 = mpc860_reb_mem(SMCE1);
    	smcm1 = mpc860_reb_mem(SMCM1);
    	event = smce1 & smcm1;
    	
    	if (event & (SMCE_BRKE | SMCE_BRK | SMCE_BSY)) {
    		/*  G[F  */
    		goto exit_label;
    	}
    	
    	if (event & SMCE_RX) {         /*  M  */
	        	/*  1Zbg邱ƂɂACxgNA  */
        	mpc860_wrb_mem(SMCE1, SMCE_RX);
        	smc_isr_siop_in(&siopcb_table[0]);
    	}
    	if (event & SMCE_TX) {         /*  M  */
	        	/*  1Zbg邱ƂɂACxgNA  */
        	mpc860_wrb_mem(SMCE1, SMCE_TX);
        	smc_isr_siop_out(&siopcb_table[0]);
    	}

exit_label:
    	/*
    	 * @ݗṽNA
    	 *  @@݃Rg[ˑ
    	 *  @@isys_config.hŒ`j
    	 */
    	SIL_LOC_INT();
	CLEAR_IRQ_TO_ICU(SMC1);	
    	SIL_UNL_INT();
}

/*
 * |[Oɂ镶̑M
 */
void
smc_putc_pol(char c)
{
	BOOL is_ten_ok;
	VH smcmr;
	if (smc_openflag()) {	/*  Ă邩`FbN  */
		smcmr = mpc860_reh_mem(SMCMR1);
		is_ten_ok = smcmr & SMCMR_TEN;
		if (!is_ten_ok) {
						/*  M  */
			mpc860_orh_mem(SMCMR1, SMCMR_TEN);
		}
				/*  obt@ɂȂ̂҂  */
		while(!smc_putready(&siopcb_table[0]));	
		smc_putchar(&siopcb_table[0], c);	/*  1M  */

		if (!is_ten_ok) {
				/*  obt@ɂȂ̂҂  */
			while(!smc_putready(&siopcb_table[0]));
				/*  2LN^҂  */
			sil_dly_nse(SMC_1BIT_TIME*18*10);	
						/*  M֎~  */
			mpc860_andh_mem(SMCMR1, ~SMCMR_TEN);
		}
	}
}

/*  end of file  */
