/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: mpc860t.h,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

/*
 *  MPC860̃n[hEFA̒`
 */

#ifndef _MPC860_H_
#define _MPC860_H_

/*
 *  ݂̖{
 */
#define TMAX_SIU_INTNO      16  /*  VXeC^[tF[XjbgSIU  */
#define TMAX_CPM_INTNO      32  /*  ʐMvZbTW[CPM  */
                                /*  MPC860S  */
#define TMAX_INTNO          (TMAX_SIU_INTNO+TMAX_CPM_INTNO)

/*
 *  ݊֘A̒`
 *  @ݗv3ނ̒lǗĂ
 *  @PDݔԍ
 *  @QDSIUւ̊ݗvx
 *  @@@x̐ݒ
 *  @@@CPM݂͑ŜłЂƂ܂Ƃ߂̈
 *  @@@@(1) No.F0`7̐l
 *  @@@@@@@lԂɂ͕₷AvOł
 *  @@@@@@@ځAgpȂ
 *  @@@@(1-2) ݗv̎
 *  @@@@@@@[xN^e[ũCfbNXƂēǂݏo
 *  @@@@@@@Ȃ̂ŁAlƂă}N`ĂKv͂Ȃ
 *  @@@@@@@\2rbgVtgĂ
 *  @@@@(2) 1oCg̃rbgp^[ 
 *  @@@@@@@ݗvxݒ肷ۂɃWX^ɃZbgl
 *  @@@@@@@Y1rbgZbg
 *  @RDSIUIPM
 *  @@@2oCg̃rbgp^[
 *  @@@CPM݂͑ŜłЂƂ܂Ƃ߂̈
 *  @@@@(1) ݃}XN
 *  @@@@@@@SIU݃WX^SIMASKɐݒ肷l
 *  @@@@@@@背x̒Ⴂݗvׂă}XN
 *  @@@@(2) ۗ̊ݗv
 *  @@@@@@@YrbgZbgĂ
 *  
 *  @x2-(1)犄ݔԍA݃xݒprbgp^[A
 *  @IPM𐶐jŎ
 *  
 */

/*
 *  ݔԍ̒`
 *      n[hEFA}jAɂSIU݃\[X16`31Ԃ͗\
 *      ݂Ƃ邪A[xN^e[uʂɑ傫Ȃ邾Ȃ̂ŁA
 *      CPM݃\[X蓖ĂĂ
 *      
 *      ݔԍƗDx̊֌WSIU݂CPM݁iftHgj
 *      ŋtȂ̂Œ
 *      @SIU
 *      @@ݔԍ@@0Fŏ
 *      @@ݔԍ@ 15Fŉ
 *      @CPM݁iftHgj
 *      @@ݔԍ@ 0x0Fŉ
 *      @@ݔԍ@0x1fFŏ
 */

    /*  SIU݃\[X  */
#define INTNO_IRQ0      0x0     /*  IRQ0  */
#define INTNO_LVL0      0x1     /*  x0  */
#define INTNO_IRQ1      0x2     /*  IRQ1  */
#define INTNO_LVL1      0x3     /*  x1  */
#define INTNO_IRQ2      0x4     /*  IRQ2  */
#define INTNO_LVL2      0x5     /*  x2  */
#define INTNO_IRQ3      0x6     /*  IRQ3  */
#define INTNO_LVL3      0x7     /*  x3  */
#define INTNO_IRQ4      0x8     /*  IRQ4  */
#define INTNO_LVL4      0x9     /*  x4  */
#define INTNO_IRQ5      0xa     /*  IRQ5  */
#define INTNO_LVL5      0xb     /*  x5  */
#define INTNO_IRQ6      0xc     /*  IRQ6 */
#define INTNO_LVL6      0xd     /*  x6  */
#define INTNO_IRQ7      0xe     /*  IRQ7  */
#define INTNO_LVL7      0xf     /*  x7  */

    /*  CPM݃\[X  */
#define INTNO_ERR       0x10    /*  G[F0x0  */
#define INTNO_PC4       0x11    /*  pI/O PC4F0x1  */
#define INTNO_PC5       0x12    /*  pI/O PC5F0x2  */
#define INTNO_SMC2      0x13    /*  SMC2/PIPF0x3  */
#define INTNO_SMC1      0x14    /*  SMC1F0x4  */
#define INTNO_SPI       0x15    /*  SPIF0x5  */
#define INTNO_PC6       0x16    /*  pI/O PC6F0x6  */
#define INTNO_TIMER4    0x17    /*  ^C}4F0x7  */
/*  CPMݔԍ8͗\ς  */
#define INTNO_PC7       0x19    /*  pI/O PC7F0x9  */
#define INTNO_PC8       0x1a    /*  pI/O PC8F0xa  */
#define INTNO_PC9       0x1b    /*  pI/O PC9F0xb  */
#define INTNO_TIMER3    0x1c    /*  ^C}3F0xc  */
/*  CPMݔԍ0xd͗\ς  */
#define INTNO_PC10      0x1e    /*  pI/O PC10F0xe  */
#define INTNO_PC11      0x1f    /*  pI/O PC11F0xf  */
#define INTNO_I2C       0x20    /*  I2CF0x10  */
#define INTNO_RISC      0x21    /*  RISC^C}e[uF0x11  */
#define INTNO_TIMER2    0x22    /*  ^C}2F0x12  */
/*  CPMݔԍ0x13͗\ς  */
#define INTNO_IDMA2     0x24    /*  IDMA2F0x14  */
#define INTNO_IDMA1     0x25    /*  IDMA1F0x15  */
#define INTNO_SDMA      0x26    /*  SDMA`loXG[F0x16  */
#define INTNO_PC12      0x27    /*  pI/O PC12F0x17  */
#define INTNO_PC13      0x28    /*  pI/O PC13F0x18  */
#define INTNO_TIMER1    0x29    /*  ^C}1F0x19  */
#define INTNO_PC14      0x2a    /*  pI/O PC14F  */
#define INTNO_SCC4      0x2b    /*  SCC4F0x1a  */
#define INTNO_SCC3      0x2c    /*  SCC3F0x1c  */
#define INTNO_SCC2      0x2d    /*  SCC2F0x1d  */
#define INTNO_SCC1      0x2e    /*  SCC1F0x1e  */
#define INTNO_PC15      0x2f    /*  pI/O PC15F0x1f  */

/*
 *  SIUIPM̒`
 *    2oCg̃rbgp^[
 *    n[hEFÃftHg̗Dxɍ킹Ă
 */
#define IPM_IRQ0	0x00u			/*  IRQ0  */
#define IPM_LVL0	BIT0_16			/*  x0  */
#define IPM_IRQ1	(IPM_LVL0 | BIT1_16)	/*  IRQ1  */
#define IPM_LVL1	(IPM_IRQ1 | BIT2_16)	/*  x1  */
#define IPM_IRQ2	(IPM_LVL1 | BIT3_16)	/*  IRQ2  */
#define IPM_LVL2	(IPM_IRQ2 | BIT4_16)	/*  x2  */
#define IPM_IRQ3	(IPM_LVL2 | BIT5_16)	/*  IRQ3  */
#define IPM_LVL3	(IPM_IRQ3 | BIT6_16)	/*  x3  */
#define IPM_IRQ4	(IPM_LVL3 | BIT7_16)	/*  IRQ4  */
#define IPM_LVL4	(IPM_IRQ4 | BIT8_16)	/*  x4  */
#define IPM_IRQ5	(IPM_LVL4 | BIT9_16)	/*  IRQ5  */
#define IPM_LVL5	(IPM_IRQ5 | BIT10_16)	/*  x5  */
#define IPM_IRQ6	(IPM_LVL5 | BIT11_16)	/*  IRQ6  */
#define IPM_LVL6	(IPM_IRQ6 | BIT12_16)	/*  x6  */
#define IPM_IRQ7	(IPM_LVL6 | BIT13_16)	/*  IRQ7  */
#define IPM_LVL7	(IPM_IRQ7 | BIT14_16)	/*  x7  */


/*  ݃x犄ݔԍւ̕ϊ  */
#define _LEVEL_TO_INHNO(level)      INTNO_LVL##level
#define  LEVEL_TO_INHNO(level)      _LEVEL_TO_INHNO(level)

/*  ݃xo^prbgp^[ւ̕ϊ  */
#define _LEVEL_TO_BIT_PATTERN(level)      (0x1<<(7-(level)))
#define  LEVEL_TO_BIT_PATTERN(level)      _LEVEL_TO_BIT_PATTERN(level)

/*  ݃xIPMւ̕ϊ  */
#define _LEVEL_TO_IPM(level)      IPM_LVL##level
#define  LEVEL_TO_IPM(level)      _LEVEL_TO_IPM(level)

/*  ݃x犄݋rbgւ̕ϊ  */
#define _LEVEL_TO_ENABLE_BIT(level)  SIMASK_LVM##level
#define  LEVEL_TO_ENABLE_BIT(level)  _LEVEL_TO_ENABLE_BIT(level)


/*
 *  CPU̓WX^
 */

/*
 *   8. ߃LbVEf[^LbV֘A̒`
 */

/*  䃌WX^ */

/*  ߃LbV֘A */
#define IC_CST	560	/*  䂨уXe[^XEWX^ */
#define IC_ADR	561	/*  AhXEWX^  */
#define IC_DAT	562	/*  f[^E|[gEWX^  */

/*  f[^ELbV֘A */
#define DC_CST	568	/*  䂨уXe[^XEWX^ */
#define DC_ADR	569	/*  AhXEWX^  */
#define DC_DAT	570	/*  f[^E|[gEWX^  */

/*
 *   9. ǗjbgMMU֘A̒`
 */
/*  䃌WX^  */
#define MI_CTR	784	/*  IMMU 䃌WX^  */
#define MD_CTR	792	/*  DMMU 䃌WX^  */

/*  TLB\[XEWX^  */
#define MI_EPN	787	/*  IMMU y[WԍWX^  */
#define MD_EPN	795	/*  DMMU y[WԍWX^  */
#define MI_TWC	789	/*  IMMU e[uEH[N䃌WX^  */
#define MD_TWC	797	/*  DMMU e[uEH[N䃌WX^  */
#define MI_RPN	790	/*  IMMU ijy[Wԍ|[g  */
#define MD_RPN	798	/*  DMMU ijy[Wԍ|[g  */

/*  e[uEH[NEx[XEWX^  */
#define M_TWD	796	/*  MMU e[uEH[NEx[XEWX^  */

/*  ی샌WX^  */
#define M_CASID	793	/*  MMU JgEAhXID WX^  */
#define MI_AP	786	/*  IMMU ANZXی샌WX^  */
#define MD_AP	794	/*  DMMU ANZXی샌WX^  */

/*  XNb`EWX^  */
#define M_TB	799	/*  MMU e[uEH[NEXyVEWX^  */

/*  fobOEWX^  */
#define MI_CAM	816	/*  IMMU CAM GgE[hEWX^  */
#define MI_RAM0	817	/*  IMMU RAM GgE[hEWX^ 0  */
#define MI_RAM1	818	/*  IMMU RAM GgE[hEWX^ 1  */
#define MD_CAM	824	/*  DMMU CAM GgE[hEWX^  */
#define MD_RAM0	825	/*  DMMU RAM GgE[hEWX^ 0  */
#define MD_RAM1	826	/*  DMMU RAM GgE[hEWX^ 1  */

/*
 *  11. VXeC^[tF[XjbgSIU֘A̒`
 */


/*
 *  }bvWX^
 *  @@WX^Q̐擪AhX
 *  @@
 *  @@@Zbg0x0000,0000ԒnwĂ邪SDRAM
 *  @@@Ԃ̂ŁAʂ̃AhXɕςKv
 */
#define IMMR        638                 /*  WX^ԍ  */
#define IMMR_UPPER_2BYTE  0xff00              /*  16rbg  */
#define IMMR_BASE   (IMMR_UPPER_2BYTE << 16)  /*  x[XAhX  */  

#define TADR_SIU_SIUMCR  0x0    /* SIUW[RtBM[V */
                                /*                     WX^SIUMCR  */

/*
 *  11.5 SIU݃Rg[֘A̒`
 */
#define TADR_SIU_SIPEND 0x10    /* SIUݕۗWX^SIPEND */
#define TADR_SIU_SIMASK 0x14    /* SIU݃}XNWX^SIMASK */

				/*  2oCĝݎgp  */
#define SIMASK		(VH *)(IMMR_BASE + TADR_SIU_SIMASK)
#define SIMASK_IRM0	BIT0_16		/*  IRQ0  */
#define SIMASK_LVM0	BIT1_16		/*  x0  */
#define SIMASK_IRM1	BIT2_16		/*  IRQ1  */
#define SIMASK_LVM1	BIT3_16		/*  x1  */
#define SIMASK_IRM2	BIT4_16		/*  IRQ2  */
#define SIMASK_LVM2	BIT5_16		/*  x2  */
#define SIMASK_IRM3	BIT6_16		/*  IRQ3  */
#define SIMASK_LVM3	BIT7_16		/*  x3  */
#define SIMASK_IRM4	BIT8_16		/*  IRQ4  */
#define SIMASK_LVM4	BIT9_16		/*  x4  */
#define SIMASK_IRM5	BIT10_16	/*  IRQ5  */
#define SIMASK_LVM5	BIT11_16	/*  x5  */
#define SIMASK_IRM6	BIT12_16	/*  IRQ6  */
#define SIMASK_LVM6	BIT13_16	/*  x6  */
#define SIMASK_IRM7	BIT14_16	/*  IRQ7  */
#define SIMASK_LVM7	BIT15_16	/*  x7  */

#define TADR_SIU_SIEL   0x18    /* SIU݃GbW^xWX^SIEL */
#define TADR_SIU_SIVEC  0x1c    /* SIU݃xN^WX^SIVEC */
#define TADR_SIU_TESR   0x20    /* ]G[Xe[^XWX^TESR */
#define TADR_SIU_SDCR   0x30    /* SDMARtBM[VWX^SDCR */

/*
 *  11.7 \tgEFAEEHb`hbN^C}֘A̒`
 */
#define TADR_SIU_SYPCR   0x4    /* VXeیRg[WX^SYPCR */
#define SYPCR_SWE 	 BIT29_32  /*  Cl[u  */
#define SYPCR_SWRI 	 BIT30_32  /*  Zbg^ݑI  */ 
#define TADR_SIU_SWSR    0xe       /* \tgEFAT[rXWX^SWSR */
#define SWSR_CLEAR1      0x556c    /* NAɏޒ萔P */
#define SWSR_CLEAR2      0xaa39    /* NAɏޒ萔Q */

/*
 *  12 Zbg֘A̒`
 */
#define TADR_SIU_RSR  0x288  /* ZbgEXe[^XEWX^RSR */
#define TADR_SIU_RSRK 0x388  /* ZbgEXe[^XEWX^EL[ */
#define RSR_EHRS BIT0_32    /* On[hEZbgEXe[^X */
#define RSR_ESRS BIT1_32    /* O\tgEZbgEXe[^X */
#define RSR_LLRS BIT2_32    /* bNZbgEXe[^X */
#define RSR_SWRS BIT3_32    /* \tgEFAEEHb`hbNEZbg */
#define RSR_CSRS BIT4_32    /* `FbNEXgbvEZbgEXe[^X */
    		/* fobOE|[gEn[hEZbgEXe[^X */
#define RSR_DBHRS BIT5_32
    		/* fobOE|[gE\tgEZbgEXe[^X */
#define RSR_DBSRS BIT6_32
#define RSR_JTRS BIT4_32    /* JTAGZbgEXe[^X */


/*
 *  ʐMvZbTW[CPM֘A
 */

/*
 *  35. CPM݃Rg[֘A̒`
 */
#define TADR_CPM_CIVR   0x930   /* CPM݃xN^WX^CIVR */
#define TADR_CPM_CICR   0x940   /* CPM݃RtBM[V */
                                /*                   WX^CICR  */
#define TADR_CPM_CIPR   0x944   /* CPMݕۗWX^CIPR */
#define TADR_CPM_CIMR   0x948   /* CPM݃}XNWX^CIMR */
#define TADR_CPM_CISR   0x94c   /* CPM݃CT[rXWX^CISR */

/* CPM݃RtBM[V WX^CICR */
#define CICR            (VW *)(IMMR_BASE + TADR_CPM_CICR)
#define CICR_IEN        BIT24_32

/* CPM݃}XNWX^CIMR */
#define CIMR            (VW *)(IMMR_BASE + TADR_CPM_CIMR)
#define CIMR_PC15       BIT0_32     
#define CIMR_SCC1       BIT1_32     
#define CIMR_SCC2       BIT2_32     
#define CIMR_SCC3       BIT3_32     
#define CIMR_SCC4       BIT4_32     
#define CIMR_PC14       BIT5_32     
#define CIMR_TIMER1     BIT6_32     
#define CIMR_PC13       BIT7_32     
#define CIMR_PC12       BIT8_32     
#define CIMR_SDMA       BIT9_32     
#define CIMR_IDMA1      BIT10_32        
#define CIMR_IDMA2      BIT11_32        
#define CIMR_TIMER2     BIT13_32        
#define CIMR_RTT        BIT14_32        
#define CIMR_I2C        BIT15_32        
#define CIMR_PC11       BIT16_32        
#define CIMR_PC10       BIT17_32        
#define CIMR_TIMER3     BIT19_32        
#define CIMR_PC9        BIT20_32        
#define CIMR_PC8        BIT21_32        
#define CIMR_PC7        BIT22_32        
#define CIMR_TIMER4     BIT24_32        
#define CIMR_PC6        BIT25_32        
#define CIMR_SPI        BIT26_32        
#define CIMR_SMC1       BIT27_32        
#define CIMR_SMC2       BIT28_32        
#define CIMR_PC5        BIT29_32        
#define CIMR_PC4        BIT30_32        

/* CPM݃CT[rXWX^CISR */
#define CISR            (VW *)(IMMR_BASE + TADR_CPM_CISR)
#define CISR_BIT(device)	_CISR_BIT(device)
#define _CISR_BIT(device)	CIMR_##device

/*
 *  CPMݐrbg̒`
 */
    /*  CPM݃xN^WX^CIVRWX^IACKrbg  */
#define TA_CPM_CIVR_IACK    0x1 


/*
 *  15. NbNIƓd͐֘ÃWX^`
 */

/*  VXeNbNуZbg䃌WX^  */
#define TADR_SCCR   0x280
#define SCCR        (VW *)(IMMR_BASE + TADR_SCCR)
#define TADR_SCCRK  0x380       /*  L[WX^  */
#define SCCRK       (VW *)(IMMR_BASE + TADR_SCCRK)

#define SCCR_RTDIV  BIT7_32     /*  A^CNbN  */
                                /*  0F4ŕA1F512ŕ  */
#define SCCR_RTSEL  BIT8_32     /*  A^CNbNI  */
                                /*  0FOSCMiIV[^jA1FEXTCLK  */
#define SCCR_CRQEN  BIT9_32     /*  CPMvCl[u  */
#define SCCR_PRQEN  BIT10_32    /*  p[}lWgvCl[u  */
#define SCCR_EBDF   (BIT13_32 | BIT14_32)   /*  OoXW  */
#define SCCR_DFBRG  (BIT19_32 | BIT20_32)   /*  BRGCLK̕W  */

/*  SPLL Ad́AуZbg䃌WX^  */
#define TADR_PLPRCRK    0x384   /*  WX^EL[  */
#define TADR_PLPRCR     0x284   
#define PLPRCR_TIMIST   BIT19_32    /*  ^C}݃Xe[^X  */
#define PLPRCR_CSRC     BIT21_32    /*  NbN\[X  */
                                    /*  d̓[h  */
#define PLPRCR_LPM      (BIT22_32 | BIT23_32)
#define PLPRCR_LPM10    BIT22_32


/*
 *  16. Rg[̃WX^`
 */

/*  x[XWX^BRx  */
#define TADR_BR0    0x100
#define TADR_BR1    0x108
#define TADR_BR2    0x110
#define TADR_BR3    0x118
#define TADR_BR4    0x120
#define TADR_BR5    0x128
#define TADR_BR6    0x130
#define TADR_BR7    0x138

/*  IvVWX^ORx  */
#define TADR_OR0    0x104
#define TADR_OR1    0x10c
#define TADR_OR2    0x114
#define TADR_OR3    0x11c
#define TADR_OR4    0x124
#define TADR_OR5    0x12c
#define TADR_OR6    0x134
#define TADR_OR7    0x13c

#define TADR_MAMR   0x170   /*  }VA[hEWX^  */
#define TADR_MBMR   0x174   /*  }VB[hEWX^  */
#define TADR_MSTAT  0x178   /*  Xe[^XEWX^MSTAT  */

#define TADR_MCR    0x168   /*  ER}hEWX^MCR  */
#define TADR_MDR    0x17c   /*  Ef[^EWX^MDR  */
#define TADR_MAR    0x164   /*  EAhXEWX^MAR  */
#define TADR_MPTPR  0x17a   /*  ^C}EvXP[  */
                            /*  @@@@@@@@@@WX^MPTPR  */

/*
 *  19. ʐMvZbTCP֘ÃWX^`
 */

/*  CPR}hWX^  */
#define CPCR        (VH *)(IMMR_BASE + 0x9c0)
#define CPCR_RST            BIT0_16  /*  ZbgEtO  */
#define CPCR_FLG            BIT15_16 /*  R}hEZ}tHEtO */
#define CPCR_CH_NUM_SMC1    0x9      /*  SMC1̃`lԍ  */

/*  CPR}h̃IyR[h  */
#define CPCR_INIT_RX_TX_PARAMETERS	0x0
#define CPCR_STOP_TX			0x4
#define CPCR_RESTART_TX			0x6



/*  fAE|[gRAM̐擪AhX  */
#define DUAL_PORT_RAM   (IMMR_BASE + 0x2000)


/*
 *  20. SDMAIDMAG~[V
 *  @@@@SDMAFVADMA
 *  @@@@IDMAFzSDMA
 */

/*  SDMARtBM[VEWX^  */
#define SDCR            (VW *)(IMMR_BASE + 0x30)
	/* RISCRg[iCPj̒ID */
	/* SDMA U oXDx5Fʏ폈 */
#define SDCR_RAID_RB5   0x1

/*
 *  21. VAC^[tF[XSI֘ÃWX^`
 */

/*  SI[hEWX^  */
#define SIMODE      (VW *)(IMMR_BASE + 0xae0)
#define SIMODE_SMC1 BIT16_32    /*  SMC1̐ڑ  */
                                /*  @0:NMSI[h  */
                                /*  @1:d[h  */

                                /*  SMC1NbN\[X  */
#define SIMODE_SMC1CS   (BIT17_32 | BIT18_32 | BIT19_32)    

/*  {[[gEWFl[^ERtBM[VEWX^  */
#define BRGC1       (VW *)(IMMR_BASE + 0x9f0)
#define BRGC1_RST   BIT14_32    /*  BRGZbg  */
#define BRGC1_EN    BIT15_32    /*  BRGJEgCl[u  */
#define BRGC1_EXTC  (BIT16_32 | BIT17_32)   /*  ONbN\[X  */
#define BRGC1_ATB   BIT18_32    /*  I[g{[  */
#define BRGC1_CD    0x1ffe      /*  NbNEfoC_  */
#define BRGC1_DIV16 BIT31_32    /*  16  */


/*
 *  34. pI/O֘ÃWX^`
 */

/*  |[gBsEATCEWX^  */
#define TADR_PBPAR  0xabc
#define PBPAR       (VW *)(IMMR_BASE + TADR_PBPAR)
#define PBPAR_DD24  BIT24_32    /*  PB24sFpytF@\  */
#define PBPAR_DD25  BIT25_32    /*  PB25sFpytF@\  */
#define PBPAR_DD27  BIT27_32    /*  PB27sFpytF@\  */

/*  |[gBf[^EfBNVEWX^  */
#define TADR_PBDIR  0xab8
#define PBDIR       (VW *)(IMMR_BASE + TADR_PBDIR)
#define PBDIR_DR24  BIT24_32    /*  PB24sFytF@\1  */
#define PBDIR_DR25  BIT25_32    /*  PB25sFytF@\1  */
#define PBDIR_DR27  BIT27_32    /*  PB25sFytF@\1  */

/*  |[gBI[vEhCEWX^  */
#define TADR_PBODR  0xac0
#define PBODR       (VW *)(IMMR_BASE + TADR_PBODR)
#define PBODR_OD24  BIT24_32    /*  PB24sFI[vEhCEhCu  */
#define PBODR_OD25  BIT25_32    /*  PB25sFI[vEhCEhCu  */
#define PBODR_OD27  BIT27_32    /*  PB25sFI[vEhCEhCu  */

/*  |[gBf[^WX^  */
#define TADR_PBDAT  0xac4
#define PBDAT_D27   BIT27_32


/*  AbN̍ۂɃL[WX^ɏޒ萔  */
#define UNLOCK_KEY  0x55ccaa33

/*
 *  WX^ی̃bNƃAbN
 *
 *@@VAhCoƃ^C}hCo̗ŗp邽߁A
 *@@̃t@CɓĂ
 */

/*  SCCRbN  */
    	/*  lUNLOCK_KEYȊOłΗǂ  */
#define lock_sccr()     mpc860_wrw_mem(SCCRK, 0)

/*  SCCRAbN  */
#define unlock_sccr()	mpc860_wrw_mem(SCCRK, UNLOCK_KEY)


#endif /* _MPC860_H_ */
/*  end of file  */
