/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: tb6102s.h,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

/*
 *  ^obN@MPC860T CPU{[hTB6102S
 *  ̃n[hEFA̒`
 */

#ifndef _TB6102S_H_
#define _TB6102S_H_


/*
 *  ݊֘A̒`
 */

/*  `݂̊ɑ΂IPM̃ftHgl  */
#define DEFAULT_IPM	0x00	/*  ׂĂ݂̊֎~  */

/*  CPMSIUւ̊ݗvx  */
	/*  CICR.IRL0̐ݒlirbg16-182ij  */
#define CICR_IRL0	(CPM_INT_LEVEL << (31 - 18))

/*  SIU猩CPM̊ݔԍ  */
#define INHNO_CPM		LEVEL_TO_INHNO(CPM_INT_LEVEL)

/*  SIU猩CPM̊݋rbg  */
#define ENABLE_CPM		LEVEL_TO_ENABLE_BIT(CPM_INT_LEVEL)

/*  CPM݂IPM  */
#define IPM_CPM			LEVEL_TO_IPM(CPM_INT_LEVEL)


/*
 *  ^C}֘A̐ݒ
 *
 */
/* ^C}̊荞݃xiSIU̓xj */
#define INTLVL_PIT	INTLVL_TIMER


/*
 *  GDB STUBďo[`ij
 */
#ifndef _MACRO_ONLY
#ifdef GDB_STUB

#define tb6102s_exit	stub_exit
#define tb6102s_putc	stub_putc

Inline void
stub_exit(void)
{
}

Inline void
stub_putc(char c)
{
}

/*
 *  GDB stubgȂꍇiROMpj
 */
#else /* GDB_STUB */

extern void	smc_putc_pol(char c);	/*  mpc860_smc.c  */

/*
 *  SIL̃ANZXEO@\Lɂꍇ
 */
#ifdef SIL_DEBUG

#define SIL_BUFFER_SIZE	10000
char sil_buffer[SIL_BUFFER_SIZE];
int sil_pos;
BOOL sil_debug_on;

Inline void
tb6102s_exit()
{
	int i;

	sil_debug_on = FALSE;
	
	/*  Oobt@ÂɃf[^\  */
	for(i=sil_pos; i<SIL_BUFFER_SIZE; i++) {
		smc_putc_pol(sil_buffer[i]);
	}
	for(i=0; i<sil_pos; i++) {
		smc_putc_pol(sil_buffer[i]);
	}
	while(1);
}

Inline void 
tb6102s_putc(char c)
{
	++sil_pos;
	sil_pos %= SIL_BUFFER_SIZE;
	sil_buffer[sil_pos] = c;
}

#else	/* SIL_DEBUG */

Inline void
tb6102s_exit()
{
	while(1);
}

Inline void 
tb6102s_putc(char c)
{
	smc_putc_pol(c);
}

#endif	/* SIL_DEBUG */

#endif /* GDB_STUB */
#endif /* _MACRO_ONLY */
#endif /* _TB6102S_H_ */
/*  end of file  */
