/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: vea_oea_emb.h,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

/*  
 *   PowerPCA[LeN`VEA,OEAˑ̒`
 *   @The IBM PowerPC Embedded Environment̏ꍇ
 *   @@IBMnPowerPC40xt@~ɊYB
 *   @
 *   @PowerPCA[LeN`̒`͈ȉ̂R̃x琬
 *   @EUSIA:User Instruction Set Architecture
 *   @EVEA: Virtual Environment Architecture
 *   @EOEA: Operating Environment Architecture
 *   @
 *   @USIAɂĂ͑S@틤ʂł邪AVEAOEAɂĂ
 *   @IWiPowerPCA[LeN`The IBM PowerPC 
 *   @Embedded Environmentꂼʂɒ`Ă邽߁A
 *   @VEAOEA̒`̓t@C𕪂āACN[h
 *   @ĂB
 */   


#ifndef _VEA_OEA_EMB_H_
#define _VEA_OEA_EMB_H_

/*  
 *  WX^ԍ̒`
 */   

/*
 *  Special Purpose Register̃WX^ԍ
 *  @@(*)FPowerPCA[LeN`ł͒`ĂȂWX^
 */

/*
 *  OɊւ郌WX^
 */
#define SRR0	  26	/* Save/Restore Register0  */
#define SRR1	  27	/* Save/Restore Register1  */
#define SRR2	 990	/* Save/Restore Register2(*)  */
#define SRR3	 991	/* Save/Restore Register3(*)  */
#define ESR	 980	/* Exception Syndrome Register(*)  */
#define DEAR	 981	/* Data Exception Address Register(*)  */
#define EVPR	 982	/* Exception Vector Prefix Register(*)  */

#define SPRG0	 272	/* SPR General 0  */
#define SPRG1	 273	/* SPR General 1  */
#define SPRG2	 274	/* SPR General 2  */
#define SPRG3	 275	/* SPR General 3  */

/*
 *  ̑̃WX^
 */
#define DAC	1014	/* Data Address Compare(*) */
#define DBCR	1010	/* Debug Control Register(*) */
#define DBSR	1008	/* Debug Status Register(*) */
#define DCCR	1018	/* Data Cache Cacheability Register(*) */
#define DCWR	 954	/* Data Cache Write-thru Register(*) */

#define IAC	1012	/* Instruction Address Compare(*) */
#define ICCR	1019	/* Instruction Cache Cacheability Register(*) */

#define PID	 945	/* Process ID Register  */
#define PIT	 987	/* Programmable Interval Timer(*) */
#define PVR	 287	/* Processor Version Register  */

#define SGR	 953	/* Storage Guarded Register(*) */
#define SLER	 955	/* Storage Little-Endian Register(*) */
#define SMR	 952	/* Storage Memory-Coherent Register(*) */

/*  VEA  */
#define TBL	 268	/* Time Base Lower(for read)  */
#define TBU	 269	/* Time Base Upper(for read)  */
/*  OEA  */
#define TBLw	 284	/* Time Base Lower(for write)  */
#define TBUw	 285	/* Time Base Upper(for write)  */

#define TCR	 986	/* Timer Control Registe(*) */
#define TSR	 984	/* Timer Status Register(*) */
#define ZPR	 944	/* Zone Protection Register(*) */

/*
 *  MSR̃rbgz
 */
/*  0-10:Reserved  */
#define MSR_APE	BIT11_32	/* Auxiliary Processor Exception Enable */
#define MSR_APA	BIT12_32	/* Auxiliary Processor Available */
#define MSR_WE	BIT13_32	/* Wait State Enable */
#define MSR_CE	BIT14_32	/* Critical Enable */
#define MSR_ILE	BIT15_32	/* Interrupt Little Endian */
#define MSR_EE	BIT16_32	/* External Enable */
#define MSR_PR	BIT17_32	/* Problem State */
#define MSR_FP	BIT18_32	/* Floating Point Available */
#define MSR_ME	BIT19_32	/* Machine Check Enable */
#define MSR_FE0	BIT20_32	/* Floating Point Exception Mode 0 */
/*  21:Reserved  */
#define MSR_DE	BIT22_32	/* Debug Interrupts Enable */
#define MSR_FE1	BIT23_32	/* Floating Point Exception Mode 1 */
/*  23-25:Reserved  */
#define MSR_IR	BIT26_32	/* Instruction Relocate */
#define MSR_DR	BIT27_32	/* Data Relocate */
/*  28-30:Reserved  */
#define MSR_LE	BIT31_32	/* Little Endian */


/*
 *  ESR(Exception Syndrome Register)̃rbgz
 */
#define ESR_PIL	BIT4_32	 /* Program - Illegal Instruction exception */
#define ESR_PPR	BIT5_32	 /* Program - Privileged Instruction exception */
#define ESR_PTR	BIT6_32	 /* Program - Trap exception */
#define ESR_PFE	BIT7_32	 /* Program - Floating Point Enabled exception */
#define ESR_DST	BIT8_32	 /* Data Storage / Data TLB Miss - Store Operations */
#define ESR_DIZ	BIT9_32	 /* Data / Instruction Storage - Zone exception */
	/* Program - Auxiliary Processor Unavailable exception */
#define ESR_PAU	BIT12_32
	/* Program - Floating Point Enabled but Unimplemented exception */
#define ESR_PFEU BIT13_32
	/* Program - Auxiliary Processor Enabled exception */
#define ESR_PAE	BIT14_32


/*  
 *   CPUOv̒`
 *   @ԍsAȂ̂CPUO[xN^e[uɈꕔʂ邪A
 *   @PowerPCA[LeN`̒`ɍ킹D悵B
 */   
#define EXC_NO_CRITICAL_INPUT           	0x1
#define EXC_NO_MACHINE_CHECK            	0x2
#define EXC_NO_DATA_STORAGE             	0x3
#define EXC_NO_INSTRUCTION_STORAGE      	0x4
#define EXC_NO_EXTERNAL_INTERRUPT       	0x5   /*  O  */
#define EXC_NO_ALIGNMENT                	0x6
			/*  vOOivVj*/
#define EXC_NO_PROGRAM                  	0x7
#define EXC_NO_FLOATING_POINT_UNAVAILABLE 	0x8
/*  iAPUPowerPC405A440̂݁j  */

/*  0x900FReserved  */
/*  0xa00FReserved  */
/*  0xb00FReserved  */
#define EXC_NO_SYSTEM_CALL              	0xc	/*  VXeR[  */
/*  0xd00FReserved  */
/*  0xe00FReserved  */
/*  0xe10-0xff0FReserved  */
/* 0x1000FProgrammable Interval Timer  */
/* 0x1010FFixed Interval Timer  */
/* 0x1020FWatchdog Timer  */
/* 0x1030-0x10f0FReserved  */
/* 0x1100FData TLB miss  */
/* 0x1110-0x11f0FReserved  */
/* 0x1200FInstruction TLB miss  */
/* 0x1210-0x1ff0FReserved  */
/* 0x2000FDebugivVj   */
/* 0x2010-0x2ff0FImplementation Specific  */

/*  
 *   O̎ʐ
 *   @O݂PƐ
 *   @@0Ԃ͖gp
 *   @@@EOxN^̃ItZbgƑΉ
 *   @@@EO荞݂PƐ
 *   @@@Ez錾̂߁A+1Ă
 */   

#define TMAX_EXCNO       ( 0x20 + 1 + NUM_IMPLEMENT_EXCEPTION )


/*
 *  DCRւ̃ANZX
 *     DCR:Device Control Register
 *     ȉ̃[`̓foCXhCoɍ쐬ĂB
 *     DCR̋̓IȖ̂@\̓foCXˑłB
 *     
 *     l
 *     @mfdcr,mtdcr߂DCR̔ԍėpWX^ł͂ȂA
 *     @lŎw肷邽߁ACC֐ɂłȂB
 */

/*
 *  DCŘݒl̓Ǐo
 *     reg:WX^ԍi萔j
 *     val:ǂݏoli[ϐiUW^j
 */
#define _sil_rew_dcr(reg, val)	Asm("mfdcr %0," #reg : "=r"(val))
#define sil_rew_dcr(reg, val)	_sil_rew_dcr(reg, val)

/*
 *  DCŘݒl̕ύX
 *     reg:WX^ԍi萔j
 *     val:ݒ肷li[ꂽϐiUW^j
 */
#define _sil_wrw_dcr(reg, val)	Asm("mtdcr "#reg",%0" : : "r"(val) )
#define sil_wrw_dcr(reg, val)	_sil_wrw_dcr(reg, val)


#endif /* _VEA_OEA_EMB_H_ */
/*  end of file  */
