/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  Copyright (C) 2004 by SEIKO EPSON Corp, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 */

/*
 *  vZbTɈˑ`(S1C33p)
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

#define S1C33

/*
 *  CPU ̃oCgɊւ`
 */

#define SIL_ENDIAN		SIL_ENDIAN_LITTLE

#ifndef _MACRO_ONLY

typedef UINT	INHNO;		/* ݃nhԍ	*/
typedef UINT	EXCNO;		/* CPUOnhԍ	*/
typedef UINT	ILEVNO;		/* ݃x		*/

/*
 *  ݃xύX^擾
 */
extern	ER	chg_ilv(ILEVNO ilevno);
extern	ER	get_ilv(ILEVNO *p_ilevno);

/*
 *  ݋^֎~
 */
typedef UINT	INTNO;		/* ݔԍ		*/

/*
 *  ˑ֌Wɂ肱Ńl[
 */
#define ena_int		_kernel_ena_int
#define dis_int		_kernel_dis_int

#ifdef LABEL_ASM
#define _ena_int	__kernel_ena_int
#define _dis_int	__kernel_dis_int
#endif /* LABEL_ASM */

extern	ER	ena_int(INTNO intno);
extern	ER	dis_int(INTNO intno);

/*
 *  ݂̊݋tO̓Ǐo
 */
Inline UW
_current_intflag_(void)
{
	UW	psr;

	Asm("ld.w %0, %%psr" : "=r"(psr));
	return(psr & 0x00000010);
}

/*
 *  NMIׂĂ݂̊֎~
 */
Inline void
_disint_(void)
{
	UW	psr;

	Asm("ld.w %0, %%psr" : "=r"(psr));
	psr &= 0xffffffef;
	Asm("ld.w %%psr, %0" : : "r"(psr));
}

/*
 *  ݋tO̕
 */
Inline void
_enaint_(UW intmask)
{
	UW	psr;

	Asm("ld.w %0, %%psr" : "=r"(psr));
	psr |= intmask;
	Asm("ld.w %%psr, %0" : : "r"(psr));
}

/*
 *  ݃bNԂ̐
 */
#define SIL_PRE_LOC	UW _intmask_ = _current_intflag_()
#define SIL_LOC_INT()	_disint_()
#define SIL_UNL_INT()	_enaint_(_intmask_)

#define OMIT_VGET_TIM

typedef	UW  SYSUTIM;		/* \]pVXe */

extern ER	vxget_tim(SYSUTIM *p_sysutim) throw();

/*
 *  VXe̒f
 */

Inline void
kernel_abort (void)
{
	while (1){
		;
	}
}

#endif /* _MACRO_ONLY */
#endif /* _CPU_DEFS_H_ */
