/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  Copyright (C) 2004 by SEIKO EPSON Corp, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 */

/*
 *  ^[QbgˑVAI/OW[
 */

#include "jsp_kernel.h"
#include "hw_serial.h"

/*
 *  VA|[g̏ubN
 */

const SIOPINIB siopinib_table[TNUM_PORT] = {

	{
		0,
		S1C33_INHNO_SERIAL0ERR,
		S1C33_INHNO_SERIAL0RX,
		S1C33_INHNO_SERIAL0TX,
	},
#if TNUM_PORT == 2
	{
		1,
		S1C33_INHN1_SERIAL0ERR,
		S1C33_INHN1_SERIAL0RX,
		S1C33_INHN1_SERIAL0TX,
	},
#endif	/* of #if TNUM_PORT == 2 */
};


/*
 *  VA|[g̐ubN
 */

SIOPCB siopcb_table[TNUM_PORT];

/*
 *  SIO ID ǗubNւ̕ϊ}N
 */
#define get_siopinib(sioid)	(&(siopinib_table[INDEX_SIO(sioid)]))
#define get_siopcb(sioid)	(&(siopcb_table[INDEX_SIO(sioid)]))

/*
 *  M荞݃T[rX[`.
 */

void
sio_in_service(ID sioid)
{
	SIOPCB	*pcb;

	sio_clr_errflag(INDEX_SIO(sioid));
	pcb = get_siopcb(sioid);
	if (pcb->rx_cbrflag){
		/* M\R[obN[`ďoB*/
		sio_ierdy_rcv(pcb->exinf);
	}
}

/*
 *  M荞݃T[rX[`
 */

void
sio_out_service(ID sioid)
{
	SIOPCB	*pcb;

	pcb = get_siopcb(sioid);
	if (pcb->tx_cbrflag){
		/* M\R[obN[`ďoB*/
		sio_ierdy_snd(pcb->exinf);
	}
}

#ifdef SIO_ERR_HANDLER

/*
 *  MG[荞݃T[rX[`
 */

void
sio_err_service(ID sioid)
{
	SIOPCB	*pcb;
	UB	status;

	/* G[tONA */
	sio_clr_errflag(INDEX_SIO(sioid));

	/* |[gēx */
	sio_opn_por(sioid, (VP_INT)NULL);
}

#endif	/* of #ifdef SIO_ERR_HANDLER */

/*
 *  VA|[ge[u
 */

void
sio_initialize (void)
{
	int iLoop;

	/*
	 *  SIO ubN̏
	 */
	for (iLoop = 0 ; iLoop < TNUM_PORT ; iLoop++ ) {
		siopcb_table[iLoop].inib     = &siopinib_table[iLoop];
		siopcb_table[iLoop].exinf    = (VP_INT)NULL;
		siopcb_table[iLoop].openflag = FALSE;
		siopcb_table[iLoop].tx_cbrflag  = FALSE;
		siopcb_table[iLoop].rx_cbrflag  = FALSE;
	}
}

/*
 *  R[obN
 */
void
sio_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	UB	ch_no, sio_ctl;

	ch_no  = siopcb->inib->ch_no;
	sio_ctl = ((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[ch_no].bControl;
	switch (cbrtn){
	case	SIO_ERDY_SND:
		siopcb->tx_cbrflag = TRUE;
		break;
	case	SIO_ERDY_RCV:
		siopcb->rx_cbrflag = TRUE;
		break;
	}

	return;
}

/*
 *  R[obN֎~
 */
void
sio_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	UB	ch_no, sio_ctl;

	ch_no  = siopcb->inib->ch_no;
	sio_ctl = ((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[ch_no].bControl;
	switch (cbrtn){
	case	SIO_ERDY_SND:
		siopcb->tx_cbrflag = FALSE;
		break;
	case	SIO_ERDY_RCV:
		siopcb->rx_cbrflag = FALSE;
		break;
	}

	/*
	 *  M@\Lrbgݒ肷
	 */
	((s1c33Serial_t *)S1C33_SERIAL_BASE)->stChannel01[ch_no].bControl = sio_ctl;

	return;
}

/*
 *  SIO 荞
 */

void
sio_in_handler (void)
{
	sio_clr_factor(SIO_INT_RCV);
	sio_in_service(1);
}

void
sio_out_handler (void)
{
	sio_clr_factor(SIO_INT_SND);
	sio_out_service(1);
	}

#ifdef SIO_ERR_HANDLER

void
sio_err_handler (void)
{
	sio_clr_factor(SIO_INT_ERR);
	sio_err_service(1);
	}

#endif	/* of #ifdef SIO_ERR_HANDLER */

#if TNUM_PORT >= 2

void
sio_in2_handler (void)
{
	sio_clr_factor(SIO_INT_RCV << 3);
	sio_in_handler(2);
	}

void
sio_out2_handler (void)
{
	sio_clr_factor(SIO_INT_SND << 3);
	sio_out_handler(2);
	}

#ifdef SIO_ERR_HANDLER

void
sio_err2_handler (void)
{
	sio_clr_factor(SIO_INT_ERR << 3)
	sio_err_handler(2);
	}

#endif	/* of #ifdef SIO_ERR_HANDLER */

#endif	/* of #if TNUM_PORT >= 2 */
