/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  Copyright (C) 2004 by SEIKO EPSON Corp, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include "s_services.h"

/*
 *  ^C}݃nh̃xN^ԍ
 */
#define INHNO_TIMER		S1C33_INHNO_P16TIMER1B

#define S1C33_P16TIMER_CLOCK	40000000

#ifndef _MACRO_ONLY
/*
 *  O֐̎Q
 */
extern	ER	ena_int(INHNO);
extern	ER	dis_int(INHNO);

/*
 *  16rbg^C}1̏
 */
Inline void
hw_timer_initialize(void)
{
	/*
	 *  16rbg^C}1B ݋֎~
	 */
	dis_int(INHNO_TIMER);

	/*
	 *  16rbg^C}1B ݗvNA
	 */
	(*(s1c33Intc_t *) S1C33_INTC_BASE).bIntFactor[2] |= 0x40;

	/*
	 *  16bit^C}1ݒ
	 *
	 *  ^C}NbNON  16  16rbg^C}1B  1ms
	 */
	(*(s1c33TimerControl_t *) S1C33_TIMER_CONTROL_BASE).bP16ClkCtrl[1]
		= 0x0b;
	(*(s1c33P16Timer_t *) S1C33_P16TIMER_BASE).stChannel[1].uwComp[1]
		= ((S1C33_P16TIMER_CLOCK * 1) / (16 * 1000));

	/*
	 *  16rbg^C}Zbg
	 */
	(*(s1c33P16Timer_t *) S1C33_P16TIMER_BASE).stChannel[1].bControl = 0x02;

	/*
	 *  16rbg^C}1B ݋
	 */
	ena_int(INHNO_TIMER);


	/*
	 *  16rbg^C}1 Jn
	 */
	(*(s1c33P16Timer_t *) S1C33_P16TIMER_BASE).stChannel[1].bControl = 0x01;

	return;
}

/*
 *  16rbg^C}1ݗṽNA
 */
Inline void
hw_timer_int_clear(void)
{
	/*
	 *  16rbg^C}1B ݗvNA
	 */
	(*(s1c33Intc_t *) S1C33_INTC_BASE).bIntFactor[2] |= 0x40;

	return;
}

/*
 *  16rbg^C}1̒~
 */
Inline void
hw_timer_terminate(void)
{
	/*
	 *  16rbg^C}1B ݋֎~
	 */
	dis_int(INHNO_TIMER);

	/*
	 *  16rbg^C}1~
	 */
	(*(s1c33P16Timer_t *) S1C33_P16TIMER_BASE).stChannel[1].bControl = 0x00;

	return;
}

#endif /* _MACRO_ONLY  */
#endif /* _HW_TIMER_H_ */
