/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sh1_sil.h,v 1.1 2008/06/17 00:04:54 suikan Exp $
 */

/*
 *  SH1̐䃌WX^ւ̃ANZXE[eBeBirbgZj
 *  
 *  sh1.hɋLq̂GKgAsil.hƂ̃CN[h
 *  Ԃ̊֌WœƗt@CƂ
 *  t_config.h𒼐ڃCN[hƂsil.hɂ
 *  t@CCN[h\B
 *  
 *  RpČ^`FbN@\Lɂ邽߁A|C^^
 *  VB *AVH *AVW *pĂB
 *  
 */

#ifndef _SIL_SH1_H_
#define _SIL_SH1_H_

#ifndef _MACRO_ONLY

/*
 *  8rbgWX^ANDZ
 */
Inline void
sh1_anb_reg(VB *mem, VB data)
{
	VB reg = sil_reb_mem((VP)mem);
	reg &= data;
	sil_wrb_mem((VP)mem, reg);
}

/*
 *  8rbgWX^ORZ
 */
Inline void
sh1_orb_reg(VB *mem, VB data)
{
	VB reg = sil_reb_mem((VP)mem);
	reg |= data;
	sil_wrb_mem((VP)mem, reg);
}


/*
 *  16rbgWX^ANDZ
 */
Inline void
sh1_anh_reg(VH *mem, VH data)
{
	VH reg = sil_reh_mem((VP)mem);
	reg &= data;
	sil_wrh_mem((VP)mem, reg);
}

/*
 *  16rbgWX^ORZ
 */
Inline void
sh1_orh_reg(VH *mem, VH data)
{
	VH reg = sil_reh_mem((VP)mem);
	reg |= data;
	sil_wrh_mem((VP)mem, reg);
}

/*
 *  32rbgWX^ANDZ
 */
Inline void
sh1_anw_reg(VW *mem, VW data)
{
	VW reg = sil_rew_mem((VP)mem);
	reg &= data;
	sil_wrw_mem((VP)mem, reg);
}

/*
 *  32rbgWX^ORZ
 */
Inline void
sh1_orw_reg(VW *mem, VW data)
{
	VW reg = sil_rew_mem((VP)mem);
	reg |= data;
	sil_wrw_mem((VP)mem, reg);
}


/*
 *  荞݃x̐ݒ
 *  
 *  @mem  FύX郌WX^̔Ԓn
 *  @levelFݒ肷銄݃x
 *  @shiftFrbgVtgƂ낪Y
 *  
 */
Inline void
define_int_plevel(VH *mem, UW level, UINT shift)
{
	VH reg = sil_reh_mem((VP)mem);
	reg = (VH)((reg & ~(0xfu << shift)) | (level << shift));
	sil_wrh_mem((VP)mem, reg);
}



#endif /* _MACRO_ONLY */
#endif	/*  _SIL_SH1_H_  */
