/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000,2001 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002 by Hokkaido Industrial Research Institute, JAPAN
 *
 *  L쌠҂́CFree Software Foundation ɂČ\Ă
 *  GNU General Public License  Version 2 ɋLqĂC
 *  ̏̂ꂩ𖞂ꍇɌC{\tgEFAi{\tgEF
 *  Aς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFAėp\ȃoCiR[hiP[^uIu
 *      WFNgt@C⃉CuȂǁǰ`ŗpꍇɂ́Cp
 *      ɔhLgip҃}jAȂǁjɁCL̒쌠\C
 *      ̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAėps\ȃoCiR[ȟ`܂͋@ɑg
 *      ݍ񂾌`ŗpꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) pɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) p̌`ԂCʂɒ߂@ɂāCL쌠҂ɕ񍐂
 *        ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂Ɛӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂́C
 *  {\tgEFAɊւāC̓Kp\܂߂āCȂۏ؂s
 *  ȂD܂C{\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ
 *  Ȃ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *  @(#) $Id: sh7145.h,v 1.1 2008/06/17 00:04:40 suikan Exp $
 */

#ifndef _SH7145_H_
#define _SH7145_H_

#include <sil.h>

/*
 *  ݂̃xN^ԍ`
 */

#define ERI0	128				/*  SCI0    */
#define RXI0	129				/*  SCI0    */
#define TXI0	130				/*  SCI0    */
#define ERI1	132				/*  SCI1    */
#define RXI1	133				/*  SCI1    */
#define TXI1	134				/*  SCI1    */
#define CMI0	144				/*  CMT    */
#define ERI2	168				/*  SCI2    */
#define RXI2	169				/*  SCI2    */
#define TXI2	170				/*  SCI2    */

#ifndef _MACRO_ONLY

/*
 *  SH2̓WX^`
 */
/* W[X^oCWX^ */
#define MSTCR1	((VH *)0xffff861c)
#define MSTCR2	((VH *)0xffff861e)

#define BCR1	((VH *)0xffff8620)
#define BCR2	((VH *)0xffff8622)
#define WCR1	((VH *)0xffff8624)
#define PACRH	((VH *)0xffff8388)
#define PACRL1	((VH *)0xffff838c)
#define PACRL2	((VH *)0xffff838e)
#define PBCR1	((VH *)0xffff8398)
#define PBCR2	((VH *)0xffff839a)
#define PCCR	((VH *)0xffff839c)
#define PDCRH1	((VH *)0xffff83a8)
#define PDCRH2	((VH *)0xffff83aa)
#define PDCRL1	((VH *)0xffff83ac)
#define PDCRL2	((VH *)0xffff83ae)
#define PECRL1	((VH *)0xffff83b8)
#define PECRL2	((VH *)0xffff83ba)
#define PAIORL	((VH *)0xffff8386)
#define PBIOR	((VH *)0xffff8394)
#define PEIORL	((VH *)0xffff83b4)
#define PEDRL	((VH *)0xffff83b0)

/* 荞ݗDxxݒ背WX^ */
#define IPRA    ((VH *)0xffff8348)
#define IPRB    ((VH *)0xffff834a)
#define IPRC    ((VH *)0xffff834c)
#define IPRD    ((VH *)0xffff834e)
#define IPRE    ((VH *)0xffff8350)
#define IPRF    ((VH *)0xffff8352)
#define IPRG    ((VH *)0xffff8354)
#define IPRH    ((VH *)0xffff8356)
#define IPRI    ((VH *)0xffff835c)
#define IPRJ    ((VH *)0xffff835e)

/*
 * 荞݃Rg[̏
 */
Inline void sh2_init_intcontorller(void)
{
	sil_wrh_mem (IPRA, 0x0000);
	sil_wrh_mem (IPRB, 0x0000);
	sil_wrh_mem (IPRC, 0x0000);
	sil_wrh_mem (IPRD, 0x0000);
	sil_wrh_mem (IPRE, 0x0000);
	sil_wrh_mem (IPRF, 0x0000);
	sil_wrh_mem (IPRG, 0x0000);
	sil_wrh_mem (IPRH, 0x0000);
	sil_wrh_mem (IPRI, 0x0000);
	sil_wrh_mem (IPRJ, 0x0000);
}
#endif /* _MACRO_ONLY */

#endif /* _SH7145_H_ */
