/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sh7145sci.c,v 1.1 2008/06/17 00:04:40 suikan Exp $
 */

/*
 *   SH2VAR~jP[VC^tF[XSCIp ȈՃhCo
 */

#include <s_services.h>
#include "sh7145sci.h"

/*
 * VAI/O|[gubN
 */
#ifndef GDB_STUB
const SIOPINIB siopinib_table[TNUM_PORT] = {
	{0xffff81b0, BRR9600, 0x0, 6}, /* SCI1 */
#if TNUM_PORT >= 2
	{0xffff81a0, BRR9600, 0x0, 6}, /* SCI0 */
#endif /* TNUM_PORT >= 2 */
};
#else /* GDB_STUB */
const SIOPINIB siopinib_table[TNUM_PORT] = {
	{0xffff81a0, BRR9600, 0x0, 6}, /* SCI0 */
};
#endif /* GDB_STUB */


/*
 *  VAI/O|[gǗubÑGA
 */
static SIOPCB siopcb_table[TNUM_PORT];

/*
 *  VAI/O|[gIDǗubNo߂̃}N
 */
				/*  |[gIDfoCXԍ߂}N  */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  Mł邩H
 */
Inline BOOL
sh2sci_getready (SIOPCB * siopcb)
{
	/*  V[uf[^WX^tEtÕ`FbN  */
	return (sil_reb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SSR)) &
			SSR_RDRF);
}

/*
 *  𑗐Mł邩H
 */
Inline BOOL
sh2sci_putready (SIOPCB * siopcb)
{
	/*  gX~bgf[^WX^GveBEtÕ`FbN */
	return (sil_reb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SSR)) &
			SSR_TDRE);
}

/*
 *  M̎o
 */
Inline char
sh2sci_getchar (SIOPCB * siopcb)
{
	char data;

	data = sil_reb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_RDR));
	/*  V[uf[^WX^tEtÕNA  */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SSR),
				 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
									  SCI_SSR)) & ~SSR_RDRF);
	return data;
}

/*
 *  M镶̏
 */
Inline void
sh2sci_putchar (SIOPCB * siopcb, char c)
{
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_TDR), c);
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SSR),
				 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
									  SCI_SSR)) & ~SSR_TDRE);
}

/*
 *  SIOhCȍ[`
 */
void
sh2sci_initialize ()
{
	SIOPCB *siopcb;
	UINT i;

	/*
	 *  VAI/O|[gǗubN̏
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_PORT; siopcb++, i++) {
		siopcb->openflag = FALSE;
		siopcb->siopinib = (&siopinib_table[i]);
	}
}

/*
 *  I[vĂ|[g邩H
 */
BOOL
sh2sci_openflag (ID siopid)
{
	return (siopcb_table[siopid - 1].openflag);
}

/*
 *  VAI/O|[g̃I[v
 */
SIOPCB *
sh2sci_opn_por (ID siopid, VP_INT exinf)
{
	SIOPCB *siopcb = get_siopcb (siopid);

	/*  M~  */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SCR), 0x00);

	/*  SCIf[^o̓|[g̐ݒ  */
	/*  sATC */
	/* sys_initializeŐݒ */

	/*  MtH[}bg  */
	/*    */
	/*  8rbgApeBȂ  */
	/*  XgbvrbgOXF1   */
	/*  NbNZNg */

	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SMR),
				 siopcb->siopinib->smr);
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_BRR),
				 (VB) siopcb->siopinib->brr);

	/*
	 * {[[g̐ݒA1JEg҂Ȃ΂ȂȂB
	 */
	sil_dly_nse (sh2sci_DELAY);	/* l͂PƓ */

	/* G[tONA */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SSR),
				 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
									  SCI_SSR)) & ~(SSR_ORER | SSR_FER |
													SSR_PER));
	/*MAM荞݋ */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SCR),
				 (VB) (SCI_RIE | SCI_TE | SCI_RE));

	siopcb->exinf = exinf;
	siopcb->openflag = TRUE;
	return (siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void
sh2sci_cls_por (SIOPCB * siopcb)
{
	/*  M~A݋֎~  */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SCR),
				 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
									  SCI_SCR)) & (VB) ~ (SCI_TIE | SCI_RIE |
														  SCI_TE | SCI_RE));
	siopcb->openflag = FALSE;
}

/*
 *  VAI/O|[gւ̕M
 */
BOOL
sh2sci_snd_chr (SIOPCB * siopcb, char c)
{
	if (sh2sci_putready (siopcb)) {
		sh2sci_putchar (siopcb, c);
		return (TRUE);
	}
	return (FALSE);
}

/*
 *  VAI/O|[g̕M
 */
INT
sh2sci_rcv_chr (SIOPCB * siopcb)
{
	if (sh2sci_getready (siopcb)) {
		return ((INT) (UB) sh2sci_getchar (siopcb));
		/*  (UB)ŃLXĝ̓[gɂ邽  */
	}
	return (-1);
}

/*
 *  VAI/O|[g̃R[obN̋
 */
void
sh2sci_ena_cbr (SIOPCB * siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:			/* M荞ݗv */
		sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SCR),
					 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
										  SCI_SCR)) | SCI_TIE);
		break;
	case SIO_ERDY_RCV:			/* M荞ݗv */
		sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SCR),
					 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
										  SCI_SCR)) | SCI_RIE);
		break;
	}
}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
sh2sci_dis_cbr (SIOPCB * siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:			/* M荞ݗv֎~ */
		sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SCR),
					 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
										  SCI_SCR)) & ~SCI_TIE);
		break;
	case SIO_ERDY_RCV:			/* M荞ݗv֎~ */
		sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SCR),
					 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
										  SCI_SCR)) & ~SCI_RIE);
		break;
	}
}

/*
 *  VAI/O|[gɑ΂鑗Mݏ
 */
Inline void
sh2sci_isr_siop_out (SIOPCB * siopcb)
{
	VB scr0 = sil_reb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SCR));

	if ((scr0 & SCI_TIE) != 0 && sh2sci_putready (siopcb)) {
		/*
		 *  MʒmR[obN[`ĂяoD
		 */
		sh2sci_ierdy_snd (siopcb->exinf);
	}
}

/*
 *  VAI/O|[gɑ΂Mݏ
 */
Inline void
sh2sci_isr_siop_in (SIOPCB * siopcb)
{
	VB scr0 = sil_reb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SCR));

	if ((scr0 & SCI_RIE) != 0 && sh2sci_getready (siopcb)) {
		/*
		 *  MʒmR[obN[`ĂяoD
		 */
		sh2sci_ierdy_rcv (siopcb->exinf);
	}
}

/*
 *  VAI/O|[gɑ΂MG[ݏ
 */
Inline void
sh2sci_isr_siop_err (SIOPCB * siopcb)
{
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCI_SSR),
				 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
									  SCI_SSR)) & ~(SSR_ORER | SSR_FER |
													SSR_PER));
}

/*
 *  SCIM݃T[rX[`
 *  
 */
void
sh2sci_isr_out (void)
{
	if (siopcb_table[0].openflag) {
		sh2sci_isr_siop_out (get_siopcb (1));
	}
}

/*
 *  SIOM݃T[rX[`
 *  
 */
void
sh2sci_isr_in (void)
{
	if (siopcb_table[0].openflag) {
		sh2sci_isr_siop_in (get_siopcb (1));
	}
}

/*
 *  SIOMG[݃T[rX[`
 */
void
sh2sci_isr_error (void)
{
	if (siopcb_table[0].openflag) {
		sh2sci_isr_siop_err (get_siopcb (1));
	}
}

/*
 * |[Oɂ镶̑M
 */
void
sh2sci_putc_pol (ID portid, char c)
{
	while (!sh2sci_putready (&siopcb_table[portid - 1]));
	sh2sci_putchar (&siopcb_table[portid - 1], c);
}


#if TNUM_PORT >= 2
/*
 *  SIOM݃T[rX[`
 *  
 */
void
sh2sci_isr2_in (void)
{
	if (siopcb_table[1].openflag) {
		sh2sci_isr_siop_in (get_siopcb (2));
	}
}

/*
 *  SCIM݃T[rX[`
 *  
 */
void
sh2sci_isr2_out (void)
{
	if (siopcb_table[1].openflag) {
		sh2sci_isr_siop_out (get_siopcb (2));
	}
}

/*
 *  SIOMG[݃T[rX[`
 */
void
sh2sci_isr2_error (void)
{
	if (siopcb_table[1].openflag) {
		sh2sci_isr_siop_err (get_siopcb (2));
	}
}
#endif /* of #if TNUM_PORT >= 2 */
