/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *                     2003         by Advanced Data Controls, Corp
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *  @(#) $Id: cpu_defs.h,v 1.1 2008/06/17 00:04:54 suikan Exp $
 */

/*
 *  vZbTɈˑ`iSH3/4pj
 *
 *  ̃CN[ht@ĆCkernel.h  sil.h ŃCN[hD
 *  ̃t@C璼ڃCN[h邱Ƃ͂ȂD̃t@CC
 *  N[hOɁCt_stddef.h  itron.h CN[ĥŁC
 *  ɈˑĂ悢D
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

/*
 *  vZbTɈˑ`
 */
#ifndef _MACRO_ONLY

/*
 * /CPUOnhԍ̌^
 */
typedef	UINT		INHNO;		/* ݃nhԍ */
typedef	UINT		EXCNO;		/* CPUOnhԍ */


/*
 * ݃}XŇ^Ɗ݃}XN̕ύX/Q
 */
typedef	UINT		IPM;		/* ݃}XN */

extern ER	chg_ipm(IPM ipm)  throw();
extern ER	get_ipm(IPM *p_ipm)  throw();


/*
 *  INTNO^Ɗ݂̋֎~/
 */
typedef	UINT		INTNO;		/* ݔԍ */

extern ER	dis_int(INTNO intno)  throw();
extern ER	ena_int(INTNO intno)  throw();


/*
 *  ^[QbgVXeˑ̃T[rXR[
 */
#ifdef _int64_
typedef	UD  SYSUTIM;	       /* \]pVXe */
#else
typedef	UINT  SYSUTIM;	       /* \]pVXe */
#endif
extern ER	vxget_tim(SYSUTIM *p_sysutim) throw();

/*
 *  Xe[^XWX^iSRǰݒl̓Ǐo
 */
asm unsigned int __current_sr(void)
{
%
    stc sr,r0
}
/*
 *  Xe[^XWX^iSRǰݒl̕ύX
 */
asm void __set_sr(s)
{
%reg s

   ldc s,sr
}



/*
 * ݂̊݃}XN̓Ǐo
 */
Inline UW
_current_intmask_()
{
    return(__current_sr() & 0x000000f0);
}

/*
 *  SĂ݂̊֎~
 */

Inline void
_disint_()
{
    UW sr;
    
    sr = __current_sr();
	sr |= 0x000000f0;
    __set_sr(sr);
}

/*
 *  ݃}XN̐ݒ
 */
Inline void
_set_intmask_(UW intmask)
{
    UW sr;
    
    sr=__current_sr();
    sr = (sr & ~0x000000f0) | intmask;
    __set_sr(sr);
}


/*
 * ݃bNԂ̐
 */
#define SIL_PRE_LOC UW _intmask_ = _current_intmask_()
#define SIL_LOC_INT()   _disint_()
#define SIL_UNL_INT()   _set_intmask_(_intmask_)


#endif /* _MACRO_ONLY */
#endif /* _CPU_DEFS_H_ */
