/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_support.S,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */


#define _MACRO_ONLY
#include "jsp_kernel.h"
#include "offset.h"
#include <t_config.h>
        
 			
/*
 *  O/荞ݏo[`
 *  SH3̓xN^e[uAO,TRAPAVBR+0x100ԒnA
 *  /O/NMI荞݂ƁAVBR+0x600ԒnsB
 */
        
/*
 *	VBR ɐݒ肷l
 */
    .section .text
    .align 2        
    .global _BASE_VBR
_BASE_VBR:   
     nop 
     nop
     nop

/*
 *  Exception 100 vector
 *  AhXG[,XbgsߗOATrapaOƎsB
 *
 *  CPUOnh́A^XNReLXgŎsÂ߁ACPUOn
 *  hĂяoOɗO/荞݂WX^oN1 r7 WX^C
 *  NgA^[ĂɃfNgBCPUO^XNReL
 *  XgŔAregflg  TRUE ɂȂɁA ret_exc ֕򂷂B
 *  regflg `FbNOɊ荞݂֎~ȂƁAreqflg `FbNɋN
 *  ꂽ荞݃nhŃfBXpb`vꂽꍇɁAfBXpb`
 *  ȂB
 *
 *		
 *  OƁAÕReLXgłspc,pr,ssr,r0`r7ޔ
 *  BO_ł̃ReLXg𒲂ה^XNReLXgȂ
 *  _exception_from_intsJnBO̗vEXPEVTWX^ǂ݁A
 *  exc_tableCPUOnh̊JnԒnǂݍށBOɑ΂
 *  CPUOnho^ĂȂ΁A_no_reg_exceptionɃu`āA
 *  ssr,sr,spc,pr̓eo͂Ē~BCPUOnh烊^[
 *  Areqflg𒲂0ȊOȂrec_exc()ɔсA0Ȃ猳̏Ƀ^[
 *  B
 *
 *
 *  BLrbg̈ɂ
 *  ssr,spc ɖ߂̃ReLXg߂ rte 𔭍sۂɂ́C݁iNMI 
 *  ܂ށj󂯕tȂ悤 BL rbg1ɂKvDO/݃n
 *  hIɂ BL rbg1ɂ IPM  MAX_IPM ɐݒ肷D́C
 *  BL rbg1̏ꍇɗO CPU Zbg邱ƂlāC
 *  Ŝ߁Cssr,spc𕜋A钼OBL1ɐݒ肵ĂD
 *       
 */	
			

    .org   0x0100              /*  _BASE_VBR + 0x0100Ԓnɔzu   */
    .align 2
    .global _general_exception
_general_exception:
    stc.l  spc,@-r15           /* spc,pr,ssr X^bNɕۑ */
    sts.l  pr,@-r15               
    stc.l  ssr,@-r15
    stc.l  gbr,@-r15					
    sts.l  macl,@-r15					
    sts.l  mach,@-r15					                        
    stc.l  r0_bank,@-r15       /* Or0`r7ۑ        */
    stc.l  r1_bank,@-r15
    stc.l  r2_bank,@-r15
    stc.l  r3_bank,@-r15
    stc.l  r4_bank,@-r15
    stc.l  r5_bank,@-r15
    stc.l  r6_bank,@-r15    
    stc.l  r7_bank,@-r15
    tst    r7,r7               /* ÕReLXg𔻒            */
    bf/s   _exception_from_exc /* O/荞݃nhȂWv */
     add    #0x01,r7	       /* O/荞݃lXg񐔂CNg   */
    mov    r15,r1              /* ߂悪荞݃nhłȂ̂ŃX^b  */
    mov.l  _stacktop_exc,r15   /* Nւ̃X^bN|C^ۑ    */ 
    mov.l  r1,@-r15 
    mov.l  _expevt,r0          /* OƏ郌WX^ۑ      */
    mov.l  @r0,r5              /* EXPEVTWX^擾                      */
    ldc    r1,r4_bank          /* CPUOnhւ̈                   */
    ldc    r5,r5_bank	     
    mov.l  _unmak_rb_bl_exc,r2 /* BLrbg0ɁCWX^oN؂ւ   */
    stc    sr,r3               
    and    r3,r2			
    ldc    r2,sr               
    shlr2  r5                  /* EXPEVT3rbgEVtg                   */
    shlr   r5                
    mov.l  _exc_table_exc,r0   /* exc_tablẽAhXr0                 */
    mov.l  @(r0,r5),r2         /* nh̃AhX擾                  */
    tst    r2,r2               /* nho^ĂȂOȂ        */
    bt     _no_reg_exception   /* no_reg_exceptionփWv                */
    jsr    @r2                 /* CPUOnh                         */
     nop
    mov.l  _mask_md_ipm_exc,r0
    ldc    r0,sr               /* 荞݋֎~                              */
    stc    r7_bank,r7          /* O/荞݂̃lXg񐔂fNg   */
    dt     r7
    ldc    r7,r7_bank
    mov.l  _reqflg_exc,r2      /* reqflg̃`FbN                          */
    mov.l  @r2,r1
    tst    r1,r1               /* reqflgFALSEȂret_to_task_excɔ    */
    bt/s   _ret_to_task_exc    /* ^XNɖ߂                              */
     mov.l  @r15,r15           /* ߂悪^XNȂ̂ŃX^bN߂        */
    xor    r0,r0               
    bra    ret_exc
     mov.l  r0,@r2             /* reqflgNA                            */


/*
 *   exception_from_int
 *   CPUÕReLXg^XNReLXg̏ꍇ̏
 *   ^XNReLXg̏ꍇƂ̏̈Ⴂ́ACPUOnh
 *   IƕK̏ɖ߂邱ƂłB
 */
	
_exception_from_exc:
    mov.l   _expevt,r0        /* OƏ郌WX^ۑ      */
    mov.l   @r0,r5            /* EXPEVTWX^擾                      */
    ldc     r15,r4_bank       /* CPUOnhւ̈                   */
    ldc     r5,r5_bank	     
    mov.l   _unmak_rb_bl_exc,r2 /* BLrbg0ɁCWX^oN؂ւ */
    stc     sr,r3
    and     r3,r2			
    ldc     r2,sr               
    shlr2   r5                /* EXPECT3rbgEVtg                   */
    shlr    r5                	
    mov.l   _exc_table_exc,r0 /* exc_tablẽAhXr0                 */
    mov.l   @(r0,r5),r2       /* nh̃AhX擾                  */
    tst     r2,r2             /* nho^ĂȂOȂ        */
    bt      _no_reg_exception /* no_reg_exceptionփWv                */
    jsr     @r2               /* CPUOnh                         */
     nop
    mov.l  _mask_md_ipm_exc,r0
    ldc    r0,sr              /* BL=1,荞݋֎~                         */
    stc    r7_bank,r7         /* O/荞݂̃lXg񐔂fNg   */
    dt     r7
    ldc    r7,r7_bank
_ret_to_task_exc:
    mov.l  @r15+,r7           /* r0`r1,ssr,pr,spc𕜋A^XNɖ߂     */
    mov.l  @r15+,r6
    mov.l  @r15+,r5
    mov.l  @r15+,r4
    mov.l  @r15+,r3
    mov.l  @r15+,r2
    mov.l  @r15+,r1        
    mov.l  _mask_md_bl_exc,r0 
    ldc    r0,sr             /* BL1                                   */
    mov.l  @r15+,r0
    lds.l  @r15+,mach                
    lds.l  @r15+,macl        
    ldc.l  @r15+,gbr               
    ldc.l  @r15+,ssr            
    lds.l  @r15+,pr
    ldc.l  @r15+,spc
    rte
     nop


/*	
 *  no_reg_exception()
 *  CPUOƂēo^ĂȂOƌĂяo
 *  OR[hAO_pc,sr,pro͂ăJ[l
 *  ~B
 */					
_no_reg_exception:
    mov.l  _expevt,r5
    mov.l  @r5,r4
    stc    spc,r5
    stc    ssr,r6
    sts    pr,r7
    mov.l  _cpu_expevt_k,r1
    jsr    @r1
     nop

	.align  4
_stacktop_exc:	
    .long  STACKTOP            /* ^XNƗ̃X^bN̏l  */
_expevt:	
    .long  EXPEVT
_exc_table_exc:	
    .long  _exc_table
_unmak_rb_bl_exc:		
    .long  0x4fffffff
_mask_md_ipm_exc:	
    .long  0x40000000 + MAX_IPM << 4	
_reqflg_exc:
    .long  _reqflg
_cpu_expevt_k:	
    .long  _cpu_expevt	
_mask_md_bl_exc:	
    .long  0x50000000 + MAX_IPM << 4	



	
/*
 *  ^XNfBXpb`
 *
 *  _dispatch ́Ar7_bank1 = 0,݋֎~ԂŌĂяoȂ΂Ȃ
 *  D_exit_and_dispatch Cr7_bank1 = 0E݋֎~ԂŌĂяo
 *  ̂ł邪CJ[lNɑΉ邽߁Cr7_bank1 = 1ŌĂ
 *  oꍇɂΉĂD
 */

    .text
    .align 2
    .global _dispatch
_dispatch:
    sts.l  pr,@-r15         /* pr,r8`r15 X^bNɕۑ           */
    mov.l  r14,@-r15        /* r0`r7͌ĂяoŕۑĂ邽  */    
    mov.l  r13,@-r15        /* ۑKv                    */    
    mov.l  r12,@-r15
    mov.l  r11,@-r15
    mov.l  r10,@-r15
    mov.l  r9, @-r15
    mov.l  r8, @-r15
    mov.l  _runtsk_dis,r2   /* r0 <- runtsk                          */
    mov.l  @r2,r0
    mov.l  r15,@(TCB_sp,r0) /* ^XNX^bNTCBɕۑ 60ȉȂOK*/		
    mov.l  dispatch_r_k,r1  /* sĊJԒnۑ                    */
    mov.l  r1,@(TCB_pc,r0)  /* sĊJԒnTCBɕۑ  60ȉȂOK */
    bra    dispatcher
     nop

dispatch_r:	
    mov.l  @r15+,r8         /* WX^𕜋A                       */
    mov.l  @r15+,r9
    mov.l  @r15+,r10
    mov.l  @r15+,r11
    mov.l  @r15+,r12
    mov.l  @r15+,r13
    mov.l  @r15+,r14
    lds.l  @r15+,pr
    /*
     *  ^XNO[`̋N
     *  dispatch_rdispatcherĂяo邽߁C
     *  tcb̃AhXr0ɓĂD      
     */
    mov.l  @(TCB_enatex,r0),r1
    mov.l  _enatex_mask_dis,r2
    tst    r1,r2
    bt     dispatch_r_1         /* enatex  FALSE Ȃ烊^[ */
    mov.l  @(TCB_texptn,r0),r1  /* texptn[h               */
    tst    r1,r1
    bt     dispatch_r_1         /* texptn  0Ŗ        */
    mov.l  _call_texrtn_dis,r1  /* ^XNO[`̌Ăяo */
    jmp    @r1        
     nop                          
dispatch_r_1:   
    rts
     nop                

    .global _exit_and_dispatch
_exit_and_dispatch:
    xor    r1,r1                 /* r7_bank10NA             */
    ldc    r1,r7_bank
dispatcher:
    /*
     * ɂ͊荞݋֎~ŗ邱
     */
    mov.l  _schedtsk_dis,r12    /* r0 <- schedtsk                   */
    mov.l  @r12,r0             
    mov.l  _runtsk_dis,r2
    mov.l  r0,@r2               /* schedtskruntsk               */
    cmp/eq #0,r0                /* schedtsk 邩H              */
    bt     dispatcher_1         /* ΃Wv                 */        
    mov.l  @(TCB_sp,r0),r15     /* TCB^XNX^bN𕜋A      */
    mov.l  @(TCB_pc,r0),r1      /* TCBsĊJԒn𕜋A        */
    jmp    @r1 
     nop
dispatcher_1:
    /* C~fBGCgl𖈉ǂݍނ̂͌̂ŎOɗpӂ
     * r8  : 荞݋֎~̂߂SR̒l   
     * r9  : 荞ݑ҂SR̒l
     * r10 : reqflg̔Ԓn
     * r11 : 0x01
     * r12 : 0x00
     * r13 : sleepSȐ       
     */
    mov.l  _mask_md_ipm_dis,r8  /* 荞݋֎~SR̒l             */
#ifdef NO_SLEEP
    mov.l  _mask_md_dis,r9      /* 荞ݑ҂SR̒l           */        
#else
    mov.l  _mask_bl_md_dis,r9   /* 荞ݑ҂SR̒l           */
#endif                          
#ifdef SUPPORT_CHG_IPM
    mov.l  _task_intmask_k,r2
    mov.l  @r2,r3
    or     r3,r9
#endif
    mov.l  _reqflg_dis,r10
    mov    #0x01,r11
    xor    r12,r12
    mov.l  _stacktop_dis,r15   /* X^bN荞݃X^bN     */
    ldc    r11,r7_bank         /* r7_bank1 1ɂĊ荞ݏԂ */        
dispatcher_2:        
    /*
     *  Ŋ݃[hɐ؂芷̂́CŔ銄ݏ
     *  ɂǂ̃X^bNgƂ̉ƁC݃nh
     *  ̃^XNfBXpb`̖h~Ƃ̈ӖD
     */
     /*
      *  ݋sleep߂sƁC݋߂̎sO
      *  ݗvĂꍇC݋߂̎sƋɊ݂
      *  󂯕tꂻ̕AɁCreqflg̃`FbNł͂Ȃ sleep 
      *  ɓĂ܂D
      *  ̖́C݂̋ sleep Ԃւ̈ڍsAg~bNɎ
      *  słȂƂɋND
      *  ̂߁Csleep sO SR ύXł BL rbg'1'ɐݒ肷
      *  邱ƂŁC݂̋ sleep Ԃւ̈ȍ~Ag~bNɎs
      *  D
      *  ldc r9,sr łBLrbgZbg邽߁C݂͎󂯕tX
      *  [v[hɈڍsDX[v[h́CBLrbg1ł
      *  ݂󂯕t邽(SH7709n[hEFA}jA 8-10)CX[
      *  v[hւ̈ڍsɊ݂tX[v[h畜AD
      */
               
    ldc    r9,sr               /* 荞݂̋                   */
#ifndef NO_SLEEP
    sleep                      /* ݑ҂                       */
#endif /* NO_SLEEP */                
    ldc    r8,sr               /* 荞݋֎~                     */  
    mov.l  @r10,r7             /* r7 <- reqflg                     */
    tst    r7,r7               /* reqflg  FALSEȂ              */
    bt     dispatcher_2        /* dispatcher_2                   */
    ldc    r12,r7_bank         /* r7_bank1 NA                */        
    mov.l  r12,@r10            /* reqflg  FALSE                */
    bra    dispatcher
     nop	
    .align 4
_runtsk_dis:	
    .long _runtsk
_schedtsk_dis:	
    .long _schedtsk
_enatex_mask_dis:    
    .long TCB_enatex_mask
_call_texrtn_dis:	
    .long _call_texrtn
_mask_md_ipm_dis:	
    .long 0x40000000 + MAX_IPM << 4
_mask_md_dis:	
    .long 0x40000000
_mask_bl_md_dis:	
    .long 0x50000000	        
dispatch_r_k:	
    .long dispatch_r
_stacktop_dis:	
    .long STACKTOP            /* ^XNƗ̃X^bN̏l	*/
_reqflg_dis:
    .long  _reqflg

/* 
 *  荞݃nh/CPUOnho
 *
 * ߂悪^XNreqflgZbgĂꍇ݂̂ɂB
 * r7_bank1 = 0,荞݋֎~,XNb`WX^ۑ
 * ԂŌĂяoƁB 
 *	
 */
    .text
    .align 2
    .globl ret_int
    .globl ret_exc
ret_exc:
ret_int:
    mov.l  _runtsk_ret,r1     /* r0 <- runtsk                  */
    mov.l  @r1,r0           
    mov.l  _enadsp_ret,r2     /* enadsp̃`FbN              */
    mov.l  @r2,r3
    tst    r3,r3           
    bt     ret_int_1           
    mov.l  _schedtsk_ret,r4   /* r5 <- schedtsk                */ 
    mov.l  @r4,r5
    cmp/eq r0,r5              /* runtsk  schedtsk r     */
    bt     ret_int_1
    mov.l  r14,@-r15          /* c̃WX^ۑ          */
    mov.l  r13,@-r15					
    mov.l  r12,@-r15					
    mov.l  r11,@-r15					
    mov.l  r10,@-r15					
    mov.l  r9,@-r15					
    mov.l  r8,@-r15
    mov    #TCB_sp,r1        /* ^XNX^bNۑ           */
    mov.l  r15,@(r0,r1)    
    mov.l  ret_int_r_k,r1    /* sĊJԒnۑ             */
    mov    #TCB_pc,r2	
    mov.l  r1,@(r0,r2)  
    bra    dispatcher
     nop
    
ret_int_r:
    mov.l  @r15+,r8		
    mov.l  @r15+,r9		
    mov.l  @r15+,r10		
    mov.l  @r15+,r11		
    mov.l  @r15+,r12		
    mov.l  @r15+,r13		
    mov.l  @r15+,r14		
ret_int_1:
    /*
     *  ^XNO[`̋N
     *  ret_int_r  dispatcher Ăяo邽߁Ctcb̃AhXr0
     *  ĂD
     *  ȂC݂̏oŃ^XNXCb`Ȃꍇ̓fBXpb`
     *  ʂ炸 ret_int 璼 ret_int_1 ɔ       
     */
    mov.l  @(TCB_enatex,r0),r1
    mov.l  _enatex_mask_ret,r2
    tst    r1,r2
    bt     ret_int_2            /* enatex  FALSE Ȃ烊^[  */
    mov.l  @(TCB_texptn,r0),r1  /* texptn[h                */
    tst    r1,r1
    bt     ret_int_2            /* texptn  0ŖT<= 0    */
    mov.l _call_texrtn_ret,r1   /* ^XNO[`̌Ăяo  */
    jsr   @r1        
     nop       
ret_int_2:               
#ifdef SUPPORT_CHG_IPM
    mov    #44,r0
    mov.l  @(r0,r15),r1
    mov.l  _unmask_ipm,r2
    and    r2,r1
    mov.l  _task_intmask_k,r2
    mov.l  @r2,r3
    or     r3,r1
    mov.l  r1,@(r0,r15)
#endif /* SUPPORT_CHG_IMP */
    mov.l  @r15+,r7            /* spc,pr,ssr,XNb`WX^𕜋A */
    mov.l  @r15+,r6        
    mov.l  @r15+,r5
    mov.l  @r15+,r4
    mov.l  @r15+,r3
    mov.l  @r15+,r2
    mov.l  @r15+,r1
    mov.l  _mask_md_bl_ret,r0
    ldc    r0,sr               /* BL1                               */
    mov.l  @r15+,r0
    lds.l  @r15+,mach                
    lds.l  @r15+,macl        
    ldc.l  @r15+,gbr       
    ldc.l  @r15+,ssr    
    lds.l  @r15+,pr
    ldc.l  @r15+,spc
    rte
     nop
        
    .align 4
_runtsk_ret:
    .long _runtsk
_schedtsk_ret:	
    .long _schedtsk
_enadsp_ret:	
    .long _enadsp
ret_int_r_k:
    .long ret_int_r
_enatex_mask_ret:    
    .long TCB_enatex_mask        
_call_texrtn_ret:	
    .long _call_texrtn
_mask_md_bl_ret:	
    .long  0x50000000

/*
 *  ^XNN
 */ 
    .text
    .align 2
    .globl _activate_r
_activate_r:
    stc    sr,r0               /* 荞݋ */
    mov.l  _unmask_ipm,r1
    and    r1,r0	
#ifdef SUPPORT_CHG_IPM
    mov.l  _task_intmask_k,r1
    mov.l  @r1,r2
    or     r2,r0
#endif /* SUPPORT_CHG_IPM */
    ldc    r0,sr
    mov.l  @r15+,r1
    lds.l  @r15+,pr
    mov.l  @r15+,r4
    jmp    @r1
     nop
    .align 4
_unmask_ipm:
    .long  0xffffff0f
#ifdef SUPPORT_CHG_IPM		
_task_intmask_k:
    .long _task_intmask
#endif /* SUPPORT_CHG_IPM */
		
		
/*
 *  Exception 600 vector
 *  荞݂ƎsB		
 *
 *
 *  SH3͊荞݂ƂׂVBR+0x600ԒnvOs邽߁A
 *  ɔzu郋[`ł܂X^bN̐؂ւAWX^̕ۑ,IPM̐ݒ,
 *  荞ݗv̔šBLrbg0ɂĊ荞݃nhĂԕKv
 *  B
 *  荞ݗvɑΉ荞݃nh̊JnԒn͔zint_table[]ɓo^
 *  ČĂяoBItZbǧvŹA荞ݗvWX^E2rbgVtg
 *  čsB荞ݗvWX^SH7708łINTEVTWX^ɃZbg邪A
 *  SH7709SH7709AłINTEVT2ɃZbg邽߁Aifdefɂ؂蕪Ă
 *  B܂Aꕔ̃fBoCXɂĊ荞ݗvWX^œnlIPM
 *  ̊Ԃɂ͊֌WȂ߁Ae荞ݗvɑΉIPMSR̓ez
 *  int_plevel_table[]ɓo^ĂǂݏoB
 *
 *  reqflg `FbNOɊ݂֎~ȂƁCreqflg `FbN
 *  ɋNꂽ݃nhŃfBXpb`vꂽꍇɁCfB
 *  Xpb`ȂD
 *
 */

    .org    0x0600        /* _BASE_VBR + 0x0600Ԓnɔzu */
    .align 2
    .global _interrupt
_interrupt:
    stc.l  spc,@-r15       /* d荞݂ƏĂ܂̂        */
    sts.l  pr,@-r15        /* spc,pr,ssr,gbr,macl,mach                    */
    stc.l  ssr,@-r15    
    stc.l  gbr,@-r15                    
    sts.l  macl,@-r15                    
    sts.l  mach,@-r15                                                    
    stc.l  r0_bank,@-r15   /* ,r0`r7X^bNɕۑ   */ 
    stc.l  r1_bank,@-r15
    stc.l  r2_bank,@-r15
    stc.l  r3_bank,@-r15
    stc.l  r4_bank,@-r15
    stc.l  r5_bank,@-r15
    stc.l  r6_bank,@-r15    
    stc.l  r7_bank,@-r15
    tst    r7,r7                 /* 荞ݔ̃ReLXg𔻒  */  
    bf/s    _interrupt_from_int  /* O/荞݃nhȂWv   */
     add    #0x01,r7             /* 荞݂̃lXg񐔂CNg*/
    mov    r15,r1                /* X^bNւ̃X^bN|C  */
    mov.l  _stacktop_k,r15       /* ^ۑ                          */
    mov.l  r1,@-r15            
    mov.l  _intevt,r0            /* OvWX^擾              */
    mov.l  @r0,r4              
    shlr2  r4                    /* 3rbgEVtgItZbg߂ */
    shlr   r4                  
    mov.l  _int_plevel_table_k,r0 
    mov.l  @(r0,r4),r5           /* 荞݂̗Dx擾               */
    mov.l  _int_table_k,r0    
    mov.l  @(r0,r4),r2           /* 荞݃nh̃AhX擾    */
    ldc    r2,r2_bank            /* oN0ɐ؂ւ邽߃Rs[       */    
    ldc    r5,sr                 /* ȍ~荞݂󂯕tB      */
    jsr    @r2                   /* 荞݃nh                  */
     nop
    mov.l  _mask_md_ipm_ret,r0
    ldc    r0,sr                 /* 荞݋֎~                           */
    stc    r7_bank,r7            /* O/荞݂̃lXg񐔂fNg*/
    dt     r7
    ldc    r7,r7_bank
    mov.l  _reqflg_k,r4          /* reqflg̃`FbN                       */
    mov.l  @r4,r1
    tst    r1,r1                 /* reqflgFALSEȂret_to_task_intɔ */
    bt/s   _ret_to_task_int      /* ^XNɖ߂                           */
     mov.l  @r15,r15             /* ߂悪^XNȂ̂ŃX^bN߂     */
    xor    r0,r0
    bra    ret_int
     mov.l  r0,@r4               /* reqflgNA                   */
_interrupt_from_int:
    mov.l   _intevt,r0           /* OvWX^擾           */
    mov.l   @r0,r4
    shlr2   r4                   /* ItZbg߂               */
    shlr    r4                   /* ItZbg߂               */    
    mov.l   _int_plevel_table_k,r0 
    mov.l   @(r0,r4),r5            /* 荞݂̗Dx擾           */
    mov.l   _int_table_k,r0        
    mov.l   @(r0,r4),r2            /* 荞݃nh̃AhX擾 */
    ldc     r2,r2_bank             /* oN0ɐ؂ւ邽߃Rs[    */
    ldc     r5,sr                  /* ȍ~荞݂󂯕tB   */
    jsr     @r2                    /* 荞݃nh               */ 
     nop
    mov.l  _mask_md_ipm_ret,r0
    ldc    r0,sr                   /* 荞݋֎~                     */
    stc    r7_bank,r7              /* O/荞݂̃lXg񐔂fNg*/
    dt     r7
    ldc    r7,r7_bank
_ret_to_task_int:
    mov.l  @r15+,r7                /* 荞݌ɖ߂                 */
    mov.l  @r15+,r6
    mov.l  @r15+,r5
    mov.l  @r15+,r4
    mov.l  @r15+,r3
    mov.l  @r15+,r2
    mov.l  @r15+,r1
    mov.l  _mask_md_bl_int,r0 
    ldc    r0,sr                   /* BL 1                         */
    mov.l  @r15+,r0
    lds.l  @r15+,mach                
    lds.l  @r15+,macl        
    ldc.l  @r15+,gbr                       
    ldc.l  @r15+,ssr
    lds.l  @r15+,pr
    ldc.l  @r15+,spc
    rte
     nop

    /*
     * o^݂̊ƁC̎ INTEVT,INTEVT2,SR,PC 
     * cpu_interrupt()ĂяoD
     */   
    .global _no_reg_interrupt
_no_reg_interrupt:
    mov.l _intevt1,r0
    mov.l @r0,r4
#if defined(SH7709) || defined(SH7709A) || defined(SH7729R) || defined(SH7727) 
    mov.l _intevt2,r0    
    mov.l @r0,r5
#endif 
    stc   spc,r6
    stc   ssr,r7
    mov.l _cpu_interrupt_k,r1
    jsr   @r1
     nop

        
    .align  4
_stacktop_k:    
    .long  STACKTOP            /* ^XNƗ̃X^bN̏l  */
_intevt:        
#if defined(SH7708) || defined(SH7750)    
    .long  INTEVT
#else
    .long  INTEVT2
#endif    
_int_table_k:    
    .long    _int_table       
_int_plevel_table_k:    
    .long    _int_plevel_table 
_reqflg_k:
    .long  _reqflg
_mask_md_ipm_ret:    
    .long  0x40000000 + MAX_IPM << 4
_mask_md_bl_int:    
    .long  0x50000000
_intevt1:        
    .long  INTEVT
#if defined(SH7709) || defined(SH7709A) || defined(SH7729R) || defined(SH7727) 
_intevt2:        
    .long  INTEVT2
#endif 
_cpu_interrupt_k:
    .long  _cpu_interrupt   

    
/*
 *  ԑ҂
 */
	.globl _sil_dly_nse
_sil_dly_nse:
    mov.l  _sil_dly_tim1, r1
    add    r1, r4
    cmp/pl r4
    bt     _sil_dly_nse1
    rts
     nop
_sil_dly_nse1:            
    mov.l  _sil_dly_tim2, r1
    add    r1, r4
    cmp/pl r4
    bt     _sil_dly_nse1
    rts
     nop   
    .align 4
_sil_dly_tim1:
    .long  -SIL_DLY_TIM1    
_sil_dly_tim2:                         
    .long  -SIL_DLY_TIM2
