
/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                                  Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sh4.h,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

/*
 *  SH4(SH7750)̓WX^`
 */

#ifndef _SH4_H_
#define _SH4_H_

/*
 *  OCxgWX^
 */
#define TRA	        0xff000020
#define EXPEVT	    0xff000024
#define INTEVT	    0xff000028


/*
 *   oXXe[gRg[֘A
 */
#define	RFCR	    0xff800028   /* H */

#define RFCR_CLEAR  0xa400

/*
 * 荞݂ɂ INTEVT WX^ɐݒ肳l
 */
#define    TMU0_INTEVT        0x400
#define    SCI_RXI_INTEVT     0x500
#define    SCI_TXI_INTEVT     0x520
#define    SCI_ERI_INTEVT     0x4e0
#define    SCIF_RXI_INTEVT    0x720
#define    SCIF_TXI_INTEVT    0x760
#define    SCIF_BRI_INTEVT    0x740


        
/*
 * ݃Rg[WX^
 */
#define	ICR   0xffd00000    /* H */
#define	IPRA  0xffd00004    /* H */
#define	IPRB  0xffd00008    /* H */
#define	IPRC  0xffd0000c    /* H */
#define	IPRD  0xffd00010    /* H */


/*
 * ^C}[WX^
 */
#define TMU_TOCR   0xffd80000  /* B */
#define TMU_TSTR   0xffd80004  /* B */
#define TMU_TCOR0  0xffd80008  /* W */
#define TMU_TCNT0  0xffd8000c  /* W */
#define TMU_TCR0   0xffd80010  /* H */
#define TMU_TCOR1  0xffd80014  /* W */
#define TMU_TCNT1  0xffd80018  /* W */
#define TMU_TCR1   0xffd8001c  /* H */
#define TMU_TCOR2  0xffd80020  /* W */
#define TMU_TCNT2  0xffd80024  /* W */
#define TMU_TCR2   0xffd80028  /* H */

#define	TMU_STR0	0x01
#define	TMU_STR1	0x02
#define	TMU_STR2	0x04
#define TCR_UNF     0x0100    

/*
 *
 *  VAR~jP[VC^[tF[X(SCI)
 *
 */
#define SCI_SCSMR1  0xffe00000    /* B */
#define SCI_SCBRR1  0xffe00004    /* B */
#define SCI_SCSCR1  0xffe00008    /* B */
#define SCI_SCTDR1  0xffe0000c    /* B */
#define SCI_SCSSR1  0xffe00010    /* B */
#define SCI_SCRDR1  0xffe00014    /* B */
#define SCI_SCSPTR1 0xffe0001c    /* B */


#define	SCSMR_CHR	  0x0040
#define	SCSMR_PE	  0x0020
#define	SCSMR_OE	  0x0010
#define	SCSMR_STOP	  0x0008
#define	SCSMR_CKS1	  0x0002
#define	SCSMR_CKS0	  0x0001

#define SCSCR_TIE	  0x0080
#define SCSCR_RIE	  0x0040
#define SCSCR_TE	  0x0020
#define SCSCR_RE	  0x0010
#define SCSCR_CKE1	  0x0002
#define SCSCR_CKE0	  0x0001

#define SCSSR_TDRE	  0x80
#define SCSSR_RDRF	  0x40
#define SCSSR_ORER	  0x20
#define SCSSR_FER	  0x10
#define SCSSR_PER	  0x08
#define SCSSR_TEND	  0x04
#define SCSSR_MPB	  0x02
#define SCSSR_MPBT	  0x01

/*
 *
 *  FIFOtVAR~jP[VC^[tF[X(SCIF)WX^
 *
 */
#define SCIF_SCSMR2    0xffe80000   /* H */
#define SCIF_SCBRR2    0xffe80004   /* B */
#define SCIF_SCSCR2    0xffe80008   /* H */
#define SCIF_SCFTDR2   0xffe8000c   /* B */
#define SCIF_SCFSR2    0xffe80010   /* H */
#define SCIF_SCFRDR2   0xffe80014   /* B */
#define SCIF_SCFCR2    0xffe80018   /* H */
#define SCIF_SCFDR2    0xffe8001c   /* H */
#define	SCIF_SCSPTR2   0xffe80020   /* H */
#define	SCIF_SCLSR2	   0xffe80024   /* H */

#define	SCSMR2_CHR	  0x0040
#define	SCSMR2_PE	  0x0020
#define	SCSMR2_OE	  0x0010
#define	SCSMR2_STOP	  0x0008
#define	SCSMR2_CKS1	  0x0002
#define	SCSMR2_CKS0	  0x0001

#define SCSCR2_TIE	  0x0080
#define SCSCR2_RIE	  0x0040
#define SCSCR2_TE	  0x0020
#define SCSCR2_RE	  0x0010
#define SCSCR2_CKE1	  0x0002
#define SCSCR2_CKE0	  0x0001

#define SCFSR2_ER	  0x0080
#define SCFSR2_TEND	  0x0040
#define SCFSR2_TDFE	  0x0020
#define SCFSR2_BRK	  0x0010
#define SCFSR2_FER	  0x0008
#define SCFSR2_PER	  0x0004
#define SCFSR2_RDF	  0x0002
#define SCFSR2_DR	  0x0001

#define SCFCR2_RTRG1  0x0080
#define SCFCR2_RTRG0  0x0040
#define SCFCR2_TTRG1  0x0020
#define SCFCR2_TTRG0  0x0010
#define SCFCR2_MCE	  0x0008
#define SCFCR2_TFRST  0x0004
#define SCFCR2_RFRST  0x0002
#define SCFCR2_LOOP	  0x0001

#define SCSPTR2_RTSIO  0x0080
#define SCSPTR2_RTSDT  0x0040
#define SCSPTR2_CTSIO  0x0020
#define SCSPTR2_CTSDT  0x0010
#define SCSPTR2_SPB2IO 0x0002
#define SCSPTR2_SPB2DT 0x0001


/*
 * LbV䃌WX^
 */
#define	CCR	0xff00001c   /* W */
#define CCR_DISABLE   0x00000808  /* LbV */


#endif /* _SH4_H_ */






