/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2006 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: uart.c,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

/*
 *  񓯊ʐM (UART)VA`lfoCXiSIOjhCo
 *  iZup-F16g{[hpj
 */
#include <s_services.h>
#include <sil.h>
#include <tmp91cy22.h>
#include <uart.h>

/*
 *  VAI/O䃌WX^ւ̃ItZbg`
 */
#define		TOFFSET_SC0BUF			0x0000
#define		TOFFSET_SC0CR			0x0001
#define		TOFFSET_SC0MOD0			0x0002
#define		TOFFSET_BR0CR			0x0003
#define		TOFFSET_BR0ADD			0x0004
#define		TOFFSET_SC0MOD1			0x0005
 
/*
 *  VAI/O|[gԃtO̒`
 */
#define		TBIT_STS_DEF			0x00
#define		TBIT_TXB_EMPTY			0x01
#define		TBIT_ENE_TXCBR			0x02
#define		TBIT_ENE_RXCBR			0x04
#define		TBIT_LOG_PORT			0x80

/*
 *  VAI/O|[gubN
 *
 *  ID = 1 uart1CID = 2 uart0ɑΉĂD
 */
static const SIOPINIB siopinib_table[TNUM_PORT] = {
	{ TADR_SFR_SC1BUF, TADR_SFR_INTES1, 0x08, (TBIT_SIOSMU8 | TBIT_SIORXE | TBIT_SIOSCBRG),
	  0x00, BRCR_19200, BRADD_19200, TBIT_RX1_CLR }	/* ID1p UART1 19200bps	*/
/*	{ TADR_SFR_SC1BUF, TADR_SFR_INTES1, 0x08, (TBIT_SIOSMU8 | TBIT_SIORXE | TBIT_SIOSCBRG),
	  0x00, BRCR_38400, BRADD_38400, TBIT_RX1_CLR }*/	/* ID1p UART1 38400bps	*/
/*	{ TADR_SFR_SC0BUF, TADR_SFR_INTES0, 0x01, (TBIT_SIOSMU8 | TBIT_SIORXE | TBIT_SIOSCBRG),
	  0x00, BRCR_19200, BRADD_19200, TBIT_RX0_CLR }*/	/* ID2p UART0 19200bps	*/
};

/*
 *  VAI/O|[gǗubÑGA
 */
static SIOPCB siopcb_table[TNUM_PORT];

/*
 *  VAI/O|[gIDǗubNo߂̃}N
 */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  SIOhCȍ[`
 */
void
uart_initialize()
{
	SIOPCB	*siopcb;
	UINT	i;

	/*
	 *  VAI/O|[gǗubN̏
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_PORT; siopcb++, i++) {
		siopcb->siopinib = &(siopinib_table[i]);
		siopcb->sts_flag = TBIT_STS_DEF;
		siopcb->rxb = -1;
	}
}

/*
 *  VAI/O|[g̃I[v
 */
SIOPCB *
uart_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB		*siopcb;
	const SIOPINIB	*siopinib;
	int i;

	/* |[gIDǗubN擾	*/
	siopcb = get_siopcb(siopid);
	siopinib = siopcb->siopinib;

	/* ǗubNɏݒ	*/
	siopcb->sts_flag |= TBIT_TXB_EMPTY;
	siopcb->exinf = exinf;
	if( siopid == LOGTASK_PORTID ){	/* VXeOp̃|[g̏ꍇ	*/
		siopcb->sts_flag |= TBIT_LOG_PORT;
		if( log_io_busy == TRUE ){
			/* M̏ꍇ͊܂ő҂	*/
			while( (sil_reb_mem((VP)(siopinib->hint)) & TBIT_INTC_H) == 0 );
		}
		log_io_busy = FALSE;	/* Ȃ̂ŖIɍsĂ   */
	}

	/* M~	*/
	sil_wrb_mem((VP)(siopinib->cntrl+TOFFSET_SC0MOD0), 0x00 );
	/* |[gݒ(TXDƂĎgp)	*/
	sil_wrb_mem((VP)(TADR_SFR_P9FC), siopinib->pcrfc_def );
	sil_wrb_mem((VP)(TADR_SFR_P9CR), siopinib->pcrfc_def );

	/* 샂[hݒ	*/
	sil_wrb_mem((VP)(siopinib->cntrl+TOFFSET_SC0MOD0), siopinib->scmod0_def );
	sil_reb_mem((VP)(siopinib->cntrl+TOFFSET_SC0CR));	/* ǏoɂG[tONA	*/
	sil_wrb_mem((VP)(siopinib->cntrl+TOFFSET_SC0CR), siopinib->sccr_def );
	sil_wrb_mem((VP)(siopinib->cntrl+TOFFSET_BR0CR), siopinib->brcr_def);
	sil_wrb_mem((VP)(siopinib->cntrl+TOFFSET_BR0ADD), siopinib->bradd_def);
	sil_wrb_mem((VP)(siopinib->cntrl+TOFFSET_SC0MOD1), TBIT_SIOI2S);

	/* VA݂̐ݒ肨їvtONA	 */
	sil_wrb_mem((VP)TADR_SFR_INTCLR, (siopinib->int_clr) );		/* MvNA	*/
	sil_wrb_mem((VP)TADR_SFR_INTCLR, (VB)(siopinib->int_clr + 1) );	/* MvNA	*/
	sil_wrb_mem((VP)(siopinib->hint), (VB)((INT_LEVEL_UART << 4) | INT_LEVEL_UART) );

	/*
	 * _~[f[^M
	 */
	sil_reb_mem((VP)(siopinib->cntrl+TOFFSET_SC0BUF));
	sil_reb_mem((VP)(siopinib->cntrl+TOFFSET_SC0BUF));

	return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void
uart_cls_por(SIOPCB *siopcb)
{
	const SIOPINIB	*siopinib;

	siopinib = siopcb->siopinib;

	/* M~	*/
	sil_wrb_mem((VP)(siopinib->cntrl+TOFFSET_SC0MOD0), 0x00 );

	/* VXeOp|[g̏	*/
	if( (siopcb->sts_flag & TBIT_LOG_PORT) == TBIT_LOG_PORT ){
		if( log_io_busy == TRUE ){
			/* M̏ꍇ͊܂ő҂	*/
			while( (sil_reb_mem((VP)(TADR_SFR_INTES0)) & TBIT_INTC_H) == 0 );
		}
		log_io_busy = FALSE;
	}

	/* VA݂̋֎~їvtONA	 */
	sil_wrb_mem((VP)(siopinib->hint), 0x00 );
	sil_wrb_mem((VP)TADR_SFR_INTCLR, (siopinib->int_clr) );		/* MvNA	*/
	sil_wrb_mem((VP)TADR_SFR_INTCLR, (VB)(siopinib->int_clr + 1) );	/* MvNA	*/
	/* |[gݒ(|[gƂĎgp)	*/
	sil_wrb_mem((VP)(TADR_SFR_P9FC), 0x00 );
	sil_wrb_mem((VP)(TADR_SFR_P9CR), 0x00 );

	siopcb->sts_flag = TBIT_STS_DEF;
}

/*
 *  VAI/O|[gւ̕M
 */
BOOL
uart_snd_chr(SIOPCB *siopcb, char c)
{
	if( (siopcb->sts_flag & TBIT_TXB_EMPTY) == TBIT_TXB_EMPTY ){
		siopcb->sts_flag &= (UB)~TBIT_TXB_EMPTY;
		sil_wrb_mem((VP)(siopcb->siopinib->cntrl+TOFFSET_SC0BUF), c);

	/* VXeOp|[g̏	*/
		if( (siopcb->sts_flag & TBIT_LOG_PORT) == TBIT_LOG_PORT ){
			log_io_busy = TRUE;	/* M	*/
		}
		return(TRUE);
	}
	return(FALSE);
}

/*
 *  VAI/O|[g̕M
 */
INT
uart_rcv_chr(SIOPCB *siopcb)
{
	return(siopcb->rxb);
}

/*
 *  VAI/O|[g̃R[obN̋
 */
void
uart_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case UART_ERDY_SND:
		siopcb->sts_flag |= TBIT_ENE_TXCBR;
		break;
	case UART_ERDY_RCV:
		siopcb->sts_flag |= TBIT_ENE_RXCBR;
		break;
	default:
		break;
	}
}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
uart_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case UART_ERDY_SND:
		siopcb->sts_flag &= (UB)~TBIT_ENE_TXCBR;
		break;
	case UART_ERDY_RCV:
		siopcb->sts_flag &= (UB)~TBIT_ENE_RXCBR;
		break;
	default:
		break;
	}
}

/*
 *  |[gID=1Ɏw肳ĂSIO`l(uart1)̎M
 */
void serial_in_handler1()
{
	SIOPCB *siopcb = &siopcb_table[0];

	/* G[̏ꍇȂ   */
	if( ( sil_reb_mem((VP)(siopcb->siopinib->cntrl+TOFFSET_SC0CR)) & 0x1c ) == 0 ){

		/* f[^M	*/
		siopcb->rxb = (INT)sil_reb_mem((VP)(siopcb->siopinib->cntrl+TOFFSET_SC0BUF));

		/* R[obNĂꍇ	*/
		if( (siopcb->sts_flag & TBIT_ENE_RXCBR) == TBIT_ENE_RXCBR ){
			/*
			 *  MʒmR[obN[`ĂяoD
			 */
			uart_ierdy_rcv(siopcb->exinf);
		}
	}
}

/*
 *  |[gID=1Ɏw肳ĂSIO`l(uart1)̑M
 */
void serial_out_handler1()
{
	SIOPCB *siopcb = &siopcb_table[0];

	/* f[^MtOON	*/
	siopcb->sts_flag |= TBIT_TXB_EMPTY;

	/* VXeOp|[g̏	*/
	if( (siopcb->sts_flag & TBIT_LOG_PORT) == TBIT_LOG_PORT ){
		log_io_busy = FALSE;	/* M	*/
	}

	/* R[obNĂꍇ	*/
	if( (siopcb->sts_flag & TBIT_ENE_TXCBR) == TBIT_ENE_TXCBR ){
		/*
		 *  M\R[obN[`ĂяoD
		 */
		uart_ierdy_snd(siopcb->exinf);
	}
}

#if TNUM_PORT >= 2
/*
 *  |[gID=2Ɏw肳ĂSIO`l(uart0)̎M
 */
void serial_in_handler2()
{
	SIOPCB *siopcb = &siopcb_table[1];

	/* G[̏ꍇȂ   */
	if( ( sil_reb_mem((VP)(siopcb->siopinib->cntrl+TOFFSET_SC0CR)) & 0x1c ) == 0 ){

		/* f[^M	*/
		siopcb->rxb = (INT)sil_reb_mem((VP)(siopcb->siopinib->cntrl+TOFFSET_SC0BUF));

		/* R[obNĂꍇ	*/
		if( (siopcb->sts_flag & TBIT_ENE_RXCBR) == TBIT_ENE_RXCBR ){
			/*
			 *  MʒmR[obN[`ĂяoD
			 */
			uart_ierdy_rcv(siopcb->exinf);
		}
	}
}

/*
 *  |[gID=2Ɏw肳ĂSIO`l(uart0)̑M
 */
void serial_out_handler2()
{
	SIOPCB *siopcb = &siopcb_table[1];

	/* f[^MtOON	*/
	siopcb->sts_flag |= TBIT_TXB_EMPTY;

	/* VXeOp|[g̏	*/
	if( (siopcb->sts_flag & TBIT_LOG_PORT) == TBIT_LOG_PORT ){
		log_io_busy = FALSE;	/* M	*/
	}

	/* R[obNĂꍇ	*/
	if( (siopcb->sts_flag & TBIT_ENE_TXCBR) == TBIT_ENE_TXCBR ){
		/*
		 *  M\R[obN[`ĂяoD
		 */
		uart_ierdy_snd(siopcb->exinf);
	}
}

#endif

