/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2006 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: uart.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

/*
 *  񓯊ʐM (UART)VA`lfoCXiSIOjhCo
 *  iZup-F16g{[hpj
 */

#ifndef _UART_H_
#define _UART_H_

/*
 * VARg[WX^̐ݒl 
 */
/* 19200bps = (6144000*4)/4/(BRCK)/(BRS+(16-BRK)/16)/16	*/
/* BRCK=4,BRS=5JEg,+(16-BRK)/16 ͖gp */
#define	BRCR_19200  	(TBIT_SIOBRCK2 | 5)
#define	BRADD_19200		0
/* 38400bps = (6144000*4)/4/(BRCK)/(BRS+(16-BRK)/16)/16	*/
/* BRCK=1,BRS=10JEg,+(16-BRK)/16 ͖gp */
#define	BRCR_38400		(TBIT_SIOBRCK0 | 10)
#define	BRADD_38400		0
#define	INT_LEVEL_UART	5		/* ݃x */

/*
 *  VAI/O̊݃nh̃xN^ԍ
 */
#define	INHNO_SERIAL_IN1	INT_NO_RX1
#define	INHNO_SERIAL_OUT1	INT_NO_TX1
#define INHNO_SERIAL_IN2	INT_NO_RX0
#define INHNO_SERIAL_OUT2	INT_NO_TX0

#ifndef _MACRO_ONLY

/*
 *  VAI/O|[gubN̒`
 */
typedef struct sio_port_initialization_block {
	UH  cntrl;		/* Rg[WX^̔Ԓn */
	UH  hint;		/* ݃WX^̔Ԓn */

	UB  pcrfc_def;		/* ftH[g̐ݒl (P9CR/P9FC) */
	UB  scmod0_def;		/* ftH[g̐ݒl (SCMOD0)	*/
	UB  sccr_def;		/* ftH[g̐ݒl (SCCR)		*/
	UB  brcr_def;		/* ftH[g̐ݒl (BRCR)		*/
	UB  bradd_def;		/* ftH[g̐ݒl (BRADD)		*/
	UB  int_clr;		/* ݗvtONAR}h	*/
} SIOPINIB;

/*
 *  VAI/O|[gǗubN̒`
 */
typedef struct sio_port_control_block {
	const SIOPINIB	*siopinib;	/* VAI/O|[gubN */
	VP_INT			exinf;		/* g */
	INT				rxb;		/* Mobt@	*/
	volatile UB		sts_flag;	/* Mobt@tO	*/
} SIOPCB;

/*
 *  R[obN[`̎ʔԍ
 */
#define UART_ERDY_SND		1u			/* M\R[obN			*/
#define UART_ERDY_RCV		2u			/* MʒmR[obN			*/

/*
 *  SIOhCȍ[`
 */
extern void	uart_initialize(void);

/*
 *  VAI/O|[g̃I[v
 */
extern SIOPCB * uart_opn_por(ID siopid, VP_INT exinf);

/*
 *  VAI/O|[g̃N[Y
 */
extern void	uart_cls_por(SIOPCB *siopcb);

/*
 *  VAI/O|[gւ̕M
 */
extern BOOL	uart_snd_chr(SIOPCB *siopcb, char c);

/*
 *  VAI/O|[g̕M
 */
extern INT	uart_rcv_chr(SIOPCB *siopcb);

/*
 *  VAI/O|[g̃R[obN̋
 */
extern void	uart_ena_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
extern void	uart_dis_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  VAI/O|[g̑M\R[obN
 */
extern void	uart_ierdy_snd(VP_INT exinf);

/*
 *  VAI/O|[g̎MʒmR[obN
 */
extern void	uart_ierdy_rcv(VP_INT exinf);

#endif /* _MACRO_ONLY */
#endif /* _UART_H_ */

