/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: tinet_cpu_config.h,v 1.1 2008/06/17 00:04:50 suikan Exp $
 */

#ifndef _TINET_CPU_CONFIG_H_
#define _TINET_CPU_CONFIG_H_

/*
 *  TCP/IP Ɋւ`
 */

/* TCP Ɋւ` */

/*
 *  MAX_TCP_RCV_SEG: MZOgTCY̍ől
 *
 *    : ύXׂł͂ȂB
 */

#define MAX_TCP_RCV_SEG		(IF_MTU - (IP_HDR_SIZE + TCP_HDR_SIZE))

/*
 *  MAX_TCP_SND_SEG: MZOgTCY̍ől
 *
 *    肩 MSS IvVŃZOgTCYw肳ĂA
 *    ̒lŁAZOgTCY𐧌łB
 */

#ifdef SUPPORT_PPP

#define MAX_TCP_SND_SEG		(256 - ((IF_IP_TCP_HDR_SIZE + 3) >> 2 << 2))
/*#define MAX_TCP_SND_SEG		(IF_MTU - (IP_HDR_SIZE + TCP_HDR_SIZE))*/
/*#define MAX_TCP_SND_SEG		TCP_MSS*/

#endif	/* of #ifdef SUPPORT_PPP */

#ifdef SUPPORT_ETHER

/*#define MAX_TCP_SND_SEG		(1024 - ((IF_IP_TCP_HDR_SIZE + 3) >> 2 << 2))*/
#define MAX_TCP_SND_SEG		(IF_MTU - (IP_HDR_SIZE + TCP_HDR_SIZE))
/*#define MAX_TCP_SND_SEG		TCP_MSS*/

#endif	/* of #ifdef SUPPORT_ETHER */

#ifdef SUPPORT_LOOP

#define MAX_TCP_SND_SEG		(IF_MTU - (IP_HDR_SIZE + TCP_HDR_SIZE))

#endif	/* of #ifdef SUPPORT_LOOP */

/*
 *  DEF_TCP_SND_SEG: MZOgTCY̋Kl
 *  DEF_TCP_RCV_SEG: MZOgTCY̋Kl
 */

#ifdef SUPPORT_PPP

#define DEF_TCP_SND_SEG		MAX_TCP_SND_SEG

#define DEF_TCP_RCV_SEG		(256 - ((IF_IP_TCP_HDR_SIZE + 3) >> 2 << 2))
/*#define DEF_TCP_RCV_SEG		MAX_TCP_RCV_SEG*/

#endif	/* of #ifdef SUPPORT_PPP */

#ifdef SUPPORT_ETHER

#define DEF_TCP_SND_SEG		MAX_TCP_SND_SEG

/*#define DEF_TCP_RCV_SEG		(1024 - ((IF_IP_TCP_HDR_SIZE + 3) >> 2 << 2))*/
#define DEF_TCP_RCV_SEG		(IF_MTU - (IP_HDR_SIZE + TCP_HDR_SIZE))
/*#define DEF_TCP_RCV_SEG		TCP_MSS*/

#endif	/* of #ifdef SUPPORT_ETHER */

#ifdef SUPPORT_LOOP

#define DEF_TCP_SND_SEG		MAX_TCP_SND_SEG
#define DEF_TCP_RCV_SEG		(IF_MTU - (IP_HDR_SIZE + TCP_HDR_SIZE))

#endif	/* of #ifdef SUPPORT_LOOP */

/* 
 *  ZOg̏ԂւƂɐVɃlbg[Nobt@ĂāA
 *  f[^Rs[TCŶl
 */
#define MAX_TCP_REALLOC_SIZE	1024	

#define TMO_TCP_GET_NET_BUF	1000	/* [ms]Anet_buf l^CAEg		*/
#define TMO_TCP_OUTPUT		1000	/* [ms]ATCP o̓^CAEg			*/

#define TCP_CFG_OPT_MSS		/* RlNVJݎɁAZOgTCYIvVđMB*/
#define TCP_CFG_DELAY_ACK	/* ACK x点Ƃ̓RgOB			*/
#define TCP_CFG_ALWAYS_KEEP	/* ɃL[vACu鎞̓RgOB		*/

/*
 *  o̓^XN
 */

#define	TCP_OUT_TASK_STACK_SIZE	1024	/* TCP o̓^XÑX^bNTCY		*/
#define TCP_OUT_TASK_PRIORITY	5	/* TCP o̓^XN̗Dx			*/

/* UDP Ɋւ` */

					/* UDP ML[TCY				*/
#define NUM_DTQ_UDP_RCVQ	(NUM_MPF_NET_BUF_IF_PDU-1)	/* R[obNp	*/
#define NUM_DTQ_UDP_CB_RCVQ	(NUM_DTQ_UDP_RCVQ+1)		/* R[obNp	*/

#define TMO_UDP_OUTPUT	10000		/* [ms]AUDP o̓^CAEg			*/

#define UDP_CFG_IN_CHECKSUM	/* UDP ̓̓`FbNTsꍇ̓RgOB	*/
#define UDP_CFG_OUT_CHECKSUM	/* UDP ̏o̓`FbNTsꍇ̓RgOB	*/

/*
 *  mubLOR[sꍇɑgݍރ^XNƃf[^L[
 */

#define NUM_DTQ_UDP_OUTPUT	1	/* UDP o̓f[^L[TCY			*/
#define	UDP_OUT_TASK_STACK_SIZE	1024	/* UDP o̓^XÑX^bNTCY			*/
#define UDP_OUT_TASK_PRIORITY	5	/* UDP o̓^XN̗Dx				*/

/* ICMPv4/v6 Ɋւ` */

#define ICMP_REPLY_ERROR		/* ICMP G[bZ[W𑗐Mꍇ̓RgOB*/

#define TMO_ICMP_OUTPUT		1000	/* [ms]AICMP o̓obt@l^CAEg	*/

/* IPv4/IPv6 ʒ` */

#define TMO_IN_REDIRECT	(10*60*1000)	/* [ms]A[eBOGg^CAEg	*/

/* IPv4 Ɋւ` */

/*#define IP4_CFG_FRAGMENT		 f[^O̕Eč\sꍇ̓RgOB*/
#define NUM_IP4_FRAG_QUEUE	2	/* f[^Oč\L[TCY			*/
#define TMO_IP4_FRAG_GET_NET_BUF	1000	/* [ms]Anet_buf l^CAEg		*/

/* IPv6 Ɋւ` */

#ifdef SUPPORT_ETHER

#define IP6_CFG_AUTO_LINKLOCAL		/* N[JAhX̎ݒsꍇ̓RgOB*/

#endif	/* of #ifdef SUPPORT_ETHER */

#define NUM_IP6_DAD_COUNT	1	/* dAhXoőMߗחv̉񐔁A		*/
					/*  0 w肷ƁAdAhXosȂB	*/
#define NUM_ND6_CACHE_ENTRY	10	/* ߗ׃LbṼGg			*/

#ifdef SUPPORT_ETHER

/*
 *  fBtHg[^Xg̃GgB
 *  0 w肷ƃ[^ʒmMȂB
 */
#define NUM_ND6_DEF_RTR_ENTRY	2

/*
 *  Ñ[^vo͉񐔁B
 *  0 w肷ƃ[^vo͂ȂB
 */
#define NUM_ND6_RTR_SOL_RETRY	3	

#endif	/* of #ifdef SUPPORT_ETHER */

#define TMO_ND6_NS_OUTPUT	1000	/* [ms]Aߗחvo̓^CAEg		*/
#define TMO_ND6_NA_OUTPUT	1000	/* [ms]Aߗגʒmo̓^CAEg		*/
#define TMO_ND6_RS_OUTPUT	1000	/* [ms]A[^vo̓^CAEg		*/
#define TMO_ND6_RTR_SOL_DELAY	1000	/* [ms]A[^vo͒x			*/
#define TMO_ND6_RTR_SOL_INTERVAL	\
				3000	/* [ms]A[^vo͊Ԋu			*/

/*
 *  f[^Nw (lbg[NC^tF[X) Ɋւ`
 */

/*
 *  PPP Ɋւ`
 */

#define NUM_DTQ_PPP_OUTPUT	2	/* PPP o̓f[^L[TCYA2 ȏ	*/

#define	PPP_INPUT_STACK_SIZE	1024	/* PPP ^XÑX^bNTCY		*/
#define	PPP_OUTPUT_STACK_SIZE	1024	/* PPP o̓^XÑX^bNTCY		*/

#define PPP_INPUT_PRIORITY	5	/* PPP ^XN̗Dx			*/
#define PPP_OUTPUT_PRIORITY	5	/* PPP ^XN̗Dx			*/

#define TMO_PPP_GET_NET_BUF	1000	/* [ms]AMp net_buf l^CAEg	*/

/*
 *  PPPAfɊւ`
 */

#define MODEM_CFG_DIAL		"ATD"	/* _CAR}h			*/
#define MODEM_CFG_RETRY_CNT	3	/* _CAgC			*/
#define MODEM_CFG_RETRY_WAIT	10000	/* _CAgC܂ł̑҂ [ms]	*/

/*
 *  PPPAHDLC Ɋւ`
 */

#define DEF_LOCAL_ACCM		0x000a0000	/*  ACCMAXON  XOFF ̂ݕϊ	*/
#define DEF_REMOTE_ACCM		0xffffffff	/*  ACCMAl͑Sĕϊ		*/

/*
 *  PPPALCP Ɋւ`
 */

#define LCP_CFG_MRU		0x0001	/* MRU					*/
#define LCP_CFG_ACCM		0x0002	/* ACCM					*/
#define LCP_CFG_MAGIC		0x0004	/* }WbNԍ				*/
#define LCP_CFG_PCOMP		0x0008	/* vgRk@\			*/
#define LCP_CFG_ACCOMP		0x0010	/* AhXE䕔k			*/
#define LCP_CFG_PAP		0x0020	/* PAP					*/
/*#define LCP_CFG_CHAP		0x0040	   CHAP ͎\			*/

#ifdef LCP_CFG_MAGIC

#define LCP_ECHO_INTERVAL	(20*NET_TIMER_HZ)	/* C^[o		*/
#define LCP_ECHO_FAILS		9			/* s臒l			*/

#endif	/* of #ifdef LCP_CFG_MAGIC */

/*
 *  PPPAPAP Ɋւ`
 */

#define DEF_PAP_TIMEOUT		(3*NET_TIMER_HZ)
#define DEF_PAP_REQTIME		(30*NET_TIMER_HZ)	/* ^CAEgsƂ̓RgOB*/
#define MAX_PAP_REXMT		10			/* Fؗv̍őđ	*/

/*
 *  ARP Ɋւ`
 */

#define NUM_ARP_ENTRY		10			/* ARP LbVGg	*/
#define ARP_CACHE_KEEP		(20*60*NET_TIMER_HZ)	/* ARP LbṼ^CAEg	*/
#define TMO_ARP_GET_NET_BUF	1000	/* [ms]AAhXvp net_buf l^CAEg*/
#define TMO_ARP_OUTPUT		1000	/* [ms]AAhXvo̓^CAEg	*/

/*
 *  DHCP Ɋւ`
 *
 *    E: TINET ́ADHCP ĂȂBpvOŁA
 *            DHCP bZ[WM邽߂̒`łB
 *            ܂A݂ IPv4 ̂ݗLłB
 */

/*#define DHCP_CFG					 DHCP ꍇ̓RgOB*/

/*
 *  Ethernet Ɋւ`
 */

#define NUM_DTQ_ETHER_OUTPUT	2	/* Ethernet o̓f[^L[TCY	*/

#define	ETHER_INPUT_STACK_SIZE	1024	/* Ethernet ̓^XÑX^bNTCY	*/
#define	ETHER_OUTPUT_STACK_SIZE	1024	/* Ethernet o̓^XÑX^bNTCY	*/

#define ETHER_INPUT_PRIORITY	5	/* Ethernet ̓^XN̗Dx		*/
#define ETHER_OUTPUT_PRIORITY	5	/* Ethernet o̓^XN̗Dx		*/

/*#define ETHER_CFG_ACCEPT_ALL		 }`LXgAG[t[MƂ̓RgOB	*/
/*#define ETHER_CFG_UNEXP_WARNING	 T|[gt[̌x\Ƃ̓RgOB		*/
/*#define ETHER_CFG_802_WARNING		 IEEE 802.3 t[̌x\Ƃ̓RgOB		*/
/*#define ETHER_CFG_MCAST_WARNING	 }`LXǧx\Ƃ̓RgOB		*/

/*
 *  [vobNC^tF[XɊւ`
 */

#define LOMTU			1500	/* [vobN MTU			*/

#define NUM_DTQ_LOOP_INPUT	0	/* [vobN̓f[^L[TCY	*/
#define NUM_DTQ_LOOP_OUTPUT	0	/* [vobNo̓f[^L[TCY	*/

#define	LOOP_INPUT_STACK_SIZE	1024	/* [vobN̓^XÑX^bNTCY	*/
#define	LOOP_OUTPUT_STACK_SIZE	1024	/* [vobNo̓^XÑX^bNTCY	*/

#define LOOP_INPUT_PRIORITY	5	/* [vobN̓^XN̗Dx		*/
#define LOOP_OUTPUT_PRIORITY	5	/* [vobNo̓^XN̗Dx		*/

/*
 *  lbg[NɊւ`
 */

/* lbg[N^C}^XN */

#define	NET_TIMER_STACK_SIZE	1024	/* lbg[N^C}^XÑX^bNTCY */
#define NET_TIMER_PRIORITY	5	/* lbg[N^C}^XN̗Dx */

#define NUM_NET_CALLOUT		10	/* ^CAEgďoA10 ȏ	*/

/* net_buf  */

#ifdef SUPPORT_PPP

/*
 *  PPP ł́AMp net_buf  PDU (1502) TCY
 *  蓖ĂȂ΂ȂȂ̂ PDU TCY𑽂߂ɊmۂB
 *  128 TCY net_buf ́ATCP ZOgpɑ߂ɊmۂB
 */

#define NUM_MPF_NET_BUF_128	2	/* net_buf A128A2 ȏ	*/
#define NUM_MPF_NET_BUF_256	4	/* net_buf A256		*/
#define NUM_MPF_NET_BUF_512	1	/* net_buf A512		*/
#define NUM_MPF_NET_BUF_1024	1	/* net_buf A1024		*/
#define NUM_MPF_NET_BUF_IF_PDU	1	/* net_buf APDU		*/

#if defined(SUPPORT_INET4) && defined(IP4_CFG_FRAGMENT)

#ifndef NUM_MPF_NET_BUF_4096
#define NUM_MPF_NET_BUF_4096	2	/* net_buf A4096		*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_4096 */

#endif	/* of #if defined(SUPPORT_INET4) && defined(IP4_CFG_FRAGMENT) */

#endif	/* of #ifdef SUPPORT_PPP */

#ifdef SUPPORT_ETHER

/*
 *  C[Tlbgł́AMp net_buf ́ANIC ̃obt@ɂ
 *  t[Ċ蓖Ă΂悢B
 *  TCP ̍őZOgTCY 1024 INebg net_buf ɒꍇ́A
 *  ̃TCY net_buf ͑߂ɊmۂB
 *  128 TCY net_buf ATCP ̐ZOgpɑ߂ɊmۂB
 */

#ifndef NUM_MPF_NET_BUF_128
#define NUM_MPF_NET_BUF_128	4	/* net_buf A128A2 ȏ	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_128 */

#ifndef NUM_MPF_NET_BUF_256
#define NUM_MPF_NET_BUF_256	2	/* net_buf A256		*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_256 */

#ifndef NUM_MPF_NET_BUF_512
#define NUM_MPF_NET_BUF_512	2	/* net_buf A512		*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_512 */

#ifndef NUM_MPF_NET_BUF_1024
#define NUM_MPF_NET_BUF_1024	2	/* net_buf A1024		*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_1024 */

#ifndef NUM_MPF_NET_BUF_IF_PDU
#define NUM_MPF_NET_BUF_IF_PDU	4	/* net_buf APDU		*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_IF_PDU */

#if defined(SUPPORT_INET4) && defined(IP4_CFG_FRAGMENT)

#ifndef NUM_MPF_NET_BUF_4096
#define NUM_MPF_NET_BUF_4096	2	/* net_buf A4096		*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_4096 */

#endif	/* of #if defined(SUPPORT_INET4) && defined(IP4_CFG_FRAGMENT) */

#endif	/* of #ifdef SUPPORT_ETHER */

#ifdef SUPPORT_LOOP

#define NUM_MPF_NET_BUF_128	2	/* net_buf A128A2 ȏ	*/
#define NUM_MPF_NET_BUF_256	2	/* net_buf A256		*/
#define NUM_MPF_NET_BUF_512	2	/* net_buf A512		*/
#define NUM_MPF_NET_BUF_1024	2	/* net_buf A1024		*/
#define NUM_MPF_NET_BUF_IF_PDU	2	/* net_buf APDU		*/

#endif	/* of #ifdef SUPPORT_PPP */

/*
 *  lbg[Nv̌v
 *
 *  lbg[Nv̌vsꍇ́Atinet/include/net/net.h
 *  Œ`ĂvgRʃtOw肷B
 */

#if 1

#ifdef SUPPORT_INET4

#define NET_COUNT_ENABLE	(0			\
				| PROTO_FLG_PPP_HDLC	\
				| PROTO_FLG_PPP_PAP	\
				| PROTO_FLG_PPP_LCP	\
				| PROTO_FLG_PPP_IPCP	\
				| PROTO_FLG_PPP		\
				| PROTO_FLG_LOOP	\
				| PROTO_FLG_ETHER_NIC	\
				| PROTO_FLG_ETHER	\
				| PROTO_FLG_ARP		\
				| PROTO_FLG_IP4		\
				| PROTO_FLG_ICMP4	\
				| PROTO_FLG_UDP		\
				| PROTO_FLG_TCP		\
				| PROTO_FLG_NET_BUF	\
				)

#endif	/* of #ifdef SUPPORT_INET4 */

#ifdef SUPPORT_INET6

#define NET_COUNT_ENABLE	(0			\
				| PROTO_FLG_PPP_HDLC	\
				| PROTO_FLG_PPP_PAP	\
				| PROTO_FLG_PPP_LCP	\
				| PROTO_FLG_PPP_IPCP	\
				| PROTO_FLG_PPP		\
				| PROTO_FLG_LOOP	\
				| PROTO_FLG_ETHER_NIC	\
				| PROTO_FLG_ETHER	\
				| PROTO_FLG_IP6		\
				| PROTO_FLG_ICMP6	\
				| PROTO_FLG_ND6		\
				| PROTO_FLG_UDP		\
				| PROTO_FLG_TCP		\
				| PROTO_FLG_NET_BUF	\
				)

#endif	/* of #ifdef SUPPORT_INET6 */

#else	/* of #if 0 */

#define NET_COUNT_ENABLE	(0			\
				)

#endif	/* of #if 0 */

#endif /* _TINET_CPU_CONFIG_H_ */
