/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2002 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005 by Freelines CO.,Ltd 
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sys_support.S,v 1.1 2008/06/17 00:04:46 suikan Exp $
 */

/*
 *	^[QbgVXeˑW[ AZuꕔiTK-850ES/SG2pj
 */

#define	_MACRO_ONLY
#include "jsp_kernel.h"
#include "v850asm.inc"

#define Set(x,y,z) Lea x, r6; Lea y, r7; st.##z r7, 0[r6]

/*
 *  ჌x̃^[QbgVXeˑ̏
 *
 *  X^[gAbvW[̒ŁC̏̑OɌĂяoD
 */

	.text
	.globl hardware_init_hook
hardware_init_hook:

	/* VXeEFCgRg[WX^F5MHz~4=20MHz */
	Set(VSWC,  0x01,   b)
	nop
	/* ی삳ꂽ背WX^ւ̃ANZX
	   vZbTNbNRg[WX^FCNbNfxxo(PCC=0) */
	lea	PRCMD, r6
	lea	PCC, r7
	st.b	r0, 0[r6]
	st.b	r0, 0[r7]
	nop
	nop
	nop
	nop
	nop
	Set(PLLCTL,0x03,   b)   /* PLLRg[WX^FPLL */
	Set(WDTM2, 0x07,   b)   /* WDTM2 stop */
	/* OoX̐ݒ */
	Set(EXIMC, 0x01,   b)	/* OoXC^[tFCX[hWX^FZp[goX */
	Set(PMC9,  0xFFFF, h)	/* P9[hRg[WX^FA0-A15o */
	Set(PMCCM, 0x02,   b)	/* PCM[hRg[WX^FClock Outo */
	Set(PMCCT, 0x11,   b)	/* PCT[hRg[WX^FRD/WR0o */
	Set(PMCDL, 0xFFFF, h)	/* PDL[hRg[WX^FAD0-AD15o */
	Set(BSC,   0x5555, h)	/* oXTCYWX^FAll 16bit */
	Set(DWC0,  0x0000, h)	/* f[^EFCg䃌WX^Fwait=0 */
	Set(AWC,   0xFF00, h)	/* AhXEFCg䃌WX^Fwait=0 */
	Set(BCC,   0xAA00, h)	/* oXTCN䃌WX^Fwait=0 */
	/* NICݒ */
	Set(PMC0,  0x10,   b)	/* P04=INTP1 */
	Set(PMCT,  0xBF,   b)	/* ASTB=out(LAN CS) */
	Set(PCT,   0x00,   b)	/* ASTB=Low out */
	Set(PM5,   0xFD,   b)	/* LAN Reset out */
	Set(P5 ,   0x00,   b)	/* LAN Reset out */

	jmp		r31



	/* WݏƃX؁[T[ */
	.macro StandardInterruptEntry name
	.globl \name
\name:
	jr	vector_handler
	nop;nop;nop;nop;nop;nop
	.endm

	.macro ReservedInterruptEntry
	nop;nop;nop;nop;nop;nop;nop;nop
	.endm

/*
 * ݃nh̒`
 * 		Ƃ肠ӏɏW߂B
 */

	.section	".vectors","ax"
	.align      4
	.globl      __reset
__reset:
	jr	start
	nop;nop;nop;nop;nop;nop

	StandardInterruptEntry NMI
	StandardInterruptEntry INTWDT2
	ReservedInterruptEntry 
	StandardInterruptEntry TRAP0
	StandardInterruptEntry TRAP1
	StandardInterruptEntry DBG
/*#-------------------------------------------------------------------
  #	SECURITY_ID
  #-------------------------------------------------------------------*/
/*	.section	"SECURITY_ID" */
	.word	0xffffffff	/* --0-3 byte code,Address is 0x70-0x73 */
	.word	0xffffffff	/* --4-7 byte code,Address is 0x74-0x77 */
	.hword	0xffff		/* --8-9 byte code,Address is 0x78-0x79 */
/*#-------------------------------------------------------------------
  #	OPTION_BYTES
  #-------------------------------------------------------------------*/
/*	.section	"OPTION_BYTES" */
	.hword	0x0000		/* --0-1 byte code,Address is 0x7a-0x7b */
	.hword	0x0000		/* --2-3 byte code,Address is 0x7c-0x7d */
	.hword	0x0000		/* --4-5 byte code,Address is 0x7e-0x7f */

	StandardInterruptEntry INTLVI
	StandardInterruptEntry INTP0
	StandardInterruptEntry INTP1
	StandardInterruptEntry INTP2
	StandardInterruptEntry INTP3
	StandardInterruptEntry INTP4
	StandardInterruptEntry INTP5
	StandardInterruptEntry INTP6
	StandardInterruptEntry INTP7
	StandardInterruptEntry INTTQ0OV
	StandardInterruptEntry INTTQ0CC0
	StandardInterruptEntry INTTQ0CC1
	StandardInterruptEntry INTTQ0CC2
	StandardInterruptEntry INTTQ0CC3
	StandardInterruptEntry INTTP0OV
	StandardInterruptEntry INTTP0CC0
	StandardInterruptEntry INTTP0CC1
	StandardInterruptEntry INTTP1OV
	StandardInterruptEntry INTTP1CC0
	StandardInterruptEntry INTTP1CC1
	StandardInterruptEntry INTTP2OV
	StandardInterruptEntry INTTP2CC0
	StandardInterruptEntry INTTP2CC1
	StandardInterruptEntry INTTP3OV
	StandardInterruptEntry INTTP3CC0
	StandardInterruptEntry INTTP3CC1
	StandardInterruptEntry INTTP4OV
	StandardInterruptEntry INTTP4CC0
	StandardInterruptEntry INTTP4CC1
	StandardInterruptEntry INTTP5OV
	StandardInterruptEntry INTTP5CC0
	StandardInterruptEntry INTTP5CC1
	StandardInterruptEntry INTTM0EQ0
	StandardInterruptEntry INTCB0R
	StandardInterruptEntry INTCB0T
	StandardInterruptEntry INTCB1R
	StandardInterruptEntry INTCB1T
	StandardInterruptEntry INTCB2R
	StandardInterruptEntry INTCB2T
	StandardInterruptEntry INTCB3R
	StandardInterruptEntry INTCB3T
	StandardInterruptEntry INTUA0R
	StandardInterruptEntry INTUA0T
	StandardInterruptEntry INTUA1R
	StandardInterruptEntry INTUA1T
	StandardInterruptEntry INTUA2R
	StandardInterruptEntry INTUA2T
	StandardInterruptEntry INTAD
	StandardInterruptEntry INTDMA0
	StandardInterruptEntry INTDMA1
	StandardInterruptEntry INTDMA2
	StandardInterruptEntry INTDMA3
	StandardInterruptEntry INTKR
	StandardInterruptEntry INTWTI
	StandardInterruptEntry INTWT
	StandardInterruptEntry INTC0ERR
	StandardInterruptEntry INTC0WUP
	StandardInterruptEntry INTC0REC
	StandardInterruptEntry INTC0TRX

/*
 * ]p\?^C}
 *  (͕]pt[jO^C}炸ɒڃ^C}JE^̂)
 */
Function _vxget_tim
	Lea	TP0CNT, r7
	ld.h	0[r7], r8
	st.w	r8, 0[r6]
	mov	r0, r10
	jmp	r31
