/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2005 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *      vZbTˑW[ AZuꕔiXstormy16pj
 */

#define _MACRO_ONLY
#include <offset.h>
#include <cpu_sfrs.h>

/*
 *  ^XNE荞݁EOǗpRAM̈
 */
        .section .data_0,"aw"

                                /*
                                 *  荞݁EOlXgJE^
                                 *  (J[lN^XNReLXg
                                 *  Ĉߏl1Ƃ)
                                 */
        .global _kernel_intnest
_kernel_intnest:
        .hword 1

                                /*
                                 *  荞݃nhe[u
                                 *  (UART荞݂܂17)
                                 */
        .global _kernel_ih_table
_kernel_ih_table:
        .hword 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

                                /*
                                 *  Onhe[u
                                 *  (`/Ԓn[hANZX/
                                 *  O/reserved)
                                 */
        .global _kernel_eh_table
_kernel_eh_table:
        .hword 0,0,0,0

/*
 *  荞݃xNg
 *  (section8000h-8083hɃN)
 */
        .section .int_vec,"ax"
        .global _start
        .align 1
_start:
	clr1 psw,#7
        br _kernel_int_irq_0
	clr1 psw,#7
        br _kernel_int_irq_1
	clr1 psw,#7
        br _kernel_int_irq_2
	clr1 psw,#7
        br _kernel_int_irq_3
	clr1 psw,#7
        br _kernel_int_irq_4
	clr1 psw,#7
        br _kernel_int_irq_5
	clr1 psw,#7
        br _kernel_int_irq_6
	clr1 psw,#7
        br _kernel_int_irq_7
	clr1 psw,#7
        br _kernel_int_irq_8
	clr1 psw,#7
        br _kernel_int_irq_9
	clr1 psw,#7
        br _kernel_int_irq_a
	clr1 psw,#7
        br _kernel_int_irq_b
	clr1 psw,#7
        br _kernel_int_irq_c
	clr1 psw,#7
        br _kernel_int_irq_d
	clr1 psw,#7
        br _kernel_int_irq_e
	clr1 psw,#7
        br _kernel_int_irq_f
        .org 0x80
        jmpf _kernel_int_irq_ex

/*
 *  荞݃nh
 */
_kernel_int_irq_0:
                                /*
                                 *  b`hbO^C}荞݂RESET̔f
                                 */
        bn __WDTCR,#4,_after_reset
        bp __WDTCR,#5,_after_reset
        push r0
        mov r0,#_kernel_ih_table+0
        br _int_common
_after_reset:
	jmpf _int_reset
_kernel_int_irq_1:
        push r0
        mov r0,#_kernel_ih_table+2
        br _int_common
_kernel_int_irq_2:
        push r0
        mov r0,#_kernel_ih_table+4
        br _int_common
_kernel_int_irq_3:
        push r0
        mov r0,#_kernel_ih_table+6
        br _int_common
_kernel_int_irq_4:
        push r0
        mov r0,#_kernel_ih_table+8
        br _int_common
_kernel_int_irq_5:
        push r0
        mov r0,#_kernel_ih_table+10
        br _int_common
_kernel_int_irq_6:
        push r0
        mov r0,#_kernel_ih_table+12
        br _int_common
_kernel_int_irq_7:
        push r0
        mov r0,#_kernel_ih_table+14
        br _int_common
_kernel_int_irq_8:
        push r0
        mov r0,#_kernel_ih_table+16
        br _int_common
_kernel_int_irq_9:
        push r0
        mov r0,#_kernel_ih_table+18
        br _int_common
_kernel_int_irq_a:
        push r0
        mov r0,#_kernel_ih_table+20
        br _int_common
_kernel_int_irq_b:
        push r0
        mov r0,#_kernel_ih_table+22
        br _int_common
_kernel_int_irq_c:
        push r0
        mov r0,#_kernel_ih_table+24
        br _int_common
_kernel_int_irq_d:
        push r0
        mov r0,#_kernel_ih_table+26
        br _int_common
_kernel_int_irq_e:
        push r0
        mov r0,#_kernel_ih_table+28
        br _int_common
_kernel_int_irq_f:
        push r0
        mov r0,#_kernel_ih_table+30
        br _int_common

/*
 *  荞݃nh
 */
_int_common:
                                /*
                                 *  r1/r2̑ޔ(r0͑ޔς)
                                 */
        push r1
        push r2
                                /*
                                 *  lXg荞݂ǂ`FbN
                                 */
        mov r1,_kernel_intnest
        bz interrupt_from_task

/*
 *  lXg荞݂̏
 */
                                /*
                                 *  lXgJE^CNgA
                                 *  ʂ̊荞݂
                                 */
        inc r1
        mov _kernel_intnest,r1
        set1 psw,#7
                                /*
                                 *  r3-r9(caller saved register)̑ޔ
                                 */
        push r3
        push r4
        push r5
        push r6
        push r7
        push r8
        push r9
                                /*
                                 *  荞݃nȟĂяo
                                 */
        mov r1,(r0)
        bz 1f
        mov r8,#0
        call r8,r1
1:
                                /*
                                 *  r1-r9̕
                                 */
        pop r9
        pop r8
        pop r7
        pop r6
        pop r5
        pop r4
        pop r3
        pop r2
        pop r1
                                /*
                                 *  lXgJE^fNgA
                                 *  荞܂ꂽ̊荞݃nh֖߂
                                 */
        clr1 psw,#7
        mov r0,_kernel_intnest
        dec r0
        mov _kernel_intnest,r0
        pop r0
        iret

/*
 *  lXgĂȂ荞݂̏
 */
interrupt_from_task:
                                /*
                                 *  lXgJE^CNg
                                 */
        mov _kernel_intnest,#1
                                /*
                                 *  X^bN^XNpɐ؂ւA
                                 *  荞݂
                                 */
        mov r1,sp
        mov sp,#__stack
        set1 psw,#7
                                /*
                                 *  r3-r9(caller saved register)
                                 *  ^XNX^bNɑޔ
                                 */
        mov (r1++),r3
        mov (r1++),r4
        mov (r1++),r5
        mov (r1++),r6
        mov (r1++),r7
        mov r3,r8
        mov (r1++),r3
        mov r3,r9
        mov (r1++),r3
                                /*
                                 *  ^XNX^bN|C^荞ݗp
                                 *  X^bNɑޔ
                                 */
        push r1
                                /*
                                 *  荞݃nȟĂяo
                                 */
        mov r1,(r0)
        bz 1f
        mov r8,#0
        call r8,r1
1:
                                /*
                                 *  荞݂֎~
                                 */
        clr1 psw,#7

/*
 *  荞݁AOʂ̏o
 */
ret_int_and_exc:
                                /*
                                 *  ^XNpX^bNɖ߂
                                 */
        pop r1
        mov sp,r1
                                /*
                                 *  lXgJE^fNg
                                 */
        mov _kernel_intnest,#0
                                /*
                                 *  reqflg`FbNAFALSEȂA
                                 *  ^XNɖ߂鏈ɃWv
                                 */
        mov r0,#_kernel_reqflg
        mov r1,(r0)
        bz ret_to_task_int

/*
 *  荞ݒɃ^XN̐؂ւvꍇ̏
 */
                                /*
                                 *  reqflgNA
                                 */
        mov r1,#0
        mov (r0),r1
                                /*
                                 *  fBXpb`֎~Aruntsk=schedtsk
                                 *  ȂÃ^XNɖ߂鏈
                                 */
        mov r0,#_kernel_enadsp
        mov r1,(r0)
        bz ret_int_1
        mov r0,#_kernel_runtsk
        mov r1,(r0)
        mov r2,#_kernel_schedtsk
        mov r3,(r2)
        bz r1,r3,ret_int_1
                                /*
                                 *  ^XN̐؂ւ̂߁Ar10-13/spޔ
                                 */
        push r10
        push r11
        push r12
        push r13
        mov r7,sp
        mov (r1,+TCB_sp),r7             /* r1 points runtsk */
                                /*
                                 *  mode=1(ret_int_rɖ߂)ݒ肵
                                 *  fBXpb`
                                 */
        mov r7,#1
        mov (r1,+TCB_mode),r7
        br dispatcher

/*
 *  荞ݒ̃fBXpb`̕A
 */
ret_int_r:

                                /*
                                 *  r10-13𕜌
                                 */
        pop r13
        pop r12
        pop r11
        pop r10

/*
 *  ̃^XNɖ߂鏈
 */
ret_int_1:
        mov r0,#_kernel_runtsk
        mov r1,(r0)
                                /*
                                 *  ^XNOnh̃`FbN
                                 */
        mov.b r7,(r1,+TCB_enatex)
        bn r7,#TCB_enatex_bit,ret_to_task_int
                                /*
                                 *  ^XNÕ`FbN
                                 */
        mov r7,(r1,+TCB_texptn)
        bz ret_to_task_int
                                /*
                                 *  ^XNOnȟĂяo
                                 */
        callf _kernel_call_texrtn
                                /*
                                 *  r0-r9𕜌Ã^XNɖ߂
                                 */
ret_to_task_int:
        pop r9
        pop r8
        pop r7
        pop r6
        pop r5
        pop r4
        pop r3
        pop r2
        pop r1
        pop r0
        iret

/*
 *  Onh
 */
        .global _kernel_int_irq_ex
_kernel_int_irq_ex:
        push r0
                                /*
                                 *  UARTO͊荞݂Ƃď
                                 */
        bn __U0CR,#0,1f                 /* UART0 RxRdy */
        bn __U0CR,#1,1f
        mov r0,#_kernel_ih_table+32
        br _int_common
1:
        bn __U0CR,#2,2f                 /* UART0 TxEmpty */
        bn __U0CR,#3,2f
        mov r0,#_kernel_ih_table+32
        br _int_common
2:
        bn __U1CR,#0,3f                 /* UART1 RxRdy */
        bn __U1CR,#1,3f
        mov r0,#_kernel_ih_table+32
        br _int_common
3:
        bn __U1CR,#2,4f                 /* UART1 TxEmpty */
        bn __U1CR,#3,4f
        mov r0,#_kernel_ih_table+32
        br _int_common
4:
                                /*
                                 *  r1,r2ޔAr2ɗOSPݒ
                                 *  (Onhւ̈)
                                 */
        push r1
        push r2
        mov r2,sp
        sub r2,#6
                                /*
                                 *  O𔻒/NA
                                 */
        bn __EXCPL,#1,5f                /* undefined instruction */
        set1 psw,#11
        clr1 __EXCPL,#1
        clr1 psw,#11
        mov r0,#_kernel_eh_table+0
        br _exc_common
5:
        bn __EXCPL,#3,6f                /* word access to odd address */
        set1 psw,#11
        clr1 __EXCPL,#3
        clr1 psw,#11
        mov r0,#_kernel_eh_table+2
        br _exc_common
6:
        bn __EXCPL,#5,7f                /* acccess out of mamoey range */
        set1 psw,#11
        clr1 __EXCPL,#5
        clr1 psw,#11
        mov r0,#_kernel_eh_table+4
        br _exc_common
7:
        mov r0,#_kernel_eh_table+6      /* unknown exception */
        br _exc_common

/*
 *  Onh
 */
_exc_common:
                                /*
                                 *  lXgOǂ`FbN
                                 *  (ÓÅ荞݂ɃlXg
                                 *  Ƃ͖̂ŁA荞݋֎~
                                 *  sv)
                                 */
        mov r1,_kernel_intnest
        bz exception_from_task

/*
 *  lXgȌ
 */
                                /*
                                 *  lXgJE^CNg
                                 */
        inc r1
        mov _kernel_intnest,r1
                                /*
                                 *  r3-r9(caller saved register)̑ޔ
                                 */
        push r3
        push r4
        push r5
        push r6
        push r7
        push r8
        push r9
                                /*
                                 *  OnȟĂяo
                                 */
        mov r1,(r0)
        bz 1f
        mov r8,#0
        call r8,r1
1:
                                /*
                                 *  r1-r9̕
                                 */
        pop r9
        pop r8
        pop r7
        pop r6
        pop r5
        pop r4
        pop r3
        pop r2
        pop r1
                                /*
                                 *  lXgJE^fNgA
                                 *  荞܂ꂽ̊荞݃nh֖߂
                                 */
        mov r0,_kernel_intnest
        dec r0
        mov _kernel_intnest,r0
        pop r0
        iret

/*
 *  lXgĂȂȌ
 */
exception_from_task:
                                /*
                                 *  lXgJE^CNg
                                 */
        mov _kernel_intnest,#1
                                /*
                                 *  X^bN^XNpɐ؂ւ
                                 */
        mov r1,sp
        mov sp,#__stack
                                /*
                                 *  r3-r9(caller saved register)
                                 *  ^XNX^bNɑޔ
                                 */
        mov (r1++),r3
        mov (r1++),r4
        mov (r1++),r5
        mov (r1++),r6
        mov (r1++),r7
        mov r3,r8
        mov (r1++),r3
        mov r3,r9
        mov (r1++),r3
                                /*
                                 *  ^XNX^bN|C^荞ݗp
                                 *  X^bNɑޔ
                                 */
        push r1
                                /*
                                 *  OnȟĂяo
                                 */
        mov r1,(r0)
        bz 1f
        mov r8,#0
        call r8,r1
1:
                                /*
                                 *  荞݁EOʏo
                                 */
        br ret_int_and_exc

/*
 *  exit_and_dispatch()
 *  ̃ReLXgۑV^XN֐؂ւ
 *  (J[lJnŏ̃^XN̋N܂)
 */
        .global _kernel_exit_and_dispatch
_kernel_exit_and_dispatch:
                                /*
                                 *  lXgJE^NA
                                 *  (J[lJn㓙AOɎsĂ
                                 *  ^XNꍇA^XNReLXg
                                 *  s߁AlXgJE^1
                                 *  ȂĂBNA)
                                 */
        mov _kernel_intnest,#0
                                /*
                                 *  fBXpb`ŃWv
                                 */
        br dispatcher

/*
 *  dispatch()
 *  ̃ReLXgۑV^XN֐؂ւ
 */
        .global _kernel_dispatch
_kernel_dispatch:
                                /*
                                 *  r10-r14(callee-saved egister)ۑ
                                 */
        push r10
        push r11
        push r12
        push r13
        push psw
                                /*
                                 *  SPruntsk->tskctxb.spɕۑ
                                 */
        mov r0,#_kernel_runtsk
        mov r1,(r0)
        mov r7,sp
        mov (r1,+TCB_sp),r7
                                /*
                                 *  mode=0(dispatch_rɖ߂)ݒ肵
                                 *  fBXpb`
                                 */
        mov r7,#0
        mov (r1,+TCB_mode),r7
        br dispatcher

/*
 *  dispatch()̖߂菈
 *  (r3TCB)
 */
dispatch_r:
                                /*
                                 *  r10-r14(callee-saved egister)𕜌
                                 */
        pop psw
        pop r13
        pop r12
        pop r11
        pop r10
                                /*
                                 *  ^XNO`FbNA&
                                 *  OȂĂяo
                                 */
        mov.b r7,(r3,+TCB_enatex)
        bn r7,#TCB_enatex_bit,1f
        mov r7,(r3,+TCB_texptn)
        bz 1f
        jmpf _kernel_call_texrtn
1:
                                /*
                                 *  dispatch()Ă񂾃^XNɖ߂
                                 */
        ret

/*
 *  create_context()/activate_context()
 *  V^XN̋N
 *  (r2TCB)
 */
        .global _kernel_create_context
_kernel_create_context:
        ret

        .global _kernel_activate_context
_kernel_activate_context:
                                /*
                                 *  X^bN|C^
                                 *  tcb->tskctxb.sp=tcb->tinib->stk
                                 */
        mov r0,(r2,+TCB_tinib)
        mov r1,(r0,+TINIB_stk)
        mov (r2,+TCB_sp),r1
                                /*
                                 *  mode=2(activate_rɖ߂)ݒ
                                 */
        mov r1,#2
        mov (r2,+TCB_mode),r1
        ret

/*
 *  activate_context()ꂽ^XN̋N
 *  (r3TCB)
 */
activate_r:
                                /*
                                 *  ^XNreturnŏIƂɁA
                                 *  ext_tsk()Ă΂悤A
                                 *  X^bNɐς
                                 */
        mov r1,#@lo(ext_tsk)
        push r1
        mov r2,#@hi(ext_tsk)
        push r2
                                /*
                                 *  ^XNJnAhXX^bNɐς
                                 */
        mov r0,(r3,+TCB_tinib)
        mov r1,(r0,+TINIB_task)
        push r1
        mov r2,#0
        push r2
                                /*
                                 *  PSWlX^bNɐς
                                 */
        mov r1,#0x0080
        push r1
                                /*
                                 *  r2=exinf
                                 */
        mov r2,(r0,+TINIB_exinf)
                                /*
                                 *  ^XNN
                                 */
        iret

/*
 *  fBXpb`[
 */
dispatcher:
                                /*
                                 *  runtsk = schedtsk
                                 */
        mov r2,#_kernel_schedtsk
        mov r3,(r2)
        mov r0,#_kernel_runtsk
        mov (r0),r3
                                /*
                                 *  schedtsk = NULL(s\ȃ^XN)
                                 *  ̏ꍇAACh
                                 */
        bz dispatcher_1
                                /*
                                 *  SP𕜌
                                 */
        mov r7,(r3,+TCB_sp)
        mov sp,r7
                                /*
                                 *  modeɂāA
                                 *   =0 : dispatch_r
                                 *   =1 : ret_int_r
                                 *   =2 : activate_r
                                 */
        mov r7,(r3,+TCB_mode)
        bz dispatch_r
        bz r7,#1,ret_int_r
        br activate_r

/*
 *  ACh(s\^XN)
 */
dispatcher_1:
                                /*
                                 *  X^bN^XNpɐ؂ւ
                                 */
        mov sp,#__stack
                                /*
                                 *  ^XN߂
                                 *  lXgJE^1Zbg
                                 */
        mov _kernel_intnest,#1
                                /*
                                 *  ^XNs\҂̃[v
                                 */
dispatcher_2:
                                /*
                                 *  荞݃x0(IL=0)
                                 */
        mov psw,#0x0000
                                /*
                                 *  ACh[`Ăяo
                                 */
        callf _kernel_idle
                                /*
                                 *  ^XNs\ɂȂ̃`FbN
                                 *  (reqflg=1?)
                                 */
        mov r0,#_kernel_reqflg
        mov r1,(r0)
        bz dispatcher_2
                                /*
                                 *  reqflgƃlXgJE^NAA
                                 *  fBXpb`ɖ߂
                                 */
        mov r1,#0
        mov (r0),r1
        mov _kernel_intnest,#0
        br dispatcher

/*
 *  ftHg̃ACh[`
 */
        .weak _kernel_idle
_kernel_idle:
                                /*
                                 *  荞݂
                                 */
        set1 psw,#7
                                /*
                                 *  荞ݑ҂
                                 */
        halt
                                /*
                                 *  荞݂֎~
                                 */
        clr1 psw,#7
        ret

        .end

