/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: time_event.c,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

/*
 *	^CCxgǗW[
 */

#include "jsp_kernel.h"
#include "check.h"
#include "time_event.h"

/*
 *  ^CCxgq[v}N
 */
#define	PARENT(index)	((index) >> 1)		/* em[h߂ */
#define	LCHILD(index)	((index) << 1)		/* E̎qm[h߂ */
#define	TMEVT_NODE(index)	(tmevt_heap[(index) - 1])

/*
 *  Cxgr}N
 *
 *  CxǵCcurrent_time ̑ΒlŔrDȂ킿C
 *  current_time ŏlił߂jCcurrent_time - 1 ől
 *  iłjƂ݂ȂĔrD
 */
#define	EVTTIM_LT(t1, t2) (((t1) - current_time) < ((t2) - current_time))
#define	EVTTIM_LE(t1, t2) (((t1) - current_time) <= ((t2) - current_time))

#ifdef __tmeini

/*
 *  VXẽItZbg
 */
SYSTIM	systim_offset;

/*
 *  ݂̃VXeiP: ~bj
 *
 *  ɂ́CÕ^CeBbÑVXeD
 */
SYSTIM	current_time;

/*
 *  ̃^CeBbÑVXeiP: 1~bj
 */
SYSTIM	next_time;

/*
 *  VXeώZpϐiP: 1/TIM_DENO~bj
 */
#if TIC_DENO != 1
UINT	next_subtime;
#endif /* TIC_DENO != 1 */

/*
 *  ^CCxgq[v̍Ō̎gp̈̃CfbNX
 */
UINT	last_index;

/*
 *  ^C}W[̏
 */
void
tmevt_initialize(void)
{
	systim_offset = 0;
	current_time = 0;
#if TIC_DENO == 1
	next_time = current_time + TIC_NUME;
#else /* TIC_DENO == 1 */
	next_subtime += TIC_NUME;
	next_time = current_time + next_subtime / TIC_DENO;
	next_subtime %= TIC_DENO;
#endif /* TIC_DENO == 1 */
	last_index = 0;
}

#endif /* __tmeini */

/*
 *  ^CCxg̑}ʒuɒT
 *
 *   time ɔ^CCxg}m[h󂯂邽߂ɁC
 *  q[v̏Ɍċm[hړDړŐm[ḧʒu 
 *  index ɓnƁCړ̋m[ḧʒuiȂ킿}ʒujԂD
 */
#ifdef __tmeup

UINT
tmevt_up(UINT index, EVTTIM time)
{
	UINT	parent;

	while (index > 1) {
		/*
		 *  em[h̃Cxg̕i܂͓j
		 *  Ȃ΁Cindex }ʒuȂ̂Ń[v𔲂D
		 */
		parent = PARENT(index);
		if (EVTTIM_LE(TMEVT_NODE(parent).time, time)) {
			break;
		}

		/*
		 *  em[h index ̈ʒuɈړD
		 */
		TMEVT_NODE(index) = TMEVT_NODE(parent);
		TMEVT_NODE(index).tmevtb->index = index;

		/*
		 *  index em[ḧʒuɍXVD
		 */
		index = parent;
	}
	return(index);
}

#endif /* __tmeup */

/*
 *  ^CCxg̑}ʒuɒT
 *
 *   time ɔ^CCxg}m[h󂯂邽߂ɁC
 *  q[v̉Ɍċm[hړDړŐm[ḧʒu 
 *  index ɓnƁCړ̋m[ḧʒuiȂ킿}ʒujԂD
 */
#ifdef __tmedown

UINT
tmevt_down(UINT index, EVTTIM time)
{
	UINT	child;

	while ((child = LCHILD(index)) <= last_index) {
		/*
		 *  E̎qm[h̃CxgrC
		 *  qm[ḧʒu child ɐݒ肷Dȉ̎qm[h
		 *  ́CőI΂ꂽ̎qm[ĥƁD
		 */
		if (child + 1 <= last_index
			&& EVTTIM_LT(TMEVT_NODE(child + 1).time,
				  TMEVT_NODE(child).time)) {
			child = child + 1;
		}

		/*
		 *  qm[h̃Cxg̕xi܂͓j
		 *  Ȃ΁Cindex }ʒuȂ̂Ń[v𔲂D
		 */
		if (EVTTIM_LE(time, TMEVT_NODE(child).time)) {
			break;
		}

		/*
		 *  qm[h index ̈ʒuɈړD
		 */
		TMEVT_NODE(index) = TMEVT_NODE(child);
		TMEVT_NODE(index).tmevtb->index = index;

		/*
		 *  index qm[ḧʒuɍXVD
		 */
		index = child;
	}
	return(index);
}

#endif /* __tmedown */

/*
 * ^CCxgq[vւ̓o^
 *
 *  ^CCxgubN tmevtb Ctime Ŏw肵ԂoߌɃC
 *  xg悤ɁC^CCxgq[vɓo^D
 */
#ifdef __tmeins

void
tmevtb_insert(TMEVTB *tmevtb, EVTTIM time)
{
	UINT	index;

	/*
	 *  last_index CNgCɑ}ʒuTD
	 */
	index = tmevt_up(++last_index, time);

	/*
	 *  ^CCxg index ̈ʒuɑ}D
	 */ 
	TMEVT_NODE(index).time = time;
	TMEVT_NODE(index).tmevtb = tmevtb;
	tmevtb->index = index;
}

#endif /* __tmeins */

/*
 *  ^CCxgq[v̍폜
 */
#ifdef __tmedel

void
tmevtb_delete(TMEVTB *tmevtb)
{
	UINT	index = tmevtb->index;
	UINT	parent;
	EVTTIM	event_time = TMEVT_NODE(last_index).time;

	/*
	 *  폜ɂ^CCxgq[vɂȂꍇ͉ȂD
	 */
	if (--last_index == 0) {
		return;
	}

	/*
	 *  폜m[ḧʒuɍŌ̃m[hilast_index + 1 ̈ʒu
	 *  ̃m[hj}CK؂ȈʒuֈړDۂɂ́C
	 *  Ō̃m[hۂɑ}̂ł͂ȂC폜m[ḧ
	 *  um[hɂȂ̂ŁCŌ̃m[h}ׂʒu֌
	 *  ċm[hړD
	 *  Ō̃m[h̃CxgC폜m[h̐em[h
	 *  ̃CxgȌꍇɂ́CɌđ}ʒu
	 *  TDłȂꍇɂ́CɌĒTD
	 */
	if (index > 1 && EVTTIM_LT(event_time,
				TMEVT_NODE(parent = PARENT(index)).time)) {
		/*
		 *  em[h index ̈ʒuɈړD
		 */
		TMEVT_NODE(index) = TMEVT_NODE(parent);
		TMEVT_NODE(index).tmevtb->index = index;

		/*
		 *  폜m[h̐em[hɌđ}ʒu
		 *  TD
		 */
		index = tmevt_up(parent, event_time);
	}
	else {
		/*
		 *  폜m[h牺Ɍđ}ʒuTD
		 */
		index = tmevt_down(index, event_time);
	}

	/*
	 *  Ō̃m[h index ̈ʒuɑ}D
	 */ 
	TMEVT_NODE(index) = TMEVT_NODE(last_index + 1);
	TMEVT_NODE(index).tmevtb->index = index;
}

#endif /* __tmedel */

/*
 *  ^CCxgq[v̐擪̃m[h̍폜
 */
Inline void
tmevtb_delete_top(void)
{
	UINT	index;
	EVTTIM	event_time = TMEVT_NODE(last_index).time;

	/*
	 *  폜ɂ^CCxgq[vɂȂꍇ͉ȂD
	 */
	if (--last_index == 0) {
		return;
	}

	/*
	 *  [gm[hɍŌ̃m[hilast_index + 1 ̈ʒũm[hj
	 *  }CK؂ȈʒuֈړDۂɂ́CŌ̃m[
	 *  hۂɑ}̂ł͂ȂC[gm[hm[hɂȂ
	 *  ̂ŁCŌ̃m[h}ׂʒu֌ċm[hړ
	 *  D
	 */
	index = tmevt_down(1, event_time);

	/*
	 *  Ō̃m[h index ̈ʒuɑ}D
	 */ 
	TMEVT_NODE(index) = TMEVT_NODE(last_index + 1);
	TMEVT_NODE(index).tmevtb->index = index;
}

/*
 *  ^CeBbN̋
 *
 *  TIC_NUME < TIC_DENO ̎́CZg킸Ɏ̍XVł邪C\[
 *  XR[hǂ݂₷ɂ邽߂ #if ̑pĂD
 */
#ifdef __isig_tim

SYSCALL ER
isig_tim(void)
{
	TMEVTB	*tmevtb;
	ER	ercd;

	LOG_ISIG_TIM_ENTER();
	CHECK_INTCTX_UNL();
	i_lock_cpu();

	/*
	 *  next_time Cxg̑i܂͓j^CC
	 *  xgC^CCxgq[v폜CR[obN֐
	 *  ĂяoD
	 */
	while (last_index > 0 && EVTTIM_LE(TMEVT_NODE(1).time, next_time)) {
		tmevtb = TMEVT_NODE(1).tmevtb;
		tmevtb_delete_top();
		(*(tmevtb->callback))(tmevtb->arg);

		/*
		 *  ŗDx݂̍󂯕tD
		 */
		i_unlock_cpu();
		i_lock_cpu();
	}

	/*
	 *  current_time XVD
	 */
	current_time = next_time;

	/*
	 *  next_timeCnext_subtime XVD
	 */
#if TIC_DENO == 1
	next_time = current_time + TIC_NUME;
#else /* TIC_DENO == 1 */
	next_subtime += TIC_NUME % TIC_DENO;
	next_time = current_time + TIC_NUME / TIC_DENO;
	if (next_subtime >= TIC_DENO) {
		next_subtime -= TIC_DENO;
		next_time += 1u;
	}
#endif /* TIC_DENO == 1 */

	ercd = E_OK;
	i_unlock_cpu();

    exit:
	LOG_ISIG_TIM_LEAVE(ercd);
	return(ercd);
}

#endif /* __isig_tim */
