/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: wait.h,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

/*
 *	҂ԊǗW[
 */

#ifndef _WAIT_H_
#define _WAIT_H_

#include "task.h"
#include "time_event.h"

/*
 *  ҂Ԃւ̈ڍs
 *
 *  s̃^XN҂ԂɈڍsD̓Iɂ́Cs̃^XN
 *  fBL[폜CTCB  winfotB[hCWINFO  tmevtbt
 *  B[hݒ肷D
 */
Inline void
make_wait(WINFO *winfo)
{
	make_non_runnable(runtsk);
	runtsk->winfo = winfo;
	winfo->tmevtb = NULL;
}

/*
 *  ҂Ԃւ̈ڍsi^CAEgwj
 *
 *  s̃^XNC^CAEgwtő҂ԂɈڍsD
 *  Iɂ́Cs̃^XNfBL[폜CTCB  winfotB[
 *  hCWINFO  tmevtbtB[hݒ肷D܂C^CCxgu
 *  bNo^D
 */
extern void	make_wait_tmout(WINFO *winfo, TMEVTB *tmevtb, TMO tmout);

/*
 *  ҂
 *
 *  tcb Ŏw肳^XN̑҂ԂD̓Iɂ́C^CCx
 *  gubNo^Ă΁Co^D܂C^XN
 *  ԂXVC҂^XN̕Ԓl E_OK ƂD҂L[
 *  ̍폜͍sȂD҂^XNւ̃fBXpb`Kvȏ
 *  ɂ TRUE ԂD
 */
extern BOOL	wait_complete(TCB *tcb);

/*
 *  ^CAEgɔ҂
 *
 *  tcb Ŏw肳^XNC҂L[ɂȂĂΑ҂L[
 *  폜C^XNԂXVD܂C҂^XN̕Ԓl
 *  Cwait_tmoutł E_TMOUTCwait_tmout_ok ł E_OK ƂD҂
 *  ^XNւ̃fBXpb`KvȎ́Creqflg  TRUE ɂD
 *  wait_tmout_ok ́Cdly_tsk Ŏg߂̂̂ŁC҂L[폜
 *  鏈sȂD
 *  ̊֐C^CCxg̃R[obN֐Ƃėp邽߂
 *  ̂ŁC݃nhĂяo邱Ƃz肵ĂD
 */
extern void	wait_tmout(TCB *tcb);
extern void	wait_tmout_ok(TCB *tcb);

/*
 *  ҂Ԃ̋
 *
 *  tcb Ŏw肳^XN̑҂ԂIɉD̓Iɂ́C^
 *  XN҂L[ɂȂĂΑ҂L[폜C^CCx
 *  gubNo^Ă΂o^D
 *  wait_cancel ́C^XN̏Ԃ͍XVȂD
 *  wait_release ́C^XN̏ԂXVC҂^XN̕
 *  l E_RLWAI ƂD܂C҂^XNւ̃fBXpb`K
 *  vȏꍇɂ TRUE ԂD
 */
extern void	wait_cancel(TCB *tcb);
extern BOOL	wait_release(TCB *tcb);

/*
 *  EʐMIuWFNg̊ǗubN̋ʕ샋[`
 *
 *  EʐMIuWFNg̏ubNƊǗubN̐擪͋
 *  ʂɂȂĂDȉ́C̋ʕ߂̌^у[`Q
 *  łD
 *  ̑҂L[EʐMIuWFNg̏ꍇC擪ȊȎ҂
 *  L[𑀍삷ꍇɂ́C̃[`͎gȂD܂CIuWF
 *  Ng TA_TPRI rbgQƂ̂ŁC̃rbg𑼂̖ړIɎg
 *  ĂꍇC̃[`͎gȂD
 */

/*
 *  EʐMIuWFNg̏ubN̋ʕ
 */
typedef struct wait_object_initialization_block {
	ATR	wobjatr;	/* IuWFNg */
} WOBJINIB;

/*
 *  EʐMIuWFNg̊ǗubN̋ʕ
 */
typedef struct wait_object_control_block {
	QUEUE		wait_queue;	/* ҂L[ */
	const WOBJINIB	*wobjinib;	/* ubNւ̃|C^ */
} WOBJCB;

/*
 *  EʐMIuWFNg҂ubN̒`
 */
typedef struct wait_object_waiting_information {
	WINFO	winfo;		/* W̑҂ubN */
	WOBJCB	*wobjcb;	/* ҂IuWFNg̊ǗubN */
} WINFO_WOBJ;

/*
 *  EʐMIuWFNgɑ΂҂Ԃւ̈ڍs
 *  
 *  s̃^XN҂ԂɈڍsCEʐMIuWFNg̑҂L[
 *  ɂȂD܂C҂ubNiWINFOj wobjcb ݒ肷D
 *  wobj_make_wait_tmout ́C^CCxgubN̓o^sD
 */
extern void	wobj_make_wait(WOBJCB *wobjcb, WINFO_WOBJ *winfo);
extern void	wobj_make_wait_tmout(WOBJCB *wobjcb, WINFO_WOBJ *winfo,
					TMEVTB *tmevtb, TMO tmout);

/*
 *  ^XNDxύX̏
 *
 *  EʐMIuWFNgɑ΂҂Ԃɂ^XN̗DxύX
 *  ꂽꍇɁC҂L[̒ł̃^XN̈ʒuCD
 */
extern void	wobj_change_priority(WOBJCB *wobjcb, TCB *tcb);

#endif /* _WAIT_H_ */
