#! /usr/bin/perl
#
#  TOPPERS/JSP Kernel
#      Toyohashi Open Platform for Embedded Real-Time Systems/
#      Just Standard Profile Kernel
# 
#  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
#                              Toyohashi Univ. of Technology, JAPAN
#  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
#              Graduate School of Information Science, Nagoya Univ., JAPAN
#  Copyright (C) 2005-2007 by Industrial Technology Institute,
#                              Miyagi Prefectural Government, JAPAN
# 
#  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
#  ɂČ\Ă GNU General Public License  Version 2 ɋL
#  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
#  ς̂܂ށDȉjgpEEρEĔzziȉC
#  pƌĂԁj邱Ƃ𖳏ŋD
#  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
#      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
#      XR[hɊ܂܂Ă邱ƁD
#  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
#      pł`ōĔzzꍇɂ́CĔzzɔhLgip
#      ҃}jAȂǁjɁCL̒쌠\C̗pщL
#      ̖ۏ؋Kfڂ邱ƁD
#  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
#      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
#      ƁD
#    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
#        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
#    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
#        񍐂邱ƁD
#  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
#      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
# 
#  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
#  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
#  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
#  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
# 

#@e
#  @Ejsp/kernelɂ\[XR[hAPIɃRs[B
#  @@i֐PʂŃNł悤ɂj
#  @ERs[ۂɁAt@C擪#define __tskiniȂǂ̃}N`ǉB
#  @
#  g
#  @@perl copy_kernel_source.pl src_path dst_path
#  @@@
#  @@@@src_pathFjsp/kernelւ̑΃pX
#  @@@@dst_pathFt@C̃Rs[ւ̑΃pX


$src_path = $ARGV[0];
$dst_path = $ARGV[1];

# ɂȂ\[Xt@Cƒǉ}N̒`
%hash_array = (
 "task.c"
	=> [qw(tskini tsksched tskrun tsknrun tskdmt tskact tskext tskpri tskrot tsktex)],
 "wait.c"
	=> [qw(waimake waicmp waitmo waitmook waican wairel wobjwai wobjwaitmo wobjpri)],
 "time_event.c"
	=> [qw(tmeini tmeup tmedown tmeins tmedel isig_tim)],
 "syslog.c"
	=> [qw(logini vwri_log vrea_log vmsk_log logter)],
 "task_manage.c"
	=> [qw(act_tsk iact_tsk can_act ext_tsk ter_tsk chg_pri get_pri)],
 "task_sync.c"
	=> [qw(slp_tsk tslp_tsk wup_tsk iwup_tsk can_wup rel_wai irel_wai sus_tsk rsm_tsk frsm_tsk dly_tsk)],
 "task_except.c"
	=> [qw(ras_tex iras_tex dis_tex ena_tex sns_tex)],
 "semaphore.c"
	=> [qw(semini sig_sem isig_sem wai_sem pol_sem twai_sem)],
 "eventflag.c"
	=> [qw(flgini flgcnd set_flg iset_flg clr_flg wai_flg pol_flg twai_flg)],
 "dataqueue.c"
	=> [qw(dtqini dtqenq dtqfenq dtqdeq dtqsnd dtqrcv snd_dtq psnd_dtq ipsnd_dtq tsnd_dtq fsnd_dtq ifsnd_dtq rcv_dtq prcv_dtq trcv_dtq)],
 "mailbox.c"
	=> [qw(mbxini snd_mbx rcv_mbx prcv_mbx trcv_mbx)],
 "mempfix.c"
	=> [qw(mpfini mpfget get_mpf pget_mpf tget_mpf rel_mpf)],
 "time_manage.c"
	=> [qw(set_tim get_tim vxget_tim)],
 "cyclic.c"
	=> [qw(cycini cycenq sta_cyc stp_cyc cyccal)],
 "sys_manage.c"
	=> [qw(rot_rdq irot_rdq get_tid iget_tid loc_cpu iloc_cpu unl_cpu iunl_cpu dis_dsp ena_dsp sns_ctx sns_loc sns_dsp sns_dpn vsns_ini)],
 "interrupt.c"
	=> [qw(inhini)],
 "exception.c"
	=> [qw(excini vxsns_ctx vxsns_loc vxsns_dsp vxsns_dpn vxsns_tex)]
);

#
#@C̏
#
foreach $file (keys(%hash_array)) {
	@array = @{$hash_array{$file}};
	foreach $api (@array) {
		&copy_file($file, $api);
	}
}


#
#@1FɂȂ\[XR[h̃t@CipX܂܂j
#@2FRpCp̃}N`ǉAPIA֐
#@@@@@@o͂t@C˂ĂB
#
sub copy_file {
	my($filename, $api) = @_;
	open(OUTFILE, ">$dst_path/$api.c") || die "Cannot open $dst_path/$api.c";
	
	# APĨ}N`ǉ
	print OUTFILE "#define __$api\n";
	
	# jsp/kernelt@CRs[
	open(INFILE, "$src_path/$filename") || die "Cannot open $src_path/$filename";
	while ($line = <INFILE>) {
		print OUTFILE $line;
	}
	
	close(INFILE);
	close(OUTFILE);
}
