#! /usr/bin/perl
#
#  TOPPERS/JSP Kernel
#      Toyohashi Open Platform for Embedded Real-Time Systems/
#      Just Standard Profile Kernel
# 
#  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
#                              Toyohashi Univ. of Technology, JAPAN
#  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
#              Graduate School of Information Science, Nagoya Univ., JAPAN
#  Copyright (C) 2005-2007 by Industrial Technology Institute,
#                              Miyagi Prefectural Government, JAPAN
# 
#  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
#  ɂČ\Ă GNU General Public License  Version 2 ɋL
#  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
#  ς̂܂ށDȉjgpEEρEĔzziȉC
#  pƌĂԁj邱Ƃ𖳏ŋD
#  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
#      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
#      XR[hɊ܂܂Ă邱ƁD
#  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
#      pł`ōĔzzꍇɂ́CĔzzɔhLgip
#      ҃}jAȂǁjɁCL̒쌠\C̗pщL
#      ̖ۏ؋Kfڂ邱ƁD
#  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
#      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
#      ƁD
#    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
#        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
#    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
#        񍐂邱ƁD
#  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
#      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
# 
#  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
#  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
#  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
#  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
# 
#  @(#) $Id: genvector.pl,v 1.1 2008/06/17 00:04:45 suikan Exp $
# 


#
#  xN^e[uXNvg
#  @make dependɐtmp_script.plǂݍނƂɂ
#  @sł悤ɂȂ

#  IvV̒`
#
#  -s <vector size>	xN^[e[ũTCY
#  -z 		o^ĂȂ݃xN^ɂ0
#		-zIvVw肵Ȃꍇ́A_no_reg_expretion
#		
#		siMakefileŒ`ĂDBGENV}N̒lj
#		j^̎dlɂAKvɉėp


require "getopt.pl";


#
#  ݃nhxN^e[uɓo^
#@@ tmp_script.plĂ΂B

sub define_inh {
	my($inhno, $inthdr) = @_;
	
	if ($inhno == 0) {
		print STDERR <<ERRMESSAGE
In generating vector.S
Error in DEF_INH($inhno, {TA_HLNG, $inthdr});
\t Macro of interrupt handler number $inhno isn't defined.
\t If you define macro $inhno in header files,
\t it's necessary to use "#include" directive in configuration files
\t to genarate vector.S. 
\t (And it's also necessary to use static API "INCLUDE()" 
\t in configuration files to genarate kernel_cfg.c. )
\t Check configuration files and header files.

ERRMESSAGE
		;
		exit(1);
	}
	else {
		# xN^e[uɊ݃nho^
		#@@ ݃nh̑O"__kernel_""_entry"t
		$vector_table[$inhno] = "__kernel_" . $inthdr . "_entry";
	}
}	


#
#  IvV̏
#
do Getopt("s");

if ($opt_s == 0) {
	print STDERR "genvector.pl:\n";
	print STDERR "\t -s option(vector size) is necessary.\n";
	print STDERR "\t check jsp/config/h8/\$(SYS)/Makefile.config\n";
	exit(1);
}
	
$vector_size = $opt_s;

# sɂāAo^̊ݏ̋Lq؂蕪
if ($opt_z) {
	$no_reg_exception = "0";
}
else {
	$no_reg_exception = "_no_reg_exception";
}

for ($i=0; $i<$vector_size; $i++) {
	$vector_table[$i]=$no_reg_exception;
}

# ZbgxN^̒`
$vector_table[0] = "_start";

# ꂽXNvg̓ǂݍ
require "./tmp_script.pl";

# xN^e[ȕo
for ($i=0; $i<$vector_size; $i++) {
	printf "\t.long %s\t\t/* %d(0x%02x) */\n", $vector_table[$i], $i, $i;
}

