/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: kernellog.h,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

// KernelLog.h : CKernelLog ̐錾

#ifndef __KERNELLOG_H_
#define __KERNELLOG_H_

#include "resource.h"       // C V{
#include "devicemanagerCP.h"

/////////////////////////////////////////////////////////////////////////////
// CKernelLog
class ATL_NO_VTABLE CKernelLog : 
    public CComObjectRootEx<CComSingleThreadModel>,
    public CComCoClass<CKernelLog, &CLSID_KernelLog>,
    public IConnectionPointContainerImpl<CKernelLog>,
    public IKernelLog,
    public CProxy_IKernelLogEvents< CKernelLog >
{
public:
    CKernelLog();
    ~CKernelLog();

DECLARE_REGISTRY_RESOURCEID(IDR_KERNELLOG)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CKernelLog)
    COM_INTERFACE_ENTRY(IKernelLog)
    COM_INTERFACE_ENTRY(IConnectionPointContainer)
    COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
END_COM_MAP()
BEGIN_CONNECTION_POINT_MAP(CKernelLog)
CONNECTION_POINT_ENTRY(IID__IKernelLogEvents)
END_CONNECTION_POINT_MAP()


// IKernelLog
public:
};

#endif //__KERNELLOG_H_



#if 0

template <class T>
class CProxy_IKernelLogEvents : public IConnectionPointImpl<T, &IID__IKernelLogEvents, CComDynamicUnkArray>
{
public:
    bool onKernelStart_Performed;

    CProxy_IKernelLogEvents(void) : onKernelStart_Performed(false) {};

    //Warning this class may be recreated by the wizard.
public:
    HRESULT Fire_OnKernelStart()
    {
        HRESULT ret;
        T* pT = static_cast<T*>(this);
        int nConnectionIndex;
        int nConnections = m_vec.GetSize();
        
        for (nConnectionIndex = 0; nConnectionIndex < nConnections; nConnectionIndex++)
        {
            pT->Lock();
            CComPtr<IUnknown> sp = m_vec.GetAt(nConnectionIndex);
            pT->Unlock();
            _IKernelLogEvents* p_IKernelLogEvents = reinterpret_cast<_IKernelLogEvents*>(sp.p);
            if (p_IKernelLogEvents != NULL)
                ret = p_IKernelLogEvents->OnKernelStart();
        }
        onKernelStart_Performed = true;
        return ret;
    }

    HRESULT Fire_OnKernelExit()
    {
        HRESULT ret;
        T* pT = static_cast<T*>(this);
        int nConnectionIndex;
        int nConnections = m_vec.GetSize();
        
        for (nConnectionIndex = 0; nConnectionIndex < nConnections; nConnectionIndex++)
        {
            pT->Lock();
            CComPtr<IUnknown> sp = m_vec.GetAt(nConnectionIndex);
            pT->Unlock();
            _IKernelLogEvents* p_IKernelLogEvents = reinterpret_cast<_IKernelLogEvents*>(sp.p);
            if (p_IKernelLogEvents != NULL)
                ret = p_IKernelLogEvents->OnKernelExit();
        }
        onKernelStart_Performed = false;    
        return ret;
    }

    HRESULT Fire_OnLogEvent(LONG sz, unsigned char * data)
    {
        HRESULT ret;
        T* pT = static_cast<T*>(this);
        int nConnectionIndex;
        int nConnections = m_vec.GetSize();
        
        for (nConnectionIndex = 0; nConnectionIndex < nConnections; nConnectionIndex++)
        {
            pT->Lock();
            CComPtr<IUnknown> sp = m_vec.GetAt(nConnectionIndex);
            pT->Unlock();
            _IKernelLogEvents* p_IKernelLogEvents = reinterpret_cast<_IKernelLogEvents*>(sp.p);
            if (p_IKernelLogEvents != NULL)
            {
                if(!onKernelStart_Performed)
                    p_IKernelLogEvents->OnKernelStart();
                ret = p_IKernelLogEvents->OnLogEvent(sz, data);
            }
        }
        onKernelStart_Performed = true; 
        return ret; 
    }
};
#endif