/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package context;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import parser.ParseResult;
import debug.SimpleTrace;
import debug.Trace;
import view.View;
import view.ViewList;

/**
 * stands for Iterator Context
 this type of context can iterate over a view so to enabtracee parsing, for examptracee.
 * @author mtomono
 */
public class IContext<T> extends Context<T> implements Iterator<View<T>> {
    ViewList<T> body;
    ListIterator<View<T>> iter;
    public View<T> view;
    LinkedList<ParseResult> stack;
    
    static public <T> IContext<T> c(List<T> list, int pre) {
        return new IContext(ViewList.reverse(View.pre(list, pre)));
    }
    
    public IContext(ViewList<T> list) {
        this.body = list;
        this.iter = list.listIterator();
        this.stack = new LinkedList<>();
    }
    
    public LinkedList<ParseResult> stack() {
        return stack;
    }
    
    @Override
    public IContext<T> setValues(Map<String, ?> values) {
        return (IContext<T>)super.setValues(values);
    }
    
    public int save() {
        return iter.nextIndex();
    }
    
    public void load(int position) {
        iter = body.listIterator(position);
    }
    
    public int getNextPosition() {
        return iter.nextIndex() + 1;
    }

    @Override
    public boolean hasNext() {
        return iter.hasNext();
    }
    
    public Optional<T> now() {
        return get(0);
    }
    
    public Optional<T> pre(int index) {
        return get(index);
    }
    
    public Optional<T> get(int index) {
        return view.get(index);
    }

    @Override
    public View<T> next() {
        view = iter.next();
        return view;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    
    //------ structure for debugging
    
    static Trace def = new SimpleTrace();
    public Trace trace = def;
    public IContext<T> setTrace(Trace parseTrace) {
        this.trace = parseTrace;
        return this;
    }
}
