/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import java.util.Iterator;
import java.util.function.Predicate;

/**
 *
 * @author mtomono
 */
public class SelectIterator<T> extends AbstractIterator<T> {
    Predicate<? super T> intension;
    Iterator<? extends T> body;
    public SelectIterator(Iterator<? extends T> body, Predicate<? super T> intension) {
        this.body = body;
        this.intension = intension;
    }
    @Override
    protected void findNext() {
        while (body.hasNext()) {
            T candidate = body.next();
            if (intension.test(candidate)) {
                nextFound(candidate);
                return;
            }
        }
    }
}
