/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package orderedSet;

import java.util.ListIterator;

/**
 *
 * @author mtomono
 */
public class RangeContainsRangeIterator<T extends Comparable<T>> extends ForAllRightWalker<Range<T>, Range<T>> {
    Order<T> order = Default.order;
    
    public RangeContainsRangeIterator(ListIterator<Range<T>> left, ListIterator<Range<T>> right) {
        super(left, right);
    }
    
    @Override
    public boolean leftCatchesRight(Range<T> left, Range<T> right) {
        return !left.isLowerThan(right);
    }

    @Override
    public boolean matches(Range<T> left, Range<T> right) {
        return left.contains(right);
    }

    @Override
    public boolean doesRightStay(Range<T> left, Range<T> right) {
        return false;
    }
}
