/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;
import collection.RingBuffer;
import java.util.Iterator;

/**
 * an iterator which holds given number of elements.
 * @author mtomono
 * @param <T>
 */
public class PreIterator<T> implements Iterator<T> {
    Iterator<T> body;
    RingBuffer<T> pre;
    
    
    public PreIterator(Iterator<T> body, int depth) {
        this.body = body;
        this.pre = new RingBuffer<>(depth);
    }
    
    public int getDepth() {
        return pre.size();
    }
    
    public int prefetch(int numberOfPrefetch) {
        for (int i = 0; i < numberOfPrefetch; i++) {
            if (this.body.hasNext()) {
                next();
            } else {
                return i;
            }
        }
        return numberOfPrefetch;
    }
    
    public static <T> PreIterator<T> createNextReady(Iterator<T> body, int numberOfPrefetch) {
        PreIterator<T> retval = new PreIterator(body, numberOfPrefetch + 1);
        retval.prefetch(numberOfPrefetch);
        return retval;
    }
        
    public RingBuffer<T> pre() {
        return pre;
    }
    
    public T pop(T t) {
        return pre.pop(t);
    }
    
    @Override
    public boolean hasNext() {
        return this.body.hasNext();
    }

    @Override
    public T next() {
        T retval = this.body.next();
        this.pre.push(retval);
        return retval;
    }
    
    public void load(T o) {
        this.pre.push(o);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}
