/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package orderedSet;

import java.util.ListIterator;

/**
 *
 * @author mtomono
 */
public class RangeOverlapsRangeIterator<T extends Comparable<T>> extends IfAnyRightWalker<Range<T>, Range<T>> {
    public RangeOverlapsRangeIterator(ListIterator<Range<T>> left, ListIterator<Range<T>> right) {
        super(left, right);
    }
    
    @Override
    public boolean leftCatchesRight(Range<T> left, Range<T> right) {
        return !left.isLowerThan(right);
    }

    @Override
    public boolean doesRightStay(Range<T> left, Range<T> right) {
        return left.endsLowerThan(right);
    }

    @Override
    public boolean matches(Range<T> left, Range<T> right) {
        return left.overlaps(right);
    }
}
