/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package parser;

import grammar.Grammar;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import orderedSet.Between;

/**
 *
 * @author mtomono
 */
public class ParseResult extends LinkedList{
    Grammar origin;
    int start;
    int end;
    boolean rangeSet;
    
    public ParseResult(Grammar origin) {
        this.origin = origin;
        this.rangeSet = false;
    }
    public ParseResult() {
        this(null);
    }
    
    public void setRange(int start, int end) {
        this.start = start;
        this.end = end;
        this.rangeSet = true;
    }
    
    public int getStart() {
        assert rangeSet;
        return start;
    }
    
    public int getEnd() {
        assert rangeSet;
        return end;
    }
    
    public boolean hasRange() {
        return rangeSet;
    }
    
    public Between getRange() {
        assert rangeSet;
        return new Between(start, end);
    }
    
    public <T> List<T> flatten() {
        List<T> retval = new ArrayList<>();
        this.<T>flatten(retval);
        return retval;
    }
    public <T> void flatten(List<T> list) {
        for (Object o : this) {
            if (o instanceof ParseResult) {
                ((ParseResult)o).flatten(list);
            } else {
                list.add((T)o);
            }
        }
    }
}
