
var Ctrl = enchant.Class.create({
	initialize: function (){
		this.game = null;
		this.menuBg = null;
		this.currentCommand = ECommand.WORLD_CURSOR;
		this.backgroundMap = null;
		this.player = null;
	},
	init : function (game){
		this.game = game;
	},
	setMenuBg: function (menuBg){
		console.log("setMenuBg");
		this.menuBg = menuBg;
	},
	setBackgroundMap: function(backgroundMap){
		this.backgroundMap = backgroundMap;
	},
	setPlayer: function(player){
		this.player = player;
	},
	/**
	 * [setCurrentCommand description]
	 * @param {ECommand} cmd [description]
	 */
	setCurrentCommand: function(cmd){
		this.currentCommand = cmd;
	},
	getCurrentCommand: function(){
		return this.currentCommand;
	}
});
var CommandIcon = enchant.Class.create(enchant.Sprite,{
	initialize: function (x, y, ecmd, index){
		enchant.Sprite.call(this, x, y);
		this.ecmd = ecmd;
		this.index = index;
	},
	isCurrent: function(){
		return (this.index * 2)%2 !== 0;
	},
	setCurrent: function(){
		this.frame = (this.index * 2) + 1;
	},
	removeCurrent: function(){
		this.frame = (this.index * 2);
	}
});
var MangIcon = enchant.Class.create({
	initialize: function (ctl, menuBg){
		var self = this;
		this.ctl = ctl;
		this.cmdIcons = [];
		var index = 0;
		for (var key in ECommand) {
			var value = ECommand[key];
			this.cmdIcons[value] = new CommandIcon(40, 40, value, index);
			this.cmdIcons[value].image = this.ctl.game.assets[EResPath.COMMAND];
			this.cmdIcons[value].x = 40 * index;
			this.cmdIcons[value].y = 4;

			// odd equals current. even equals not current.
			this.cmdIcons[value].frame = (this.ctl.getCurrentCommand() == value)? index * 2 + 1: index * 2;
			menuBg.addChild(this.cmdIcons[value]);
			this.cmdIcons[value].ontouchstart = function(obj){
				// change command icons
				var nowECmd = self.ctl.getCurrentCommand();
				self.cmdIcons[nowECmd].removeCurrent();
				if(!this.isCurrent()){
					this.setCurrent();
				}
				self.ctl.setCurrentCommand(this.index);
			};
			index++;
		}
	},
	get: function(commandIndex){
		return this.cmdIcons[commandIndex];
	}
});
var ATouchEvent = enchant.Class.create({
	// initialize: function (ctl){
	// 	this.ctl = ctl;
	// },
	touchstart: function(e){
	},
	touchmove: function(e){
	},
	touchend: function(e){
	}
});

var WorldCursorTouchEvent = enchant.Class.create(ATouchEvent,{
	initialize: function (ctl){
		this.ctl = ctl;
		this.touchX = 0;
		this.touchY = 0;
	},
	touchstart : function(e){
		this.touchX = e.x - this.ctl.backgroundMap.x;
		this.touchY = e.y - this.ctl.backgroundMap.y;
	},
	touchmove : function(e){
		var backgroundMap = this.ctl.backgroundMap;
		var game = this.ctl.game;

		if(game.touched){
			backgroundMap.x = e.x - this.touchX;
			if(backgroundMap.x < -EFieldPos.WIDTH)backgroundMap.x = -EFieldPos.WIDTH;
			if(backgroundMap.x > 0)backgroundMap.x = 0;

			backgroundMap.y = e.y - this.touchY;
			if(backgroundMap.y < -EFieldPos.HEIGHT)backgroundMap.y = -EFieldPos.HEIGHT;
			if(backgroundMap.y > 0)backgroundMap.y = 0;
		}
		if(e.x > EFieldPos.WIDTH)game.touched = false;
		else if(e.x < 30)game.touched = false;
	},
	touchend : function(e){
	}
});
var WorldTargetTouchEvent = enchant.Class.create(ATouchEvent,{
	initialize: function (ctl){
		this.ctl = ctl;
		this.touchX = 0;
		this.touchY = 0;
	},
	touchstart :function(e){
		if(e.x >= 0 && e.x <= EFieldPos.WIDTH){
			var backgroundMap = this.ctl.backgroundMap;
			addEffect(this.ctl.backgroundMap, -backgroundMap.x + e.x, -backgroundMap.y + e.y);
			this.ctl.player.tweet("ゆっくりりかいしたよ！");
			// this.ctl.player.tweet("ゆー...いきたくないのぜ");
		}
	}
});

var MangTouch = enchant.Class.create({
	initialize: function (ctl){
		this.ctl = ctl;
		var cursor = ECommand.WORLD_CURSOR;
		this.mang = {};
		this.mang[ECommand.WORLD_CURSOR] = new WorldCursorTouchEvent(ctl);
		this.mang[ECommand.WORLD_TARGET] = new WorldTargetTouchEvent(ctl);
	},
	get: function(ecmd){
		return this.mang[ecmd];
	}
});
var MangLabel = enchant.Class.create({
	initialize: function (ctl, menuBg){
		this.ctl = ctl;
		var labelGroup = new LabelGroup();
		this.START_XPOS = 4;
		this.START_YPOS = GAME_HEIGHT / 2;
		this.GAUGE_XPOS = 80;
		this.menuBg = menuBg;
		this.widthArr = [];
		this.WIDTH_MARGIN = 4;
		this.GAUGE_HEIGHT = 16;
		var FONT = "18px 'Times New Roman'";
		var COLOR = "#ffffff";
		menuBg.image.context.font = FONT;
		var self = this;
		// this.labels = {};
		this.labelParams = {
			"yukkuri" : {
				label: null,
				init: function(){
					var TEXT = "ゆっくり";
					var label = new Label(TEXT);
					label.color = COLOR;
					label.font = FONT;
					label.x = self.START_XPOS;
					label.y = self.START_YPOS;
					label.textWidth = menuBg.image.context.measureText(TEXT).width;
					this.label = label;
				},
				draw: function(yukkuriObj){
					//100/maxhp*hp
					var gauge = 100 / yukkuriObj.param.maxYukkuri * yukkuriObj.param.yukkuri;
					self.menuBg.image.context.fillStyle = "#ffffff";
					self.menuBg.image.context.fillRect(self.GAUGE_XPOS, this.label.y, 100, self.GAUGE_HEIGHT);
					self.menuBg.image.context.fillStyle = "#ff0000";
					self.menuBg.image.context.fillRect(self.GAUGE_XPOS, this.label.y, gauge, self.GAUGE_HEIGHT);
				}
			},
			"hungry" : {
				label: null,
				init: function(){
					var TEXT = "空腹";
					var label = new Label(TEXT);
					label.color = COLOR;
					label.font = FONT;
					label.x = self.START_XPOS;
					label.y = self.START_YPOS + 20;
					label.textWidth = menuBg.image.context.measureText(TEXT).width;
					this.label = label;
				},
				draw: function(yukkuriObj){
					var gauge =yukkuriObj.param.hungry;
					self.menuBg.image.context.fillStyle = "#ffffff";
					self.menuBg.image.context.fillRect(self.GAUGE_XPOS, this.label.y, 100, self.GAUGE_HEIGHT);
					self.menuBg.image.context.fillStyle = "#bb7777";
					self.menuBg.image.context.fillRect(self.GAUGE_XPOS, this.label.y, gauge, self.GAUGE_HEIGHT);
				}
			},
			"unun" : {
				label: null,
				init: function(){
					var TEXT = "うんうん";
					var label = new Label(TEXT);
					label.color = COLOR;
					label.font = FONT;
					label.x = self.START_XPOS;
					label.y = self.START_YPOS + 40;
					label.textWidth = menuBg.image.context.measureText(TEXT).width;
					this.label = label;
				},
				draw: function(yukkuriObj){
					var gauge =yukkuriObj.param.unun;
					self.menuBg.image.context.fillStyle = "#ffffff";
					self.menuBg.image.context.fillRect(self.GAUGE_XPOS, this.label.y, 100, self.GAUGE_HEIGHT);
					self.menuBg.image.context.fillStyle = "#bb7777";
					self.menuBg.image.context.fillRect(self.GAUGE_XPOS, this.label.y, gauge, self.GAUGE_HEIGHT);
				}
			},
			"sleep" : {
				label: null,
				init: function(){
					var TEXT = "眠気";
					var label = new Label(TEXT);
					label.color = COLOR;
					label.font = FONT;
					label.x = self.START_XPOS;
					label.y = self.START_YPOS + 60;
					label.textWidth = menuBg.image.context.measureText(TEXT).width;
					this.label = label;
				},
				draw: function(yukkuriObj){
					var gauge =yukkuriObj.param.unun;
					self.menuBg.image.context.fillStyle = "#ffffff";
					self.menuBg.image.context.fillRect(self.GAUGE_XPOS, this.label.y, 100, self.GAUGE_HEIGHT);
					self.menuBg.image.context.fillStyle = "#bb7777";
					self.menuBg.image.context.fillRect(self.GAUGE_XPOS, this.label.y, gauge, self.GAUGE_HEIGHT);
				}
			},
			"stress" : {
				label: null,
				init: function(){
					var TEXT = "ストレス";
					var label = new Label(TEXT);
					label.color = COLOR;
					label.font = FONT;
					label.x = self.START_XPOS;
					label.y = self.START_YPOS + 80;
					label.textWidth = menuBg.image.context.measureText(TEXT).width;
					this.label = label;
				},
				draw: function(yukkuriObj){
					var gauge =yukkuriObj.param.stress;
					self.menuBg.image.context.fillStyle = "#ffffff";
					self.menuBg.image.context.fillRect(self.GAUGE_XPOS, this.label.y, 100, self.GAUGE_HEIGHT);
					self.menuBg.image.context.fillStyle = "#bb7777";
					self.menuBg.image.context.fillRect(self.GAUGE_XPOS, this.label.y, gauge, self.GAUGE_HEIGHT);
				}
			},
		};

		this.menuBg.image.context.fillStyle = '#ff0000';
		for(var key in this.labelParams){
			var labelObj = this.labelParams[key];
			labelObj.init();
			labelGroup.addChild(labelObj.label);
		}
		menuBg.addChild(labelGroup);
	},
	draw: function(yukkuriObj){
		for(var key in this.labelParams){
			var labelObj = this.labelParams[key];
			labelObj.draw(yukkuriObj);
		}

	}
});


// var MangLabel = enchant.Class.create({
// 	initialize: function (ctl, menuBg){
// 		this.ctl = ctl;
// 		var labelGroup = new LabelGroup();
// 		this.START_XPOS = 4;
// 		this.START_YPOS = GAME_HEIGHT / 2;
// 		this.menuBg = menuBg;
// 		this.widthArr = [];
// 		this.WIDTH_MARGIN = 4;
// 		var FONT = "14px 'Times New Roman'";
// 		var COLOR = "#ffffff";
// 		menuBg.image.context.font = FONT;
// 		var self = this;
// 		this.labels = {
// 			"yukkuri" : function(){
// 				var TEXT = "ゆっくり";
// 				var label = new Label(TEXT);
// 				label.color = COLOR;
// 				label.font = FONT;
// 				label.x = self.START_XPOS;
// 				label.y = self.START_YPOS;
// 				label.textWidth = menuBg.image.context.measureText(TEXT).width;
// 			},
// 			"hungry" : function(){
// 				var TEXT = "空腹";
// 				var label = new Label(TEXT);
// 				label.color = COLOR;
// 				label.font = FONT;
// 				label.x = self.START_XPOS;
// 				label.y = self.START_YPOS + 20;
// 				label.textWidth = menuBg.image.context.measureText(TEXT).width;
// 				return label;
// 			},
// 		};

// 		this.labels["yukkuri"]();
// 		console.log(this.labels["yukkuri"]().textWidth);
// 		// for(var key in this.labels){
// 		// 	console.log(key);
// 		// 	var label = this.labels[key]();
// 		// 	// labelGroup.addChild(label);
// 		// }
// 		// var width = this.widthArr['yukkuri'];
// 		// this.menuBg.image.context.fillStyle = '#ff0000';
// 		// this.menuBg.image.context.fillRect(this.START_XPOS + width, this.START_YPOS, 100, 30);
// 		// menuBg.addChild(labelGroup);
// 	},
// 	draw: function(){
// 		label = this.labels[key]();
// 		this.menuBg.image.context.fillStyle = '#ff0000';
// 		this.menuBg.image.context.fillRect(label.x, label.y, 100, 14);
// 	}
// });
