// throw "exit";
enchant();
//////////////////////////////////////
//global
var ctl = null;
var mangIcon = null;
var mangTouch = null;
var mangLabel = null;
var LabelGroup = enchant.Class.mixClasses(Label, Group,true);
//////////////////////////////////////
//define
//////////////////////////////////////
const PALYER_INIT_X = 100;
const PALYER_INIT_Y = 100;
const CHARA_WIDTH = 64;
const CHARA_HEIGHT = 64;
const GAME_WIDTH = 800;
const GAME_HEIGHT = 600;
var EResPath = {
	YUKKURI_BASE : './data/yukkuri_base.png',
	YUKKURI_SHADOW : './data/shadow.png',
	MARISA_FACE_NORMAL : './data/marisa/face_normal.png',
	MARISA_FACE_TIRED : './data/marisa/face_tired.png',
	MARISA_HEAR : './data/marisa/hear.png',
	OBJECT : './data/object.png',
	MAP0 : './data/map0.png',
	COMMAND : './data/command.png',
	OKAZARI : './data/okazari.png',
}
var ECommand = {
	WORLD_CURSOR: 0,
	WORLD_TARGET: 1,
}

var EMenuPos = {
	X : 600,
	Y : 0,
	WIDTH : 200,
	HEIGHT : GAME_HEIGHT,
}
var EFieldPos = {
	X : 0,
	Y : 0,
	WIDTH: GAME_WIDTH - EMenuPos.WIDTH,
	HEIGHT: GAME_HEIGHT,
}
var EAction = {
	WAIT : 0,
	SLEEP : 1,
	EAT : 2,
	HUNT : 3,
	THINK : 4,
	WALK : 5,
	DEAD: 6,
}
var EDirection = {
	LEFT : 0,
	RIGHT: 1,
}
window.onload = function(){


	//init game
	var SpriteGroup = enchant.Class.mixClasses(Sprite, Group,true);
	var menuBg = new SpriteGroup(EMenuPos.WIDTH, EMenuPos.HEIGHT);
	var fieldBg = new enchant.Sprite(EFieldPos.WIDTH, EFieldPos.HEIGHT);
	var game = new Game(GAME_WIDTH, GAME_HEIGHT);
	var _loadArr = [];
	var i=0;
	for(var _v in EResPath){
		_loadArr[i] = EResPath[_v];
		i++;
	}
	game.preload(_loadArr);
	var MapGroup = enchant.Class.mixClasses(Map, Group,true);
	var backgroundMap = new MapGroup(16, 16);
	include("./class.js");
	include("./ctrl.js");
	ctl = new Ctrl();
	ctl.init(game);
	ctl.setBackgroundMap(backgroundMap);
	function Action(yukkuri){
		this.status = EAction.THINK;
		// this.status = EAction.EAT;
		this.yukkuri = yukkuri;
		this.isMoving = false;
		this.act = function(){
			if(yukkuri.isDead()){
				this.status = EAction.DEAD;
			}

			switch(this.status){
				case EAction.THINK:
					// this.status = EAction.WALK;
					// yukkuri.moveTo(120, 120, 30);
					if(yukkuri.age%10 == 0)this.search();
				break;
				//Random Walk
				case EAction.WALK:
					this.walk();
				break;
				case EAction.DEAD:
					this.dead();
				break;
			}
		}
		this.walk = function(retryCounter=0){
			if(retryCounter > 15){
				retryCounter = 0;
				this.status = EAction.EAT;
				console.log("retryCount over");
				return;
			}
			if(yukkuri.imgGroup.tl.queue.length == 0){
				var frame = 200;
				if(this.isMoving){
					this.isMoving = false;
					this.status = EAction.THINK;
					yukkuri.vx = 0;
					yukkuri.vy = 0;
				}else{
					// this.isMoving = true;
					var xpos = 150 - (retryCounter * 10);
					var ypos = 150 - (retryCounter * 10);
					if(rand(8) == 0){
						yukkuri.vx = 0;
						yukkuri.vy = -ypos;
					}
					else if(rand(8) == 1){
						yukkuri.vx = xpos;
						yukkuri.vy = -ypos;
						yukkuri.direction = EDirection.RIGHT;
					}
					else if(rand(8) == 2){
						yukkuri.vx = xpos;
						yukkuri.vy = 0;
						yukkuri.direction = EDirection.RIGHT;
					}
					else if(rand(8) == 3){
						yukkuri.vx = xpos;
						yukkuri.vy = ypos;
						yukkuri.direction = EDirection.RIGHT;
					}
					else if(rand(8) == 4){
						yukkuri.vx = 0;
						yukkuri.vy = ypos;
					}
					else if(rand(8) == 5){
						yukkuri.vx = -xpos;
						yukkuri.vy = ypos;
						yukkuri.direction = EDirection.LEFT;
					}
					else if(rand(8) == 6){
						yukkuri.vx = -xpos;
						yukkuri.vy = 0;
						yukkuri.direction = EDirection.LEFT;
					}
					else if(rand(8) == 7){
						yukkuri.vx = -xpos;
						yukkuri.vy = -ypos;
						yukkuri.direction = EDirection.LEFT;
					}
					if (yukkuri.vx || yukkuri.vy) {
						var map = ctl.backgroundMap;
						// var x = yukkuri.x + (yukkuri.moveX ? yukkuri.moveX / Math.abs(yukkuri.moveX) * 16 : 0) + 16;
						// var y = yukkuri.y + (yukkuri.moveY ? yukkuri.moveY / Math.abs(yukkuri.moveY) * 16 : 0) + 16;
						var x = yukkuri.imgGroup.x + yukkuri.vx;
						var y = yukkuri.imgGroup.y + yukkuri.vy + yukkuri.height / 2;
						if (0 <= x && x < map.width && 0 <= y && y < map.height && !map.hitTest(x, y)) {
							// console.log("あたってないよ:"+ yukkuri.imgGroup.x + ":" + yukkuri.imgGroup.y);
							// console.log("X:" + yukkuri.moveX);
							// console.log("Y:" + yukkuri.moveY);
							this.isMoving = true;
							yukkuri.reverse();;
							yukkuri.moveBy(yukkuri.vx, yukkuri.vy, frame);
						}else{
							// console.log("HIT:"+ yukkuri.imgGroup.x + ":" + yukkuri.imgGroup.y);
							arguments.callee(retryCounter+1);
						}
					}
				}
			}
		}
		this.dead = function(){
			yukkuri.tweet("もっとゆっくりしたかった…");
			yukkuri.imgBody.tl.clear();
			yukkuri.imgBody.tl.pause();
			yukkuri.imgGroup.tl.clear();
			yukkuri.imgGroup.tl.pause();
			// yukkuri.imgBody.tl.unloop();
			// yukkuri.imgBody.tl.removeFromScene();
			// yukkuri.imgGroup.tl.removeFromScene();
		}
		this.search = function(){
			this.status =  EAction.WALK;
			return;
			for (var i = 0, l = game.rootScene.childNodes.length; i < l; i++) {
				var node = game.rootScene.childNodes[i];
				if (node instanceof Food) {

					if(this.yukkuri.within(node, this.yukkuri.range)){
						// console.log("yes:");
					}else{
						// console.log("no:");
					}
				}
			}
		}
	}
	var Food = enchant.Class.create(enchant.Sprite,{
		initialize: function (type, x, y){
			enchant.Sprite.call(this,16,16);
			this.image = game.assets[EResPath.OBJECT];
			this.frame = 15;
			this.x = x;
			this.y = y;
			// this.moveTo(180, 252);
			backgroundMap.addChild(this);
		}
	});
	var Okazari = enchant.Class.create(enchant.Sprite,{
		initialize: function(){
			enchant.Sprite.call(this, 64, 64);
			this.image = game.assets[EResPath.OKAZARI];
			this.x = -CHARA_WIDTH / 2;;
			this.y = -12 - CHARA_HEIGHT / 2;
		}
	});
	var Yukkuri = enchant.Class.create(enchant.Sprite,{
		initialize: function(x, y){
			this.imgGroup = new Group();
			this.imgBody = new Group();
			enchant.Sprite.call(this, 64, 64);
			this.x = -CHARA_WIDTH / 2;
			this.y = -CHARA_HEIGHT / 2;
			this.vx = 0;
			this.vy = 0;
			this.image = game.assets[EResPath.YUKKURI_BASE];
			this.direction = EDirection.RIGHT;
			this.addEventListener('enterframe', this.runEnterframe);
		},
		runEnterframe:function(){
			this.runYukkuri();
			this.runHungry();
		},
		reverse:function(){
			if(this.direction == EDirection.RIGHT){
				this.imgBody.scaleX = 1;
			}
			else if(this.direction == EDirection.LEFT){
				this.imgBody.scaleX = -1;
			}
		},
		tweet:function(text){
			this._tweet.text(text, this.x - this._tweet.width/4, this.y - this._tweet.height);
		},
		moveTo:function(x, y, time){
			this.imgGroup.tl.moveTo(x, y, time, enchant.Easing.SIN_EASEINOUT);
		},
		moveBy:function(x, y, time){
			this.imgGroup.tl.moveBy(x, y, time, enchant.Easing.SIN_EASEINOUT);

		},
		act: function(){
			this.action.act();
		},
		animation: function(){
			this.imgBody.tl.moveBy(0, -5, 10, enchant.Easing.SWING).moveBy(0, 5, 10, enchant.Easing.SWING).loop();
			// this.tl.moveBy(0, -5, 10, enchant.Easing.SWING).moveBy(0, 5, 10, enchant.Easing.SWING).loop();
			// this.okazari.tl.moveBy(0, -5, 10, enchant.Easing.SWING).moveBy(0, 5, 10, enchant.Easing.SWING).loop();
			// this.face.tl.moveBy(0, -5, 10, enchant.Easing.SWING).moveBy(0, 5, 10, enchant.Easing.SWING).loop();
			// this.hear.tl.moveBy(0, -5, 10, enchant.Easing.SWING).moveBy(0, 5, 10, enchant.Easing.SWING).loop();
		},
		moveX: function(x){
			this.imgGroup.x += x;
			// this.x += x;
			// this.shadow.x += x;
			// this._tweet.x += x;
		},
		moveY: function(y){
			this.imgGroup.y += y;
			// this.y += y;
			// this.shadow.y += y;
			// this._tweet.y += y;
		},
		changeFace: function(erespath){
			this.face.image = game.assets[erespath];
		},
		loadParamsXML: function(url){
			var http = new JKL.ParseXML( url );
			return http.parse();
		},
		runYukkuri: function(){
			if(this.param.hungry > 70){
				if(this.age%(50 - this.param.hungry - 70) == 0 && this.age != 0){
					this.param.yukkuri -= 1;
				}
			}
			else if(this.param.hungry < 10){
				if(this.age%50 == 0 && this.age != 0) this.param.yukkuri += 1;
			}

			if(this.param.yukkuri <= 0)this.param.yukkuri = 0;
			else if(this.param.yukkuri >= this.param.maxYukkuri)this.param.yukkuri = this.param.maxYukkuri;
		},
		runHungry: function(){
			if(this.age%100 == 0 && this.age != 0)this.param.hungry++;
			if(this.param.hungry >= 100)this.param.hungry = 100;
		},
		isDead: function(){
			return this.param.yukkuri <= 0;
		},
		destruct: function(){

		}
	});
	var Marisa = enchant.Class.create(Yukkuri,{
		initialize: function(x, y){
			Yukkuri.call(this,x,y);
			var xml = this.loadParamsXML("./data/marisa/params.xml");
			this.param = xml.root.param;
			this.range = 200;
			this.shadow = new enchant.Sprite(64, 64);
			this.shadow.image = game.assets[EResPath.YUKKURI_SHADOW];
			this.shadow.x = 0 + this.x;
			this.shadow.y = CHARA_HEIGHT / 16 + this.x;

			this.face = new enchant.Sprite(64, 64);
			this.face.image = game.assets[EResPath.MARISA_FACE_NORMAL];
			this.face.x = -CHARA_WIDTH / 2;
			this.face.y = -CHARA_HEIGHT / 2;

			this.hear = new enchant.Sprite(64, 64);
			this.hear.image = game.assets[EResPath.MARISA_HEAR];
			this.hear.x = -CHARA_WIDTH / 2;
			this.hear.y = -CHARA_HEIGHT / 2;

			this.okazari = new Okazari();

			this.imgGroup.addChild(this.shadow);
			this.imgBody.addChild(this);
			this.imgBody.addChild(this.face);
			this.imgBody.addChild(this.hear);
			this.imgBody.addChild(this.okazari);
			this.imgGroup.addChild(this.imgBody);
			backgroundMap.addChild(this.imgGroup);
			this.action = new Action(this);
			this._tweet = new TTweet(148, 64);


			this.imgGroup.addChild(this._tweet);
			this.imgGroup.x = x;
			this.imgGroup.y = y;
			this.animation();

		}
	});
	var Player = enchant.Class.create(Marisa,{
		initialize: function(x, y){
			// this.runEnterframe = function(){
			// },
			Marisa.call(this, x, y);
			ctl.setPlayer(this);
			// this.removeEventListener('enterframe',this.runEnterframe);
			this.addEventListener('enterframe', function(){
				if(this.age%10 == 0 && this.age != 0){
					// console.log("palyer:" + this.age);
				}
				this.act();

				//Action pattern for debug
				if(game.input.left){
					this.changeFace(EResPath.MARISA_FACE_TIRED);
					this.moveX(-10);
					this.direction = EDirection.LEFT;
				}
				if(game.input.right){
					this.moveX(10);
					this.direction = EDirection.RIGHT;
				}
				if(game.input.up){
					this.moveY(-10);
					// this.tweet("ゆっくりしていってね！");
				}
				if(game.input.down){
					this.moveY(10);
				}
				this.reverse();
				// if(ctl.backgroundMap.hitTest(this.imgGroup.x, this.imgGroup.y + this.height / 2)){
				// 	console.log("hit:" + this.imgGroup.x + ":" +  (this.imgGroup.y + this.height/2) );
				// }else{
				// 	console.log("not:" + this.imgGroup.x + ":" +  (this.imgGroup.y + this.image.height/2));
				// }
				//- Display the circle of search range.
				// fieldBg.image.clear();
				// fieldBg.image.context.beginPath();
				// fieldBg.image.context.fillStyle = '#ff0000';
				// fieldBg.image.context.arc(this.imgGroup.x + this.width/2, this.imgGroup.y + this.height/2, this.range, Math.PI * 2, false);
				// fieldBg.image.context.fill();
			});
		}
	});
	game.onload = function(){
		mangTouch = new MangTouch(ctl);
		backgroundMap.image = game.assets[EResPath.MAP0];
		backgroundMap.loadData(_mapData);
		backgroundMap.collisionData = _collisionData;

		var menuSurface = new enchant.Surface(EMenuPos.WIDTH, EMenuPos.HEIGHT);
		var fieldSurface = new enchant.Surface(EFieldPos.WIDTH, EFieldPos.HEIGHT);
		fieldBg.image = fieldSurface;
		fieldBg.x = 0;
		fieldBg.y = 0;

		menuSurface.context.fillStyle = '#000';
		menuSurface.context.fillRect(0, 0, EMenuPos.WIDTH, EMenuPos.HEIGHT);
		menuBg.image = menuSurface;
		menuBg.x = EMenuPos.X;
		menuBg.y = EMenuPos.Y;

		backgroundMap.addChild(fieldBg);
		mangIcon = new MangIcon(ctl, menuBg);

		game.rootScene.addChild(backgroundMap);
		game.rootScene.addChild(menuBg);

		// var labelGroup = new LabelGroup();
		mangLabel = new MangLabel(ctl, menuBg);
		// var info = new Label("ゆっくり");
		// info.color = "#ffffff";
		// info.font = "14px 'Times New Roman'";
		// info.x = 4;
		// info.y = GAME_HEIGHT / 2;
		// labelGroup.addChild(info);
		// menuBg.addChild(labelGroup);


		var food = new Food("apple", 200, 250);
		var player = new Player(PALYER_INIT_X, PALYER_INIT_Y);
		var touchX = 0;

		game.rootScene.addEventListener('touchstart', function (e) {
			game.touched = true;
			var mang = mangTouch.get(ctl.getCurrentCommand());
			mang.touchstart(e);
		});
		game.rootScene.addEventListener('touchmove', function (e) {
			var mang = mangTouch.get(ctl.getCurrentCommand());
			mang.touchmove(e);
		});
		game.rootScene.addEventListener('touchend', function (e) {
			var mang = mangTouch.get(ctl.getCurrentCommand());
			mang.touchend(e);
			game.touched = false;
		});


		game.rootScene.addEventListener('enterframe', function(){
			 //main frame
			mangLabel.draw(player);
		});
	};
	game.start();
};