package ter.diagram.editor;

import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

import ter.diagram.editor.figure.EntityBaseFigure;
import ter.diagram.editor.figure.IdentifierLabel;

public final class EntityBaseDirectEditUtil {
	public static final boolean directEditNameHitTest(Point location, EntityBaseFigure figure) {
		IFigure nameFigure = figure.getEntityName();
		if (nameFigure.containsPoint(location)) {
			System.out.println("directEditNameHitTest() hit");
			return true;
		}
		return false;
	}
	public static final boolean directEditTypeHitTest(Point location, EntityBaseFigure figure) {
		IFigure typeFigure = figure.getEntityType();
		if (typeFigure.containsPoint(location)) {
			System.out.println("directEditTypeHitTest() hit");
			return true;
		}
		return false;
	}
	public static final boolean directEditIdentifierHitTest(Point location, EntityBaseFigure figure) {
//		IFigure identifierFigure = figure.getIdentifier();
//		if (identifierFigure.containsPoint(location)) {
//			System.out.println("directEditIdentifierHitTest() hit");
//			return true;
//		}
//		return false;
		System.out.println("directEditIdentifierHitTest()");
		List identifieres = figure.getIdentifierContainerFigure().getChildren();
		for (Iterator it = identifieres.iterator();it.hasNext();) {
			IdentifierLabel idFigure = (IdentifierLabel)it.next();
			System.out.println(idFigure.getLocation());
			System.out.println(idFigure.getPreferredSize());
			if (idFigure.containsPoint(location)) {
				System.out.println("directEditIdentifierHitTest() hit");
				return true;
			}
		}
		return false;
	}
	public static final boolean directEditIdentifierHitTest2(Point location, EntityBaseFigure figure) {
//		IFigure identifierFigure = figure.getIdentifier();
//		if (identifierFigure.containsPoint(location)) {
//			System.out.println("directEditIdentifierHitTest() hit");
//			return true;
//		}
//		return false;
		System.out.println("directEditIdentifierHitTest2()");
		List identifieres = figure.getIdentifierContainerFigure().getChildren();
		System.out.println(figure.getIdentifierContainerFigure().getBounds().getCopy().getLocation());
		for (Iterator it = identifieres.iterator();it.hasNext();) {
			IdentifierLabel idFigure = (IdentifierLabel)it.next();
			Rectangle p = idFigure.getBounds().getCopy();
			idFigure.translateToAbsolute(p);
			Rectangle er = figure.getBounds().getCopy();
			figure.translateToAbsolute(p);
			System.out.println(idFigure.getLocation());
			System.out.println(p);
			System.out.println(idFigure.getLocation());
			System.out.println(idFigure.getPreferredSize());
			if (idFigure.containsPoint(location)) {
				System.out.println("directEditIdentifierHitTest() hit");
				return true;
			} else if (p.equals(location)) {
				System.out.println("directEditIdentifierHitTest() hit");
				return true;
				
			}
		}
		return false;
	}
	public static int getDirectEditIdentifierHitTestIndex(Point location, EntityBaseFigure figure) {
		List identifieres = figure.getIdentifierContainerFigure().getChildren();
		int idx = -1;
		Iterator it = identifieres.iterator();
		while (it.hasNext()) {
			IdentifierLabel idFigure = (IdentifierLabel)it.next();
			idx++;
			if (idFigure.containsPoint(location.x, location.y)) {
				System.out.println("directEditIdentifierHitTest() hit:"+ idx);
				return idx;
			}
		}
		return -1;
	}
	
	public static IFigure getDirectEditIdentifierHitTest(Point location, EntityBaseFigure figure) {
		List identifieres = figure.getIdentifierContainerFigure().getChildren();
		int idx = -1;
		for (Iterator it = identifieres.iterator();it.hasNext();) {
			IdentifierLabel idFigure = (IdentifierLabel)it.next();
			idx++;
			if (idFigure.containsPoint(location)) {
				System.out.println("directEditIdentifierHitTest() hit:"+ idx);
				return idFigure;
			}
		}
		return null;
	}
}
