/**
 * 
 */
package ter.diagram.editor.directedit;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Text;

/**
 * @author ctc
 *
 */
public class EntityBaseNameCellEditorLocator implements CellEditorLocator {

	private IFigure figure;
	
	public EntityBaseNameCellEditorLocator(IFigure figure) {
		this.figure = figure;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.gef.tools.CellEditorLocator#relocate(org.eclipse.jface.viewers.CellEditor)
	 */
	public void relocate(CellEditor cellEditor) {
		Text text = (Text)cellEditor.getControl();
		Rectangle rect = figure.getBounds().getCopy();
		figure.translateToAbsolute(rect);
		text.setBounds(rect.x, rect.y, rect.width + 1, rect.height + 1);
	}

}
