package ter.diagram.editor.editpart;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;

import ter.diagram.editor.editpolicy.RelationshipEditPolicy;
import ter.diagram.editor.editpolicy.RelationshipEndpointEditPolicy;
import ter.diagram.editor.model.RelationshipConnection;

public class RelationshipEditPart extends AbstractConnectionEditPart implements PropertyChangeListener{

	public RelationshipEditPart() {
		super();
		// TODO Auto-generated constructor stub
	}

	protected void createEditPolicies() {
		installEditPolicy(
				EditPolicy.CONNECTION_ENDPOINTS_ROLE, new RelationshipEndpointEditPolicy());
		installEditPolicy(
				EditPolicy.CONNECTION_ROLE, new RelationshipEditPolicy());
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.editparts.AbstractConnectionEditPart#createFigure()
	 */
	protected IFigure createFigure() {
		// TODO Auto-generated method stub
//		return super.createFigure();
		PolylineConnection connection = new PolylineConnection();
		ManhattanConnectionRouter router = new ManhattanConnectionRouter();
		connection.setConnectionRouter(router);
		PolylineDecoration sourceDecoration = new PolylineDecoration();
		PolylineDecoration targetDecoration = new PolylineDecoration();
		PointList pointList = new PointList();
		pointList.addPoint(-2, 2);
		pointList.addPoint(-2, -2);
		pointList.addPoint(0, 0);
		sourceDecoration.setTemplate(pointList);
		targetDecoration.setTemplate(pointList);
		connection.setSourceDecoration(sourceDecoration);
		connection.setTargetDecoration(targetDecoration);
		
		return connection;
	}

	public void propertyChange(PropertyChangeEvent evt) {

		
	}

	@Override
	public void activate() {
		super.activate();
		((RelationshipConnection)getModel()).addPropertyChangeListener(this);
	}

	@Override
	public void deactivate() {
		super.deactivate();
		((RelationshipConnection)getModel()).removePropertyChangeListener(this);
	}

}
