/**
 * 
 */
package ter.diagram.editor.editpolicy;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.jface.viewers.TextCellEditor;

import ter.diagram.editor.EntityBaseDirectEditUtil;
import ter.diagram.editor.directedit.EntityBaseNameCellEditorLocator;
import ter.diagram.editor.directedit.EntityBaseNameDirectEditManager;
import ter.diagram.editor.directedit.EntityBaseTypeCellEditorLocator;
import ter.diagram.editor.directedit.EntityBaseTypeDirectEditManager;
import ter.diagram.editor.directedit.EntityTypeCellEditor;
import ter.diagram.editor.figure.EntityBaseFigure;
import ter.diagram.editor.figure.IdentifierLabel;
import ter.diagram.editor.model.EntityBase;
import ter.diagram.editor.model.Identifier;
import ter.diagram.editor.model.command.CreateIdentifierCommand;
import ter.diagram.editor.model.command.EntityBaseIdentifierDirectEditCommand;
import ter.diagram.editor.model.command.EntityBaseNameDirectEditCommand;
import ter.diagram.editor.model.command.EntityBaseTypeDirectEditCommand;

/**
 * @author ctc
 *
 */
public class EntityBaseDirectEditPolicy extends DirectEditPolicy {

	/* (non-Javadoc)
	 * @see org.eclipse.gef.editpolicies.DirectEditPolicy#getDirectEditCommand(org.eclipse.gef.requests.DirectEditRequest)
	 */
	@Override
	protected Command getDirectEditCommand(DirectEditRequest req) {
		org.eclipse.swt.graphics.Point orgLocation = req.getCellEditor().getControl().getLocation();
		Point location = new Point(orgLocation);

		EntityBase entity = (EntityBase)getHost().getModel();
		Command returnCommand = null;
		System.out.println(location);
		if (EntityBaseDirectEditUtil.directEditNameHitTest(location, getEntityBaseFigure())) {
			EntityBaseNameDirectEditCommand command = new EntityBaseNameDirectEditCommand();
			
			command.setEntity(entity);
			command.setOldName(entity.getName());
			command.setNewName((String)req.getCellEditor().getValue());
			returnCommand = command;
		} else if (EntityBaseDirectEditUtil.directEditTypeHitTest(location, getEntityBaseFigure())) {
			EntityBaseTypeDirectEditCommand command = new EntityBaseTypeDirectEditCommand();
			command.setEntity(entity);
			command.setOldEntityType(entity.getEntityType());
			command.setNewEntityType((Integer)req.getCellEditor().getValue());
			returnCommand = command;
		} else if (EntityBaseDirectEditUtil.directEditIdentifierHitTest2(location, getEntityBaseFigure())) {
			int idx = EntityBaseDirectEditUtil.getDirectEditIdentifierHitTestIndex(location, getEntityBaseFigure());

			EntityBaseIdentifierDirectEditCommand command = 
				new EntityBaseIdentifierDirectEditCommand(
						entity,
						(Identifier)entity.getIdentifieres().get(idx),
						(String)req.getCellEditor().getValue()
						);
//			command.setEntity(entity);
//			command.setOldIdentifier((Identifier)entity.getIdentifieres().get(idx));
//			Identifier identifier = new Identifier(entity);
//			identifier.setName((String)req.getCellEditor().getValue());
//			command.setNewIdentifier(identifier);
			returnCommand = command;
		} else {
			System.out.println("EntityBaseDirectEditPolicy.getDirectEditCommand() Not Hit");
		}
		return returnCommand;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.editpolicies.DirectEditPolicy#showCurrentEditValue(org.eclipse.gef.requests.DirectEditRequest)
	 */
	@Override
	protected void showCurrentEditValue(DirectEditRequest arg0) {
		// TODO 自動生成されたメソッド・スタブ

	}

	private EntityBaseFigure getEntityBaseFigure() {
		return (EntityBaseFigure) getHostFigure();
	}
}
