package ter.diagram.editor.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class RelationshipConnection extends AbstractRelationshipModel implements IPropertySource{
	private String sourceCardinarity = "1" ;
	private String targetCardinarity = "1";
	private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
	public static final String P_SOURCE_CARDINARITY = "_source_cardinarity";
	public static final String P_TARGET_CARDINARITY = "_target_cardinarity";
	
	public RelationshipConnection() {
		super();
		// TODO Auto-generated constructor stub
	}

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		listeners.addPropertyChangeListener(listener);
	}
	
	public void firePropertyChange(String propName, Object oldValue, Object newValue) {
		listeners.firePropertyChange(propName, oldValue, newValue);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		listeners.removePropertyChangeListener(listener);
	}

	public String getSourceCardinarity() {
		return sourceCardinarity;
	}

	public void setSourceCardinarity(String sourceCardinarity) {
		String oldSource = this.sourceCardinarity;
		this.sourceCardinarity = sourceCardinarity;
		firePropertyChange(P_SOURCE_CARDINARITY, oldSource, sourceCardinarity);
	}

	public String getTargetCardinarity() {
		return targetCardinarity;
	}

	public void setTargetCardinarity(String targetCardinarity) {
		String oldTarget = this.targetCardinarity;
		this.targetCardinarity = targetCardinarity;
		firePropertyChange(P_TARGET_CARDINARITY, oldTarget, targetCardinarity);
	}

	public Object getEditableValue() {
		return this;
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		IPropertyDescriptor[] descriptors =
			new IPropertyDescriptor[] {
				new TextPropertyDescriptor(P_SOURCE_CARDINARITY, "多重度:ソース"),
				new TextPropertyDescriptor(P_TARGET_CARDINARITY, "多重度:ターゲット")				
		};
		return descriptors;
	}

	public Object getPropertyValue(Object id) {
		if (id.equals(P_SOURCE_CARDINARITY)) {
			return sourceCardinarity;
		} else if (id.equals(P_TARGET_CARDINARITY)) {
			return targetCardinarity;
		}
		return null;
	}

	public boolean isPropertySet(Object id) {
		if (id.equals(P_SOURCE_CARDINARITY)) {
			return true;
		} else if (id.equals(P_TARGET_CARDINARITY)) {
			return true;
		}
		return false;
	}

	public void resetPropertyValue(Object id) {
		// TODO Auto-generated method stub
		
	}

	public void setPropertyValue(Object id, Object value) {
		if (id.equals(P_SOURCE_CARDINARITY)) {
			setSourceCardinarity((String) value);
		} else if (id.equals(P_TARGET_CARDINARITY)) {
			setTargetCardinarity((String) value);
		}
	}

}
