/**
 * 
 */
package ter.diagram.editor.model.command;

import org.eclipse.gef.commands.Command;

import ter.diagram.editor.model.Attribute;
import ter.diagram.editor.model.EntityBase;

/**
 * @author ctc
 *
 */
public class AttributeDeleteCommand extends Command
{
    private EntityBase entity;
    private Attribute attribute;
    private int index = -1;
    
    /**
     * 
     */
    public AttributeDeleteCommand()
    {
        super();
        // TODO Auto-generated constructor stub
    }

    /* (non-Javadoc)
     * @see org.eclipse.gef.commands.Command#canExecute()
     */
    @Override
    public boolean canExecute()
    {
        if (entity.getAttributes().size() > 1) {
            return true;
        }
        return true;    
    }

    /* (non-Javadoc)
     * @see org.eclipse.gef.commands.Command#execute()
     */
    @Override
    public void execute()
    {
        index = entity.getAttributes().indexOf(attribute);
        entity.removeAttribute(attribute);
    }

    /* (non-Javadoc)
     * @see org.eclipse.gef.commands.Command#undo()
     */
    @Override
    public void undo()
    {
        entity.addAttribute(attribute, index);
    }

    /**
     * @param attribute The attribute to set.
     */
    public void setAttribute(Attribute attribute)
    {
        this.attribute = attribute;
    }

    /**
     * @param entity The entity to set.
     */
    public void setEntity(EntityBase entity)
    {
        this.entity = entity;
    }
    
}
