package ter.diagram.editor.model.command;

import java.util.List;

import org.eclipse.gef.commands.Command;

import ter.diagram.editor.model.RelationshipConnection;
import ter.diagram.editor.model.EntityBase;
import ter.diagram.editor.model.Identifier;

public class CreateRelationshipCommand extends Command {
	private EntityBase source, target;
	private RelationshipConnection relationship;
	private List reuseSourceIds, reuseTargetIds;
	
	public CreateRelationshipCommand() {
		super();
		// TODO Auto-generated constructor stub
	}

	public CreateRelationshipCommand(String label) {
		super(label);
		// TODO Auto-generated constructor stub
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.commands.Command#canExecute()
	 */
	public boolean canExecute() {
		if (source == null || target == null ) {
			return false;
		}
		if (source.equals(target)) {
			return false;
		}
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.commands.Command#execute()
	 */
	public void execute() {
		relationship.attachSource();
		relationship.attachTarget();
		
		if ((source.getEntityType() == EntityBase.ENTITY_TYPE_EVENT) &&
			(target.getEntityType() == EntityBase.ENTITY_TYPE_RESOURCE)) {
//			relationship.getReuseTargetId().setEntity(source);
			source.addIdentifier(relationship.getReuseTargetId());	
			}
		if ((target.getEntityType() == EntityBase.ENTITY_TYPE_EVENT) &&
			(source.getEntityType() == EntityBase.ENTITY_TYPE_RESOURCE)) {
//			relationship.getReuseSourceId().setEntity(target);
			target.addIdentifier(relationship.getReuseSourceId());	
		}
			
	}

//	private Identifier createReUseKey(EntityBase base, EntityBase original) {
//		Identifier identifier = new Identifier(base);
//		identifier.setName(((Identifier)original.getIdentifieres().get(0)).getName());
//		return identifier;
//	}
	public void setRelationship(Object model) {
		relationship = (RelationshipConnection) model;
	}
	
	public void setSource(Object model) {
		source = (EntityBase) model;
		relationship.setSource(source);
	}
	
	public void setTarget(Object model) {
		target = (EntityBase) model;
		relationship.setTarget(target);
	}

	public EntityBase getSource() {
		return source;
	}

	public EntityBase getTarget() {
		return target;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.commands.Command#undo()
	 */
	public void undo() {
		relationship.detachSource();
		relationship.detachTarget();
	}

	/**
	 * @param reuseSourceIds the reuseSourceIds to set
	 */
	public void setReuseSourceIds(List reuseSourceIds) {
		this.reuseSourceIds = reuseSourceIds;
	}

	/**
	 * @param reuseTargetIds the reuseTargetIds to set
	 */
	public void setReuseTargetIds(List reuseTargetIds) {
		this.reuseTargetIds = reuseTargetIds;
	}
}
