/**
 * 
 */
package tm.tmdiagram.tmdeditor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.DeleteRetargetAction;
import org.eclipse.gef.ui.actions.RedoRetargetAction;
import org.eclipse.gef.ui.actions.UndoRetargetAction;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import tm.tmdiagram.tmdeditor.editpart.RelationshipDialog;
import tm.tmdiagram.tmdeditor.editpart.TMDEditPartFactory;
import tm.tmdiagram.tmdeditor.model.AbstractEntityModel;
import tm.tmdiagram.tmdeditor.model.ConnectableElement;
import tm.tmdiagram.tmdeditor.model.Diagram;
import tm.tmdiagram.tmdeditor.model.Entity;
import tm.tmdiagram.tmdeditor.model.Relationship;
import tm.tmdiagram.tmdeditor.model.AbstractEntityModel.EntityType;
import tm.tmdiagram.tmdeditor.model.command.ConnectionCreateCommand;
import tm.tmdiagram.tmdeditor.model.command.EntityCreateCommand;
import tm.tmdiagram.tmdeditor.model.command.Event2EventConnectionCreateCommand;

/**
 * @author hnakajima
 * 
 */
public class TMDEditor extends GraphicalEditorWithPalette {

	/**
	 * 
	 */
	public TMDEditor() {
		super();
		setEditDomain(new DefaultEditDomain(this));
		getActionRegistry().registerAction(new UndoRetargetAction());
		getActionRegistry().registerAction(new RedoRetargetAction());
		getActionRegistry().registerAction(new DeleteRetargetAction());
	}

	@Override
	protected void initializeGraphicalViewer() {
		GraphicalViewer viewer = getGraphicalViewer();
		// TODO t@CIuWFNg擾
		Diagram diagram = new Diagram();
		viewer.setContents(diagram);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.ui.parts.GraphicalEditorWithPalette#getPaletteRoot()
	 */
	@Override
	protected PaletteRoot getPaletteRoot() {
		PaletteRoot root = new PaletteRoot();

		PaletteGroup toolGroup = new PaletteGroup("c[");

		ToolEntry tool = new SelectionToolEntry();
		toolGroup.add(tool);
		root.setDefaultEntry(tool);

		tool = new MarqueeToolEntry();
		toolGroup.add(tool);

		PaletteDrawer drawer = new PaletteDrawer("쐬");

		ImageDescriptor descriptor = TMDPlugin
				.getImageDescriptor("icons/newModel.gif");

		CreationToolEntry creationEntry = new CreationToolEntry("GeBeB",
				"GeBeB", new SimpleFactory(Entity.class), descriptor,
				descriptor);
		drawer.add(creationEntry);

		descriptor = TMDPlugin.getImageDescriptor("icons/newConnection.gif");

		ConnectionCreationToolEntry connxCCreationEntry = new ConnectionCreationToolEntry(
				"[VVbv", "[VVbv",
				new SimpleFactory(Relationship.class), descriptor, descriptor);
		drawer.add(connxCCreationEntry);

		root.add(toolGroup);
		root.add(drawer);

		return root;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.part.EditorPart#doSave(org.eclipse.core.runtime.IProgressMonitor)
	 */
	@Override
	public void doSave(IProgressMonitor monitor) {
		// TODO t@CփIuWFNgۑ
	}

	@Override
	protected void configureGraphicalViewer() {
		super.configureGraphicalViewer();
		GraphicalViewer viewer = getGraphicalViewer();
		viewer.setEditPartFactory(new TMDEditPartFactory());
		// when entity create, show dialog and set properties.

		getCommandStack().addCommandStackEventListener(
				new CommandStackEventListener() {

					/*
					 * (non-Javadoc)
					 * 
					 * @see org.eclipse.gef.commands.CommandStackEventListener#stackChanged(org.eclipse.gef.commands.CommandStackEvent)
					 */
					@Override
					public void stackChanged(CommandStackEvent event) {
						EntityCreateCommand command = null;
						if (event.getCommand() instanceof EntityCreateCommand) {
							command = (EntityCreateCommand) event.getCommand();
						} else {
							return;
						}

						System.out.println(getClass().toString()
								+ "#stackChanged():PreChangeEvent");
						if (event.getDetail() == CommandStack.PRE_EXECUTE
								|| event.getDetail() == CommandStack.PRE_REDO) {
							if (command.getEntityName() == null) {
								EntityCreateDialog dialog = new EntityCreateDialog(
										getGraphicalViewer().getControl()
												.getShell());
								if (dialog.open() == Dialog.OK) {
									System.out
											.println(getClass().toString()
													+ "#stackChanged():dialog.open() == Dialog.OK)");
									command.setIdentifierName(dialog
											.getIdentifierName());
									command
											.setEntityName(createEntityName(dialog
													.getIdentifierName()));
									EntityType entityType = dialog.getEntityType();
									command.setEntityType(entityType);
									if (entityType.equals(EntityType.E)) {
										command.setTransactionDate(command.getEntityName() + "");
									} else {
										command.setTransactionDate(""); // _~[BŏB
									}
									
								}
							}
						}
					}
				});
		getCommandStack().addCommandStackEventListener(
				new CommandStackEventListener() {

					@Override
					public void stackChanged(CommandStackEvent event) {
						Event2EventConnectionCreateCommand command = null;
						if (event.getCommand() instanceof Event2EventConnectionCreateCommand) {
							command = (Event2EventConnectionCreateCommand) event
									.getCommand();
						} else {
							return;
						}
						if (event.getDetail() == CommandStack.PRE_EXECUTE
								|| event.getDetail() == CommandStack.PRE_REDO) {
							ConnectableElement source = command.getSource();
							ConnectableElement target = command.getTarget();
							if (source instanceof Entity
									&& target instanceof Entity) {
								AbstractEntityModel sourceEntity = (AbstractEntityModel) source;
								AbstractEntityModel targetEntity = (AbstractEntityModel) target;
								RelationshipDialog dialog = new RelationshipDialog(
										getGraphicalViewer().getControl()
												.getShell(), sourceEntity
												.getName(), targetEntity
												.getName());
								if (dialog.open() == Dialog.OK) {
									Relationship relationship = (Relationship) command
											.getConnection();
									relationship.setSourceCardinality(dialog
											.getSourceCardinality());
									relationship.setTargetCardinality(dialog
											.getTargetCardinality());
								}
							}
						}
					}

				});
	}

	private String createEntityName(String identifierName) {
		String[] suffixes = { "R[h", "ID", "hc", "id", "", "ԍ" };
		String[] reportSuffixes = { "`[", "񍐏", "", "|[g" };
		String entityName = identifierName;
		for (String suffix : suffixes) {
			if (identifierName.endsWith(suffix)) {
				entityName = identifierName.substring(0, identifierName
						.lastIndexOf(suffix));
				break;
			}
		}
		for (String reportSuffix : reportSuffixes) {
			if (entityName.endsWith(reportSuffix)) {
				entityName = entityName.substring(0, entityName
						.lastIndexOf(reportSuffix));
				break;
			}
		}
		return entityName;
	}

	private class EntityCreateDialog extends Dialog {
		private String identifierName;
		private Text identifierNameText;
		private EntityType entityType = EntityType.R;

		protected EntityCreateDialog(Shell parentShell) {
			super(parentShell);
			// TODO Auto-generated constructor stub
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
		 */
		@Override
		protected Control createDialogArea(Composite parent) {
			getShell().setText("GeBeBVK쐬");
			Composite composite = new Composite(parent, SWT.NULL);
			composite.setLayout(new GridLayout(2, false));
			composite.setLayoutData(new GridData(GridData.FILL_BOTH));

			Label label = new Label(composite, SWT.NULL);
			label.setText("Fmԍ");
			identifierNameText = new Text(composite, SWT.BORDER);
			identifierNameText.setLayoutData(new GridData(
					GridData.FILL_HORIZONTAL));

			label = new Label(composite, SWT.NULL);
			label.setText("ޕ");

			Group group = new Group(composite, SWT.SHADOW_OUT);
			group.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			group.setBounds(-1, -1, -1, -1);
			Button r = new Button(group, SWT.RADIO);
			r.setText("\[X");
			r.setBounds(5, 10, 50, 20);
			r.addSelectionListener(new SelectionListener() {

				/*
				 * (non-Javadoc)
				 * 
				 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
				 */
				@Override
				public void widgetDefaultSelected(SelectionEvent e) {
				}

				/*
				 * (non-Javadoc)
				 * 
				 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
				 */
				@Override
				public void widgetSelected(SelectionEvent e) {
					System.out.println("R widgetSelected");
					Button bBut = (Button) e.widget;
					if (bBut.getSelection()) {
						entityType = EntityType.R;
					}
				}

			});
			Button e = new Button(group, SWT.RADIO);
			e.setText("Cxg");
			e.setBounds(70, 10, 50, 20);
			e.addSelectionListener(new SelectionListener() {

				/*
				 * (non-Javadoc)
				 * 
				 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
				 */
				@Override
				public void widgetDefaultSelected(SelectionEvent e) {
					// TODO Auto-generated method stub

				}

				/*
				 * (non-Javadoc)
				 * 
				 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
				 */
				@Override
				public void widgetSelected(SelectionEvent e) {
					System.out.println("E widgetSelected");
					Button bBut = (Button) e.widget;
					if (bBut.getSelection()) {
						entityType = EntityType.E;
					}
				}

			});
			r.setSelection(true);

			return composite;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.dialogs.Dialog#okPressed()
		 */
		@Override
		protected void okPressed() {
			this.identifierName = this.identifierNameText.getText();
			super.okPressed();
		}

		/**
		 * @return the identifierName
		 */
		public String getIdentifierName() {
			return identifierName;
		}

		/**
		 * @return the entityType
		 */
		public EntityType getEntityType() {
			return entityType;
		}

	}
}
