package tm.tmdiagram.tmdeditor.editpart;

import java.util.List;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;

import tm.tmdiagram.tmdeditor.figure.EntityFigure;
import tm.tmdiagram.tmdeditor.model.AbstractEntityModel;
import tm.tmdiagram.tmdeditor.model.Attribute;
import tm.tmdiagram.tmdeditor.model.CombinationTable;
import tm.tmdiagram.tmdeditor.model.ConnectionBendpoint;
import tm.tmdiagram.tmdeditor.model.Entity;
import tm.tmdiagram.tmdeditor.model.Identifier;
import tm.tmdiagram.tmdeditor.model.MappingList;
import tm.tmdiagram.tmdeditor.model.RecursiveConnection;
import tm.tmdiagram.tmdeditor.model.RecursiveTable;
import tm.tmdiagram.tmdeditor.model.RelatedRelationship;
import tm.tmdiagram.tmdeditor.model.Relationship;
import tm.tmdiagram.tmdeditor.model.AbstractEntityModel.EntityType;
import tm.tmdiagram.tmdeditor.model.command.ConnectionCreateCommand;
import tm.tmdiagram.tmdeditor.model.command.Event2EventConnectionCreateCommand;
import tm.tmdiagram.tmdeditor.model.command.ModelCreateCommand;
import tm.tmdiagram.tmdeditor.model.command.Resource2EventConnectionCreateCommand;

public class EntityEditPart extends AbstractEntityEditPart {

	@Override
	protected IFigure createFigure() {
		EntityFigure figure = new EntityFigure();
		updateFigure(figure);
		return figure;
	}

	private void updateFigure(EntityFigure figure) {
		Entity entity = (Entity)getModel();
		List<Identifier> ids = entity.getReuseKeys();
		Attribute[] atts = entity.getAttributes();
		figure.removeAllRelationship();
		figure.removeAllAttributes();

		figure.setEntityName(entity.getName());
		figure.setEntityType(entity.getEntityType().toString());
		figure.setIdentifier(entity.getIdentifier().getName());
		for (Identifier i : ids) {
			figure.addRelationship(i.getName());
		}
		for (Attribute a : atts) {
			figure.addAttribute(a.getName());
		}
	}

	@Override
	protected void refreshVisuals() {
		System.out.println(getClass().toString() + "#refreshVisuals()");
		super.refreshVisuals();
		Object model = getModel();
		Rectangle bounds = new Rectangle(((AbstractEntityModel) model)
				.getConstraint());
		((GraphicalEditPart) getParent()).setLayoutConstraint(this,
				getFigure(), bounds);
		updateFigure((EntityFigure) getFigure());
		refreshChildren();
	}

	@Override
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.COMPONENT_ROLE,
				new EntityComponentEditPolicy());
		installEditPolicy(EditPolicy.GRAPHICAL_NODE_ROLE,
				new EntityGraphicalNodeEditPolicy());
	}

	private class EntityGraphicalNodeEditPolicy extends GraphicalNodeEditPolicy {

		@Override
		protected Command getConnectionCompleteCommand(
				CreateConnectionRequest request) {
			System.out.println(getClass().toString()
					+ "#getConnectionCompleteCommand()");

			ConnectionCreateCommand startCommand = (ConnectionCreateCommand) request
					.getStartCommand();
			Entity source = (Entity) startCommand.getSource();
			Entity target = (Entity) getHost().getModel();

			Command command = null;
			// ċA
			if (source == target) {
				System.out.println("Recursive");
				command = createRecursiveTableCommand(request);
			} else if (isR2E(source, target)) {
				System.out.println("R:E");
				command = createR2ERelationshipCommand(startCommand);
				command.setLabel("R:E");
			} else if (isR2R(source, target)) {
				System.out.println("R:R");
				/* Ώƕ\쐬 */
				command = createCombinationTableCommand(request);
				command.setLabel("R:R");
			} else if (isE2E(source, target)) {
				System.out.println("E:E");
				/* ʏRlNV */
				command = createE2ERelationshipCommand(request);
				command.setLabel("E:E");
			}
			return command;
		}

		/**
		 * GeBeB̊֘AR:R𔻒肷B
		 * 
		 * @param source
		 * @param target
		 * @return R:ȐꍇtrueԂB
		 */
		private boolean isR2R(Entity source, Entity target) {
			return source.getEntityType().equals(EntityType.R)
					&& target.getEntityType().equals(EntityType.R);
		}

		/**
		 * GeBeB̊֘AR:E𔻒肷B
		 * @param source
		 * @param target
		 * @return R:ȄꍇtrueԂB
		 */
		private boolean isR2E(Entity source, Entity target) {
			return (source.getEntityType().equals(EntityType.E)
			&& target.getEntityType().equals(EntityType.R)) ||
			(source.getEntityType().equals(EntityType.R)
					&& target.getEntityType().equals(EntityType.E));
		}

		/**
		 * GeBeB̊֘AE:E𔻒肷B
		 * @param source
		 * @param target
		 * @return E:ȄꍇtrueԂB
		 */
		private boolean isE2E(Entity source, Entity target) {
			return source.getEntityType().equals(EntityType.E)
			&& target.getEntityType().equals(EntityType.E);		
		}
		/**
		 * ċA\쐬B
		 * @param request
		 * @return
		 */
		private Command createRecursiveTableCommand(
				CreateConnectionRequest request) {
			CompoundCommand ccomand = new CompoundCommand();

			// GeBeBƐGeBeBڑ
			ConnectionCreateCommand startCommand = (ConnectionCreateCommand) request
					.getStartCommand();
			// ċÃRlNV쐬
			startCommand.setTarget(getHost().getModel());
			//TODO ċÃRlNVVK쐬R}h𗘗p悤ɏC
			startCommand.setConnection(new RecursiveConnection());
			Entity source = (Entity) startCommand.getSource();
			Entity target = (Entity) startCommand.getTarget();
			startCommand.setSource(source);
			startCommand.setTarget(target);
			ccomand.add(startCommand);
			// bendpointݒ
			CreateBendPointCommand command1 = new CreateBendPointCommand();
			command1.setModel((RecursiveConnection) startCommand.getConnection());
			IFigure hostFigure = getHostFigure();
			command1.setSourceBounds(hostFigure.getBounds());
			ccomand.add(command1);

			// ċA\쐬
			ModelCreateCommand command2 = new ModelCreateCommand();
			Point p = request.getLocation();
			Rectangle constraint = hostFigure.getBounds().getCopy();
			Point center = constraint.getCenter();
			constraint.x = constraint.x + 100;
			constraint.height = -1;
			constraint.width = -1;
			command2.setDiagram(getHost().getParent().getModel());
			RecursiveTable table = new RecursiveTable();
			table.setConstraint(constraint);
			table.setName(source.getName() + "." + target.getName() + "." + "ċAƕ\");
			table.addReuseKey(new Identifier(source.getIdentifier().getName()));
			table.addReuseKey(new Identifier(target.getIdentifier().getName()));
			command2.setModel(table);
			ccomand.add(command2);

			// GeBeBƍċA\Ƃڑ
			ConnectionCreateCommand command3 = new ConnectionCreateCommand();
			command3.setConnection(new Relationship());
			command3.setSource(startCommand.getSource());
			command3.setTarget(table);
			ccomand.add(command3);
			return ccomand;

		}
		/* GeBeBƂ̃RlNV쐬 */
		private Command createRelationshipCommand(
				ConnectionCreateCommand command) {
			command.setTarget(getHost().getModel());
			return command;
		}
		/* CxgƃCxgƂ̃RlNV쐬 */
		private Command createE2ERelationshipCommand(CreateConnectionRequest request) {
			Point p = request.getLocation();

			// GeBeBƐGeBeBڑ
			ConnectionCreateCommand startCommand = (ConnectionCreateCommand) request
					.getStartCommand();
			startCommand.setTarget(getHost().getModel());
			Event2EventConnectionCreateCommand newCommand = new Event2EventConnectionCreateCommand();
			newCommand.setConnection(startCommand.getConnection());
			newCommand.setSource(startCommand.getSource());
			newCommand.setTarget(getHost().getModel());

			Entity source = (Entity) startCommand.getSource();
			Entity target = (Entity) startCommand.getTarget();

			// Ή\쐬
			Rectangle constraint = new Rectangle(p.x - 100, p.y + 100, -1, -1);
			newCommand.setDiagram(getHost().getParent().getModel());
			MappingList table = new MappingList();
			table.setConstraint(constraint);
			table.setName(source.getName() + "." + target.getName() + "." + "Ή\");
			table.addReuseKey(new Identifier(source.getIdentifier().getName()));
			table.addReuseKey(new Identifier(target.getIdentifier().getName()));
			newCommand.setModel(table);

			// \ƃRlN^ڑ
			newCommand.setRelationship(new RelatedRelationship());
			return newCommand;
		}

		/* \[XƃCxgƂ̃RlNV쐬 */
		private Command createR2ERelationshipCommand(
				ConnectionCreateCommand command) {
			Resource2EventConnectionCreateCommand newCommand = new Resource2EventConnectionCreateCommand();
			newCommand.setConnection(command.getConnection());
			newCommand.setSource(command.getSource());
			newCommand.setTarget(getHost().getModel());
			return newCommand;
		}

		/* Ώƕ\쐬 */
		private CompoundCommand createCombinationTableCommand(
				CreateConnectionRequest request) {
			
			CompoundCommand ccomand = new CompoundCommand();
			ModelCreateCommand command1 = new ModelCreateCommand();
			Point p = request.getLocation();

			// GeBeBƐGeBeBڑ
			ConnectionCreateCommand startCommand = (ConnectionCreateCommand) request
					.getStartCommand();
			startCommand.setTarget(getHost().getModel());
			((Relationship)startCommand.getConnection()).setCenterMard(true);
			ccomand.add(startCommand);

			Entity source = (Entity) startCommand.getSource();
			Entity target = (Entity) startCommand.getTarget();

			// Ώƕ\쐬
			Rectangle constraint = new Rectangle(p.x - 100, p.y + 100, -1, -1);
			command1.setDiagram(getHost().getParent().getModel());
			CombinationTable table = new CombinationTable();
			table.setConstraint(constraint);
			table.setName(source.getName() + "." + target.getName() + "." + "Ώƕ\");
			table.addReuseKey(new Identifier(source.getIdentifier().getName()));
			table.addReuseKey(new Identifier(target.getIdentifier().getName()));
			command1.setModel(table);
			ccomand.add(command1);

			// \ƃRlN^ڑ
			ConnectionCreateCommand command2 = new ConnectionCreateCommand();
			command2.setConnection(new RelatedRelationship());
			command2.setSource(startCommand.getConnection());
			command2.setTarget(table);
			ccomand.add(command2);
			return ccomand;
		}

		@Override
		protected Command getConnectionCreateCommand(
				CreateConnectionRequest request) {
			System.out.println(getClass().toString()
					+ "#getConnectionCreateCommand()");
			ConnectionCreateCommand command = new ConnectionCreateCommand();
			command.setConnection(request.getNewObject());
			command.setSource(getHost().getModel());
			request.setStartCommand(command);
			return command;
		}

		@Override
		protected Command getReconnectSourceCommand(ReconnectRequest request) {
			// TODO Auto-generated method stub
			System.out.println(getClass().toString()
					+ "#getReconnectSourceCommand()");
			return null;
		}

		@Override
		protected Command getReconnectTargetCommand(ReconnectRequest request) {
			// TODO Auto-generated method stub
			System.out.println(getClass().toString()
					+ "#getReconnectTargetCommand()");
			return null;
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#refresh()
	 */
	@Override
	public void refresh() {
		// TODO Auto-generated method stub
		System.out.println(getClass().toString() + "#refresh()");
		super.refresh();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#refreshSourceConnections()
	 */
	@Override
	protected void refreshSourceConnections() {
		// TODO Auto-generated method stub
		System.out.println(getClass().toString()
				+ "#refreshSourceConnections()");
		super.refreshSourceConnections();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#refreshTargetConnections()
	 */
	@Override
	protected void refreshTargetConnections() {
		// TODO Auto-generated method stub
		System.out.println(getClass().toString()
				+ "#refreshTargetConnections()");
		super.refreshTargetConnections();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.editparts.AbstractEditPart#refreshChildren()
	 */
	@Override
	protected void refreshChildren() {
		// TODO Auto-generated method stub
		System.out.println(getClass().toString() + "#refreshChildren()");
		super.refreshChildren();
	}

	public class CreateBendPointCommand extends Command {
		private RecursiveConnection model;
		private Rectangle bounds;
		public void setModel(RecursiveConnection model) {
			this.model = model;
		}
		public void setSourceBounds(Rectangle bounds) {
			this.bounds = bounds;
		}
		/* (non-Javadoc)
		 * @see org.eclipse.gef.commands.Command#execute()
		 */
		@Override
		public void execute() {
			int width = bounds.width / 2 + 20;
			int height = bounds.height / 2 ;
			ConnectionBendpoint bendpoint = new ConnectionBendpoint(
					new Dimension(0, 0), new Dimension(width, 0));
			model.addBendpoint(0, bendpoint);
			bendpoint = new ConnectionBendpoint(new Dimension(width, 0),
					new Dimension(width, height));
			model.addBendpoint(1, bendpoint);
			bendpoint = new ConnectionBendpoint(new Dimension(width, height),
					new Dimension(0, height));
			model.addBendpoint(2, bendpoint);

		}
		
	}
}
