package tm.tmdiagram.tmdeditor.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.BendpointLocator;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MidpointLocator;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.requests.BendpointRequest;

import tm.tmdiagram.tmdeditor.model.ConnectionBendpoint;
import tm.tmdiagram.tmdeditor.model.RecursiveConnection;

public class RecursiveConnectionEditPart extends AbstractRelationshipEditPart {

	/* (non-Javadoc)
	 * @see org.eclipse.gef.editparts.AbstractConnectionEditPart#createFigure()
	 */
	@Override
	protected IFigure createFigure() {
		PolylineConnection connection = new PolylineConnection();
	    connection.setConnectionRouter(new BendpointConnectionRouter());
	    return connection;
	}

	/* (non-Javadoc)
	 * @see tm.tmdiagram.tmdeditor.editpart.AbstractRelationshipEditPart#propertyChange(java.beans.PropertyChangeEvent)
	 */
	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		if (evt.getPropertyName().equals(RecursiveConnection.P_BEND_POINT)) {
			refleshBendpoints();
		}
		super.propertyChange(evt);
	}
	protected void refleshBendpoints() {
		List<ConnectionBendpoint> bendpoints = ((RecursiveConnection)getModel()).getBendpoints();
		List<Bendpoint> constraint = new ArrayList<Bendpoint>();
		
		for (int i = 0; i < bendpoints.size(); i++) {
			ConnectionBendpoint wbp = bendpoints.get(i);
			RelativeBendpoint rbp = new RelativeBendpoint(getConnectionFigure());
			rbp.setRelativeDimensions(wbp.getFirstRelativeDimension(), wbp.getSecondRelativeDimension());
			rbp.setWeight((i + 1) / ((float) constraint.size() + 1));
			constraint.add(rbp);
		}
		getConnectionFigure().setRoutingConstraint(constraint);
		Ellipse figure = new Ellipse();
		figure.setFill(false);
		figure.setBounds(new Rectangle(-1, -1, 15, 15));
		BendpointLocator locator = new BendpointLocator(getConnectionFigure(),1);
		getConnectionFigure().add(figure, locator);
	}
	
	/* (non-Javadoc)
	 * @see tm.tmdiagram.tmdeditor.editpart.AbstractRelationshipEditPart#refreshVisuals()
	 */
	@Override
	protected void refreshVisuals() {
		refleshBendpoints();
	}

	@Override
	protected void createEditPolicies() {
//		installEditPolicy(EditPolicy.CONNECTION_BENDPOINTS_ROLE, new RecursiveBendpointEditPolicy());

	}
	private class RecursiveBendpointEditPolicy extends BendpointEditPolicy {

		/* (non-Javadoc)
		 * @see org.eclipse.gef.editpolicies.BendpointEditPolicy#getCreateBendpointCommand(org.eclipse.gef.requests.BendpointRequest)
		 */
		@Override
		protected Command getCreateBendpointCommand(BendpointRequest request) {
			// TODO Auto-generated method stub
			return null;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.gef.editpolicies.BendpointEditPolicy#getDeleteBendpointCommand(org.eclipse.gef.requests.BendpointRequest)
		 */
		@Override
		protected Command getDeleteBendpointCommand(BendpointRequest request) {
			// TODO Auto-generated method stub
			return null;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.gef.editpolicies.BendpointEditPolicy#getMoveBendpointCommand(org.eclipse.gef.requests.BendpointRequest)
		 */
		@Override
		protected Command getMoveBendpointCommand(BendpointRequest request) {
			// TODO Auto-generated method stub
			return null;
		}
		
	}
}
