package tm.tmdiagram.tmdeditor.editpart;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class RelationshipDialog extends Dialog {
	private String sourceCardinality, targetCardinality;
	private String sourceName, targetName;
	private Combo sourceCardinalityCombo, targetCardinalityCombo;

	public RelationshipDialog(Shell parentShell, String sourceName, String targetName) {
		super(parentShell);
		this.sourceName = sourceName;
		this.targetName = targetName;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		getShell().setText("RelationshipVK쐬");
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(5,false));
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		Label label = new Label(composite, SWT.NULL);
		label.setText(sourceName);
		sourceCardinalityCombo = new Combo(composite, SWT.READ_ONLY);
		sourceCardinalityCombo.add("1");
		sourceCardinalityCombo.add("N");
		sourceCardinalityCombo.select(0);
		label = new Label(composite, SWT.NULL);
		label.setText(":");
		targetCardinalityCombo = new Combo(composite, SWT.READ_ONLY);
		targetCardinalityCombo.add("1");
		targetCardinalityCombo.add("N");
		targetCardinalityCombo.select(0);
		label = new Label(composite, SWT.NULL);
		label.setText(targetName);

		return composite;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#okPressed()
	 */
	@Override
	protected void okPressed() {
		this.sourceCardinality = sourceCardinalityCombo.getItem(sourceCardinalityCombo.getSelectionIndex());
		this.targetCardinality = targetCardinalityCombo.getItem(targetCardinalityCombo.getSelectionIndex());
		super.okPressed();
	}

	public String getSourceCardinality() {
		return sourceCardinality;
	}
	public String getTargetCardinality() {
		return targetCardinality;
	}
	
}
