package tm.tmdiagram.tmdeditor.editpart;

import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.MidpointLocator;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ConnectionEditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

import tm.tmdiagram.tmdeditor.figure.RelationshipFigure;
import tm.tmdiagram.tmdeditor.model.Relationship;
import tm.tmdiagram.tmdeditor.model.command.ConnectionDeleteCommand;

public class RelationshipEditPart extends AbstractRelationshipEditPart {
	@Override
	protected IFigure createFigure() {
		RelationshipFigure connection = new RelationshipFigure();
//		PolylineConnection connection = new PolylineConnection();
//		ManhattanConnectionRouter router = new ManhattanConnectionRouter();
//		connection.setConnectionRouter(router);
		updateFigure(connection);
//			PolylineDecoration sourceDecoration = new PolylineDecoration();
//			// 1̃J[fBieB
////			PointList onePointList = new PointList();
////			onePointList.addPoint(-2, 2);
////			onePointList.addPoint(-2, -2);
////			sourceDecoration.setTemplate(onePointList);
////			connection.setSourceDecoration(sourceDecoration);
//			
//			// 0̃J[fBieB
//			Ellipse figure = new Ellipse();
//			figure.setFill(false);
//			figure.setBounds(new Rectangle(-1, -1, 8, 8));
//			ConnectionEndpointLocator locator = new ConnectionEndpointLocator(connection,false);
//			locator.setUDistance(14);
//			locator.setVDistance(0);
//			connection.add(figure, locator);
//
//			// ÑJ[fBieB
//			PointList manyPointList = new PointList();
//			manyPointList.addPoint(0, 2);
//			manyPointList.addPoint(-2, 0);
//			manyPointList.addPoint(0, -2);
//			sourceDecoration.setTemplate(manyPointList);
//			connection.setSourceDecoration(sourceDecoration);		



//		connection.setTargetDecoration(new PolygonDecoration());
//		PolylineDecoration sourceDecoration = new PolylineDecoration();
//		PolylineDecoration targetDecoration = new PolylineDecoration();
//		PointList pointList = new PointList();
//		pointList.addPoint(-2, 2);
//		pointList.addPoint(-2, -2);
//		pointList.addPoint(0, 0);
//		sourceDecoration.setTemplate(pointList);
//		targetDecoration.setTemplate(pointList);
//		connection.setSourceDecoration(sourceDecoration);
//		connection.setTargetDecoration(targetDecoration);
		
		// Ώƕ\EΉ\̒fR[V
//		MidpointLocator locator = new MidpointLocator(connection, 1);
//		Ellipse figure = new Ellipse();
//		figure.setFill(false);
//		figure.setBounds(new Rectangle(-1, -1, 15, 15));
//		connection.add(figure, locator);

		return connection;
	}
	private void updateFigure(RelationshipFigure connection) {
		Relationship relationship = (Relationship) getModel();
		if (relationship.getSourceCardinality().equals("N")) {
			connection.setSouceCardinarityMany(true);
		}
		if (relationship.getTargetCardinality().equals("N")) {
			connection.setTargetCardinarityMany(true);
		}
		if (relationship.isCenterMard()) {
			System.out.println("has relate relationship.");
			connection.setVisibleCenterDecoration(true);
//			MidpointLocator locator = new MidpointLocator(connection, 1);
//			Ellipse figure = new Ellipse();
//			figure.setFill(false);
//			figure.setBounds(new Rectangle(-1, -1, 15, 15));
//			connection.add(figure, locator);
		} else {
			System.out.println("no relate relationship.");
			connection.setVisibleCenterDecoration(false);
		}
		if (relationship.getSource() == relationship.getTarget()) {
			connection.setRecursive(true);
		}
	}
	
	/* (non-Javadoc)
	 * @see tm.tmdiagram.tmdeditor.editpart.AbstractRelationshipEditPart#refreshVisuals()
	 */
	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((RelationshipFigure) getFigure());
	}
	@Override
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.CONNECTION_ENDPOINTS_ROLE,
				new ConnectionEndpointEditPolicy());

		installEditPolicy(EditPolicy.CONNECTION_ROLE,
				new ConnectionEditPolicy() {
					protected Command getDeleteCommand(GroupRequest request) {
						ConnectionDeleteCommand cmd = new ConnectionDeleteCommand();
						cmd.setConnection(getModel());
						return cmd;
					}
				});
	}
}
