package tm.tmdiagram.tmdeditor.figure;

import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.MidpointLocator;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class RelationshipFigure extends PolylineConnection {

	private boolean souceCardinarityMany ;
	private boolean targetCardinarityMany;
	private boolean visibleCenterDecoration;
	private boolean recursive;
	private Figure centerDecoration;
	public RelationshipFigure() {
		this(false, false);
	}

	public RelationshipFigure(boolean souceCardinarityMany, boolean targetCardinarityMany) {
		super();
		this.souceCardinarityMany = souceCardinarityMany;
		this.targetCardinarityMany = targetCardinarityMany;
		setConnectionRouter(new ManhattanConnectionRouter());
		changeSourceDecoration();
		changeTargetDecoration();
		changeCenterDecoration();
		
	}
	
	private Figure createCenterDecoration() {
		Ellipse figure = new Ellipse();
		figure.setFill(false);
		figure.setBounds(new Rectangle(-1, -1, 15, 15));
		return figure;
	}
	private void changeCenterDecoration() {
		if (visibleCenterDecoration) {
			if (this.centerDecoration == null) {
				this.centerDecoration = createCenterDecoration();
			}
			MidpointLocator locator = new MidpointLocator(this, 1);
			add(centerDecoration, locator);
		} else {
			if (this.centerDecoration != null) {
				remove(centerDecoration);
			}
		}
	}
	private void changeSourceDecoration() {
		RotatableDecoration decoration = null;
		if (souceCardinarityMany) {
			decoration = createCardinarityManyDecoration();
		} else {
			decoration = createCardinarityOneDecoration();
		}
		setSourceDecoration(decoration);
	}
	private void changeTargetDecoration() {
		RotatableDecoration decoration = null;
		if (targetCardinarityMany) {
			decoration = createCardinarityManyDecoration();
		} else {
			decoration = createCardinarityOneDecoration();
		}
		setTargetDecoration(decoration);
	}
	private RotatableDecoration createCardinarityManyDecoration() {
		PointList manyPointList = new PointList();
		manyPointList.addPoint(0, 2);
		manyPointList.addPoint(-1, 0);
		manyPointList.addPoint(0, -2);
		
		PolylineDecoration decoration = new PolylineDecoration();
		decoration.setTemplate(manyPointList);
		return decoration;
	}
	private void createZeroCardinarityDecoration() {
		Ellipse figure = new Ellipse();
		figure.setFill(false);
		figure.setBounds(new Rectangle(-1, -1, 8, 8));
		ConnectionEndpointLocator locator = new ConnectionEndpointLocator(this,false);
		locator.setUDistance(20);
		locator.setVDistance(0);
		add(figure, locator);
		PointList manyPointList = new PointList();
		manyPointList.addPoint(0, 2);
		manyPointList.addPoint(-24, 2);
		manyPointList.addPoint(-24, 0);
		PolylineDecoration decoration = new PolylineDecoration();
		decoration.setTemplate(manyPointList);
		setSourceDecoration(decoration);
	}
	private RotatableDecoration createCardinarityOneDecoration() {
		PointList onePointList = new PointList();
		onePointList.addPoint(-1, 2);
		onePointList.addPoint(-1, -2);
		
		PolylineDecoration decoration = new PolylineDecoration();
		decoration.setTemplate(onePointList);
		return decoration;
	}

	/**
	 * @return the souceCardinarityMany
	 */
	public boolean isSouceCardinarityMany() {
		return souceCardinarityMany;
	}
	/**
	 * @param souceCardinarityMany the souceCardinarityMany to set
	 */
	public void setSouceCardinarityMany(boolean souceCardinarityMany) {
		this.souceCardinarityMany = souceCardinarityMany;
		changeSourceDecoration();
	}
	/**
	 * @return the targetCardinarityMany
	 */
	public boolean isTargetCardinarityMany() {
		return targetCardinarityMany;
	}
	/**
	 * @param targetCardinarityMany the targetCardinarityMany to set
	 */
	public void setTargetCardinarityMany(boolean targetCardinarityMany) {
		this.targetCardinarityMany = targetCardinarityMany;
		changeTargetDecoration();
	}

	/**
	 * @return the visibleCenterDecoration
	 */
	public boolean isVisibleCenterDecoration() {
		return visibleCenterDecoration;
	}

	/**
	 * @param visibleCenterDecoration the visibleCenterDecoration to set
	 */
	public void setVisibleCenterDecoration(boolean visibleCenterDecoration) {
		this.visibleCenterDecoration = visibleCenterDecoration;
		changeCenterDecoration();
	}

	/**
	 * @return the recursive
	 */
	public boolean isRecursive() {
		return recursive;
	}

	/**
	 * @param recursive the recursive to set
	 */
	public void setRecursive(boolean recursive) {
		this.recursive = recursive;
		createZeroCardinarityDecoration();
	}
	
}
