package tm.tmdiagram.tmdeditor.model;

import java.util.ArrayList;
import java.util.List;


public class RecursiveConnection extends AbstractConnectionModel {
	private List<ConnectionBendpoint> bendpoints = new ArrayList<ConnectionBendpoint>();
	public static final String P_BEND_POINT = "_p_bend_point";
	
	public void addBendpoint(int index, ConnectionBendpoint point) {
		bendpoints.add(index, point);
		firePropertyChange(P_BEND_POINT, null, point);
	}
	public void removeBendpoint(int index) {
		ConnectionBendpoint removed = bendpoints.remove(index);
		firePropertyChange(P_BEND_POINT, removed, null);
	}
	public void replaceBendpoint(int index, ConnectionBendpoint point) {
		ConnectionBendpoint old = bendpoints.set(index, point);
		firePropertyChange(P_BEND_POINT, old, point);
	}
	/**
	 * @return the bendpoints
	 */
	public List<ConnectionBendpoint> getBendpoints() {
		return bendpoints;
	}
}
