package tm.tmdiagram.tmdeditor.model.command;

import org.eclipse.gef.commands.Command;

import tm.tmdiagram.tmdeditor.model.ConnectableElement;
import tm.tmdiagram.tmdeditor.model.Diagram;
import tm.tmdiagram.tmdeditor.model.Entity;
import tm.tmdiagram.tmdeditor.model.Identifier;
import tm.tmdiagram.tmdeditor.model.MappingList;
import tm.tmdiagram.tmdeditor.model.RelatedRelationship;
import tm.tmdiagram.tmdeditor.model.Relationship;

public class Event2EventConnectionCreateCommand extends Command {
	private Diagram diagram;
	private MappingList model;
	private Entity source, target;
	private Relationship connection;
	private RelatedRelationship relationship;

	@Override
	public boolean canExecute() {
		return source != null && target != null;
	}

	@Override
	public void execute() {
		System.out.println(getClass().toString() + "#execute()");
		connection.attachSource();
		connection.attachTarget();
		
		if (connection.getSourceCardinality().equals("N")) {
			diagram.addChild(model);
			
			relationship.setSource(connection);
			relationship.setTarget(model);
			connection.addSourceConnection(relationship);
			model.addTargetConnection(relationship);
		} else {
			target.addReuseKey(new Identifier(source.getIdentifier().getName()));
		}
	}

	@Override
	public void undo() {
		connection.detachSource();
		connection.detachTarget();
		if (connection.getSourceCardinality().equals("N")) {
			diagram.removeChild(model);
			connection.removeSourceConnection(relationship);
			model.removeTargetConnection(relationship);
		}
	}

	public void setDiagram(Object diagram) {
		this.diagram = (Diagram) diagram;
	}

	public void setModel(Object model) {
		this.model = (MappingList) model;
	}

	public void setConnection(Object connection) {
		this.connection = (Relationship) connection;
	}

	public void setSource(Object source) {
		this.source = (Entity) source;
		this.connection.setSource(this.source);
	}

	public void setTarget(Object target) {
		this.target = (Entity) target;
		this.connection.setTarget(this.target);
	}

	/**
	 * @return the connection
	 */
	public Relationship getConnection() {
		return connection;
	}

	/**
	 * @return the source
	 */
	public ConnectableElement getSource() {
		return source;
	}

	/**
	 * @return the target
	 */
	public ConnectableElement getTarget() {
		return target;
	}

	/**
	 * @param relationship the relationship to set
	 */
	public void setRelationship(RelatedRelationship relationship) {
		this.relationship = relationship;
	}
}
